/*
	AppHack - An Application Bundle Editor and Application Theme Tool for Mac OS X

    Copyright (C) 2004-2006 	Sveinbjorn Thordarson <sveinbjornt@simnet.is>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#import "DocTypeList.h"
#import "DocType.h"

@implementation DocTypeList

- (id) init
{
	if (self = [super init]) 
		list = [[NSMutableArray alloc] init];
	return self;
}

-(void)dealloc
{
	[list release];
	[super dealloc];
}

- (NSMutableArray *)array
{
	return list;
}

- (void)setArray: (NSMutableArray *)theArray
{
	if (list != NULL)
		[list release];
	list = theArray;
}

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	return([list count]);
}

- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
	if ([[aTableColumn identifier] caseInsensitiveCompare: @"Name"] == NSOrderedSame)
	{
		return([[list objectAtIndex: rowIndex] getDocTypeName]);
	}
	else if ([[aTableColumn identifier] caseInsensitiveCompare: @"Icon"] == NSOrderedSame)
	{
		if (rowIndex == 0)
		{
			NSImageCell* iconCell;
			iconCell = [[[NSImageCell alloc] init] autorelease];
			[aTableColumn setDataCell:iconCell];
			[iconCell setMenu: contextualMenu];
		}
		
		return([[list objectAtIndex: rowIndex] getIcon]);
	}
	return(@"");
}

- (void)tableView:(NSTableView *)aTableView setObjectValue: anObject forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
    if (rowIndex < 0 || rowIndex > [list count]-1)
		return;
		
    id item = [list objectAtIndex:rowIndex];
    [(DocType *)item setDocTypeName: anObject];
}



@end
