/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.time.Duration;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.ExecutionResult;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.OutputExecutionState;
import org.gradle.internal.execution.steps.CachingResult;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class SkipEmptyWorkStep<C extends PreviousExecutionContext>
implements Step<C, CachingResult> {
    private final Step<? super C, ? extends CachingResult> delegate;

    public SkipEmptyWorkStep(Step<? super C, ? extends CachingResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CachingResult execute(UnitOfWork work, C context) {
        ImmutableSortedMap previousOutputFiles = context.getPreviousExecutionState().map(OutputExecutionState::getOutputFilesProducedByWork).orElse(ImmutableSortedMap.of());
        UnitOfWork.Identity identity = context.getIdentity();
        return work.skipIfInputsEmpty((ImmutableSortedMap<String, FileSystemSnapshot>)previousOutputFiles).map(skippedOutcome -> {
            context.getHistory().ifPresent(history -> history.remove(identity.getUniqueId()));
            return new CachingResult((ExecutionOutcome)((Object)skippedOutcome), work, (PreviousExecutionContext)context){
                final /* synthetic */ ExecutionOutcome val$skippedOutcome;
                final /* synthetic */ UnitOfWork val$work;
                final /* synthetic */ PreviousExecutionContext val$context;
                {
                    this.val$skippedOutcome = executionOutcome;
                    this.val$work = unitOfWork;
                    this.val$context = previousExecutionContext;
                }

                @Override
                public Try<ExecutionResult> getExecutionResult() {
                    return Try.successful((Object)new ExecutionResult(){

                        @Override
                        public ExecutionOutcome getOutcome() {
                            return val$skippedOutcome;
                        }

                        @Override
                        public Object getOutput() {
                            return val$work.loadRestoredOutput(val$context.getWorkspace());
                        }
                    });
                }

                @Override
                public CachingState getCachingState() {
                    return CachingState.NOT_DETERMINED;
                }

                @Override
                public ImmutableList<String> getExecutionReasons() {
                    return ImmutableList.of();
                }

                @Override
                public Optional<AfterExecutionState> getAfterExecutionState() {
                    return Optional.empty();
                }

                @Override
                public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
                    return Optional.empty();
                }

                @Override
                public Duration getDuration() {
                    return Duration.ZERO;
                }
            };
        }).orElseGet(() -> this.delegate.execute(work, (PreviousExecutionContext)context));
    }
}

