/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.function.Consumer;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildProjectRegistry;
import org.gradle.internal.build.BuildState;

public abstract class AbstractBuildState
implements BuildState {
    @Override
    public DisplayName getDisplayName() {
        return Describables.of((Object)this.getBuildIdentifier());
    }

    public String toString() {
        return this.getDisplayName().getDisplayName();
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        throw new UnsupportedOperationException("Cannot include build '" + includedBuildSpec.rootDir.getName() + "' in " + this.getBuildIdentifier() + ". This is not supported yet.");
    }

    @Override
    public boolean isImportableBuild() {
        return true;
    }

    protected abstract ProjectStateRegistry getProjectStateRegistry();

    @Override
    public BuildProjectRegistry getProjects() {
        return this.getProjectStateRegistry().projectsFor(this.getBuildIdentifier());
    }

    protected abstract BuildLifecycleController getBuildController();

    @Override
    public void ensureProjectsLoaded() {
        this.getBuildController().getLoadedSettings();
    }

    @Override
    public void ensureProjectsConfigured() {
        this.getBuildController().getConfiguredBuild();
    }

    @Override
    public SettingsInternal getLoadedSettings() throws IllegalStateException {
        return this.getBuildController().getLoadedSettings();
    }

    @Override
    public void populateWorkGraph(Consumer<? super TaskExecutionGraphInternal> action) {
        BuildLifecycleController buildController = this.getBuildController();
        buildController.prepareToScheduleTasks();
        buildController.populateWorkGraph(action);
    }
}

