/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.problems;

import com.google.common.collect.Ordering;
import io.usethesource.capsule.Set;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.configurationcache.problems.ConfigurationCacheProblemsSummaryKt;
import org.gradle.configurationcache.problems.PropertyProblem;
import org.gradle.configurationcache.problems.UniquePropertyProblem;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00140\u00142\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0016J(\u0010 \u001a\u00020!*\u00060\"j\u0002`#2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gradle/configurationcache/problems/Summary;", "", "problemCount", "", "uniqueProblems", "Lio/usethesource/capsule/Set$Immutable;", "Lorg/gradle/configurationcache/problems/UniquePropertyProblem;", "causes", "", "", "overflowed", "", "(ILio/usethesource/capsule/Set$Immutable;Ljava/util/List;Z)V", "getCauses", "()Ljava/util/List;", "getOverflowed", "()Z", "getProblemCount", "()I", "buildSummaryReportLink", "", "reportFile", "Ljava/io/File;", "clickableUrlFor", "kotlin.jvm.PlatformType", "file", "insert", "problem", "Lorg/gradle/configurationcache/problems/PropertyProblem;", "textForConsole", "cacheActionText", "htmlReportFile", "appendSummaryHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "cacheAction", "totalProblemCount", "uniqueProblemCount", "Companion", "configuration-cache"})
public final class Summary {
    private final int problemCount;
    private final Set.Immutable<UniquePropertyProblem> uniqueProblems;
    @NotNull
    private final List<Throwable> causes;
    private final boolean overflowed;
    @NotNull
    private static final Summary empty;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Summary insert(@NotNull PropertyProblem problem) {
        Object object;
        Set.Immutable newUniqueProblems;
        int newProblemCount;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                newProblemCount = this.problemCount + 1;
                if (this.overflowed || newProblemCount > 4096) {
                    return new Summary(newProblemCount, this.uniqueProblems, this.causes, true);
                }
                UniquePropertyProblem uniqueProblem = UniquePropertyProblem.Companion.of(problem);
                newUniqueProblems = this.uniqueProblems.__insert((Object)uniqueProblem);
                Object object2 = problem;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object = newUniqueProblems != this.uniqueProblems && this.causes.size() < 5 ? object2 : null;
                if (object == null || (object = ((PropertyProblem)object).getException()) == null) break block4;
                object2 = object;
                bl = false;
                bl2 = false;
                it = object2;
                boolean bl4 = false;
                object = CollectionsKt.plus((Collection)this.causes, (Object)it);
                if (object != null) break block5;
            }
            object = this.causes;
        }
        List newCauses = object;
        Set.Immutable immutable = newUniqueProblems;
        Intrinsics.checkNotNullExpressionValue((Object)immutable, (String)"newUniqueProblems");
        return new Summary(newProblemCount, (Set.Immutable<UniquePropertyProblem>)immutable, newCauses, false);
    }

    @NotNull
    public final String textForConsole(@NotNull String cacheActionText, @NotNull File htmlReportFile) {
        Intrinsics.checkNotNullParameter((Object)cacheActionText, (String)"cacheActionText");
        Intrinsics.checkNotNullParameter((Object)htmlReportFile, (String)"htmlReportFile");
        DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        int uniqueProblemCount = this.uniqueProblems.size();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        StringBuilder stringBuilder2 = $this$apply;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        this.appendSummaryHeader($this$apply, cacheActionText, this.problemCount, uniqueProblemCount);
        stringBuilder2 = $this$apply;
        bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        List list = Ordering.from((Comparator)ConfigurationCacheProblemsSummaryKt.access$consoleComparator()).leastOf((Iterable)this.uniqueProblems, 15);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"Ordering.from(consoleCom\u2026lems, maxConsoleProblems)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder3;
            StringBuilder stringBuilder4;
            UniquePropertyProblem problem = (UniquePropertyProblem)element$iv;
            boolean bl5 = false;
            $this$apply.append("- ");
            $this$apply.append(StringsKt.capitalize((String)problem.getUserCodeLocation()));
            $this$apply.append(": ");
            CharSequence charSequence = $this$apply;
            String string2 = problem.getMessage();
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence.append(string2), (String)"append(value)");
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            String string3 = problem.getDocumentationSection();
            if (string3 == null) continue;
            charSequence = string3;
            boolean bl8 = false;
            bl6 = false;
            CharSequence it = charSequence;
            boolean bl9 = false;
            StringBuilder stringBuilder5 = $this$apply;
            String string4 = "  See " + documentationRegistry.getDocumentationFor("configuration_cache", (String)it);
            boolean bl10 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append(string4), (String)"append(value)");
            boolean bl11 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        if (uniqueProblemCount > 15) {
            stringBuilder2 = $this$apply;
            String string5 = "plus " + (uniqueProblemCount - 15) + " more problems. Please see the report for details.";
            boolean bl12 = false;
            StringBuilder stringBuilder6 = stringBuilder2.append(string5);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            StringBuilder stringBuilder7 = stringBuilder6;
            boolean bl13 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        }
        stringBuilder2 = $this$apply;
        boolean bl14 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        $this$apply.append(this.buildSummaryReportLink(htmlReportFile));
        String string6 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"StringBuilder().apply {\n\u2026le))\n        }.toString()");
        return string6;
    }

    private final void appendSummaryHeader(StringBuilder $this$appendSummaryHeader, String cacheAction, int totalProblemCount, int uniqueProblemCount) {
        $this$appendSummaryHeader.append(totalProblemCount);
        $this$appendSummaryHeader.append(totalProblemCount == 1 ? " problem was found " : " problems were found ");
        $this$appendSummaryHeader.append(cacheAction);
        $this$appendSummaryHeader.append(" the configuration cache");
        if (this.overflowed) {
            $this$appendSummaryHeader.append(", only the first ");
            $this$appendSummaryHeader.append(4096);
            $this$appendSummaryHeader.append(" were considered");
        }
        if (totalProblemCount != uniqueProblemCount) {
            $this$appendSummaryHeader.append(", ");
            $this$appendSummaryHeader.append(uniqueProblemCount);
            $this$appendSummaryHeader.append(" of which ");
            $this$appendSummaryHeader.append(uniqueProblemCount == 1 ? "seems unique" : "seem unique");
        }
        $this$appendSummaryHeader.append(".");
    }

    private final String buildSummaryReportLink(File reportFile) {
        return "See the complete report at " + this.clickableUrlFor(reportFile);
    }

    private final String clickableUrlFor(File file) {
        return new ConsoleRenderer().asClickableFileUrl(file);
    }

    public final int getProblemCount() {
        return this.problemCount;
    }

    @NotNull
    public final List<Throwable> getCauses() {
        return this.causes;
    }

    public final boolean getOverflowed() {
        return this.overflowed;
    }

    private Summary(int problemCount, Set.Immutable<UniquePropertyProblem> uniqueProblems, List<? extends Throwable> causes, boolean overflowed) {
        this.problemCount = problemCount;
        this.uniqueProblems = uniqueProblems;
        this.causes = causes;
        this.overflowed = overflowed;
    }

    static {
        Companion = new Companion(null);
        Set.Immutable immutable = Set.Immutable.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutable, (String)"Set.Immutable.of()");
        empty = new Summary(0, (Set.Immutable<UniquePropertyProblem>)immutable, CollectionsKt.emptyList(), false);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gradle/configurationcache/problems/Summary$Companion;", "", "()V", "empty", "Lorg/gradle/configurationcache/problems/Summary;", "getEmpty", "()Lorg/gradle/configurationcache/problems/Summary;", "configuration-cache"})
    public static final class Companion {
        @NotNull
        public final Summary getEmpty() {
            return empty;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

