//
//  LANController.m
//  BwanaDik
//
//  Created by John Schilling on 9/8/06.
//  Copyright 2006 John Schilling. All rights reserved.
//

#import "LANController.h"
#import "NSStringExtras.h"

@implementation LANController

#pragma mark
#pragma mark PRIVATE INSTANCE METHODS
#pragma mark


- (id)init
{
    if( ![super init] ) return nil;
    
        _currentAddress     = [[NSMutableString alloc] initWithString:@""];
        _previousAddress    = [[NSMutableString alloc] initWithString:@""];
        
        _interfaceAddresses = [[NSMutableArray alloc] init];
        [_interfaceAddresses addObject:@""]; // 0 ethernet
        [_interfaceAddresses addObject:@""]; // 1 airport
        [_interfaceAddresses addObject:@""]; // 2 firewire

    return self;
}

- (void)awakeFromNib
{

}

- (void)dealloc
{
    [_currentAddress     release];
    [_previousAddress    release];
    [_interfaceAddresses removeAllObjects];
    [_interfaceAddresses release];
    
    [super dealloc];
}


- (void)setDelegate:(id)delegate
{
    _delegate = delegate;
}



#pragma mark
#pragma mark ACCESS TO STATE VARIABLES
#pragma mark

- (NSString *)currentLANAddress
{
    return _currentAddress;
}

- (NSString *)previousLANAddress
{
    return _previousAddress;
}

- (NSString *)currentEthernetAddress
{
    return [_interfaceAddresses objectAtIndex:0];
}

- (NSString *)currentAirportAddress
{
    return [_interfaceAddresses objectAtIndex:1];
}

- (NSString *)currentFirewireAddress
{
    return [_interfaceAddresses objectAtIndex:2];
}

- (NSString *)interfaceAddressForIndex:(int)index
{
    return [_interfaceAddresses objectAtIndex:index];
}




#pragma mark
#pragma mark CORE LAN FETCHING PARSING METHODS
#pragma mark

- (void)getCurrentLANAddresses
{
    NSString *LANIP = [self currentLANAddressForInterface:-1]; //get whatever is current
    
    if (LANIP && [LANIP isValidAddress]) {	
        [_currentAddress setString:LANIP];
    } else {
        [_currentAddress setString:@""];
    }
    
    [_interfaceAddresses replaceObjectAtIndex:0 withObject:[[self currentLANAddressForInterface:0] copy]];
    [_interfaceAddresses replaceObjectAtIndex:1 withObject:[[self currentLANAddressForInterface:1] copy]];
    [_interfaceAddresses replaceObjectAtIndex:2 withObject:[[self currentLANAddressForInterface:2] copy]];
    
    if ([_delegate respondsToSelector:@selector(LANCheckFinished)]) [_delegate LANCheckFinished];
    
    [self checkLANaddressChanged];
}

- (NSString *)currentLANAddressForInterface:(int)interface
{
    NSString *aeString;
  	
    if (interface == 0)
    {
        aeString = @"set theResult to do shell script (\" ifconfig en0 | grep inet | grep -v inet6 | awk '{print $2}' \") as string";
    } else if (interface == 1) {
        aeString = @"set theResult to do shell script (\" ifconfig en1 | grep inet | grep -v inet6 | awk '{print $2}' \") as string";
    } else if (interface == 2) {
        aeString = @"set theResult to do shell script (\" ifconfig fw0 | grep inet | grep -v inet6 | awk '{print $2}' \") as string";
    } else {
        aeString = @"set theResult to do shell script (\" ifconfig -a | grep 'inet ' | grep -v '127' | grep 'netmask' | awk '{print $2}'  \") as string";
    }
        
    NSArray *interfaces = [[[[[[NSAppleScript alloc] initWithSource:aeString] autorelease] executeAndReturnError:nil] stringValue] componentsSeparatedByString:@"\r"];
    
    if (interfaces == nil || [interfaces count] < 1) return @"";
    
    NSString *LANIP = [interfaces objectAtIndex:0];
    
    if (LANIP && [LANIP isValidAddress])
    {
        return [LANIP stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
    } else {
        return @"";
    }
}

- (void)checkLANaddressChanged
{
    // Okay, if the LAN changed, update the interface and get new WAN:
    if (![_currentAddress isEqualToString:_previousAddress])
    {
        
        if ([_delegate respondsToSelector:@selector(LANAddressChangedFrom:to:)])
        {
            [_delegate LANAddressChangedFrom:_previousAddress to:_currentAddress];
        }
        
        [_previousAddress setString:_currentAddress];
    }
}


@end
