//
//  AlertPanelChange.h
//  BwanaDik
//
//  Created by John Schilling on 6/9/06.
//  Copyright 2006 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "BwanaHeaders.h"

@interface AlertPanelChange : NSWindowController {
        
        BOOL                        _alertOpen;
        
        IBOutlet NSImageView        *_alertPanelImageView;
        
        IBOutlet NSTextField        *_alertPanelCurrentIPField;
        IBOutlet NSTextField        *_alertPanelPreviousIPField;
        
        IBOutlet NSTextField        *_alertPanelMainTextField;
        IBOutlet NSTextField        *_alertPanelCurrentTextField;
        IBOutlet NSTextField        *_alertPanelPreviousTextField;
        
        NSString                    *_mainText;
        NSString                    *_currentIPText;
        NSString                    *_previousIPText;
        
        NSTimer                     *_closeTimer;
        NSTimer                     *_animeTimer;
        
        BOOL                        _animeSwitch;
        
        NSMutableString             *_lastAppPath;
}

- (void)runAlertPanelChangedAddress:(NSString *)CurrentAddress 
                    PreviousAddress:(NSString *)PreviousAddress 
                         changeType:(int)changeType 
                          autoClose:(BOOL)autoClose;
- (void)killAlert;

- (void)startCloseTimer;
- (void)stopCloseTimer;
- (void)closeTimerFired:(NSTimer *)timer;

- (void)startAnimeTimer;
- (void)stopAnimeTimer;
- (void)animeTimerFired:(NSTimer *)timer;

- (void)setLastApplicationPath;
- (void)returnFocusToLastApplication;

@end
