//
//  NSStringExtras.m
//
//  Created by John Schilling on 8/31/06.
//  Copyright 2006 John Schilling. All rights reserved.
//

#import "NSStringExtras.h"


@implementation NSString (ExtraAdditions)

+ (NSString *)formattedFileSizeWithBytes:(long)filesize
{
    static NSString *suffix[] = { @"B", @"KB", @"MB", @"GB", @"TB", @"PB", @"EB" };
    
    int i, c = 7;
    
    for (i = 0; i < c && filesize >= 1024; i++) {
        filesize = filesize / 1024;
    }
    return [NSString stringWithFormat:@"%ld %@", filesize, suffix[i]];
}

+ (NSString *)uniqueIDString
{
    CFUUIDRef uuid = CFUUIDCreate(NULL);
    CFStringRef uuidStr = CFUUIDCreateString(NULL, uuid);
    CFRelease(uuid);
    [(NSString *)uuidStr autorelease];
    return (NSString *)uuidStr;
}

- (BOOL)isValidAddress
{
    if (self == nil || self == NULL) return NO;
    NSArray *periodicals = [self componentsSeparatedByString:@"."];
    if ([periodicals count] != 4) return NO;
    return YES;
}

- (BOOL)isValidEmail
{
    if (self == nil || self == NULL) return NO;
    NSArray *atArray = [self componentsSeparatedByString:@"@"];
    NSArray *dotArray = [self componentsSeparatedByString:@"."];
    if ([atArray count] == 2 && [dotArray count] == 2) {
        return YES;
    } else {
        return NO;
    }
}

@end
