//
//  NSCalendarDate+CLExtensions.m
//  DateLine
//
//  Created by Alex Clarke on 9/05/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//

#import "NSCalendarDate+CLExtensions.h"


@implementation NSCalendarDate (CLExtensions)


-(float)yearsSinceDate:(NSCalendarDate *)referenceDate
{
	return [self daysSinceDate:referenceDate]/365;
}

-(float)monthsSinceDate:(NSCalendarDate *)referenceDate
{
	return [self yearsSinceDate:referenceDate]*12;
}

-(float)daysSinceDate:(NSCalendarDate *)referenceDate
{
	return [self hoursSinceDate:referenceDate]/24;
}

-(float)hoursSinceDate:(NSCalendarDate *)referenceDate
{
	return [self minutesSinceDate:referenceDate]/60;
}

-(float)minutesSinceDate:(NSCalendarDate *)referenceDate
{
	return [self secondsSinceDate:referenceDate]/60;
}

-(float)secondsSinceDate:(NSCalendarDate *)referenceDate
{
	int secs;
	[self years:NULL months:NULL days:NULL hours:NULL 
		minutes:NULL seconds:&secs sinceDate:referenceDate];
	return (float)secs;
}

+(NSMutableArray *) daysOfMonth:(NSCalendarDate *)referenceDate
{
	NSMutableArray * result = [[[NSMutableArray alloc]init]autorelease];

	if (referenceDate==nil)
		result = nil;
	
	//determine the month and year
	int month = [referenceDate monthOfYear];
	int year = [referenceDate yearOfCommonEra];
	NSCalendarDate * startDate  = [NSCalendarDate dateWithString:[NSString stringWithFormat:@"01 %d %d", month, year] calendarFormat:@"%d %m %Y"]; 
	int m = month;
	int i = 0;
	while (m == month)
	{
		NSCalendarDate * newDate = [startDate dateByAddingYears:0 months:0 days:i hours:0 minutes:0 seconds:0];
		m = [newDate monthOfYear];
		if (m == month) // catches the extra day
		{
			[result addObject:newDate];
			//NSLog(@"i %d newDate: %@", i, newDate);	
		}
		++i;
	}
	
	return result;
}

@end
