/*
 * Decompiled with CFR 0.152.
 */
package deepview2;

import deepview2.dvGUI;
import deepview2.dvNode;
import deepview2.guiEditor;
import deepview2.guiSubtree;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JInternalFrame;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import shared.m;

public class guiTree {
    JTree tree;
    dvNode root;
    dvGUI gui;

    public guiTree(JTree tree, dvNode root, dvGUI gui, boolean showroot) {
        this.tree = tree;
        this.gui = gui;
        this.root = root;
        tree.setRootVisible(showroot);
        this.initTree();
        this.refreshTree();
    }

    public void initTree() {
        final guiTree ths = this;
        this.tree.setToggleClickCount(0);
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                m.msg("will expand");
                dvNode n = (dvNode)event.getPath().getLastPathComponent();
                n.loadChildren();
            }

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                m.msg("will collapse");
            }
        });
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                m.msg("expanded.");
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                m.msg("collapsed.");
            }
        });
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e2) {
                dvNode n = (dvNode)e2.getPath().getLastPathComponent();
                n.onSelect(ths);
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e2) {
            }

            public void mousePressed(MouseEvent e2) {
                Object src = e2.getSource();
                if (src == guiTree.this.tree && e2.getClickCount() == 2) {
                    m.msg("hi");
                    dvNode n = (dvNode)guiTree.this.tree.getSelectionPath().getLastPathComponent();
                    n.onDoubleClick(ths);
                }
            }

            public void mouseReleased(MouseEvent e2) {
            }

            public void mouseEntered(MouseEvent e2) {
            }

            public void mouseExited(MouseEvent e2) {
            }
        });
    }

    public void refreshTree() {
        this.tree.setModel(new TreeModel(){

            public Object getRoot() {
                return guiTree.this.root;
            }

            public Object getChild(Object parent, int index) {
                dvNode n = (dvNode)parent;
                return n.getChild(index);
            }

            public int getChildCount(Object parent) {
                dvNode n = (dvNode)parent;
                return n.getChildCount();
            }

            public boolean isLeaf(Object node) {
                dvNode n = (dvNode)node;
                return n.isLeaf();
            }

            public void valueForPathChanged(TreePath path, Object newValue) {
            }

            public int getIndexOfChild(Object parent, Object child) {
                dvNode n = (dvNode)parent;
                dvNode c = (dvNode)child;
                return n.getChildIndex(c);
            }

            public void addTreeModelListener(TreeModelListener l) {
            }

            public void removeTreeModelListener(TreeModelListener l) {
            }
        });
    }

    public void expandCurrentSelection() {
        m.msg("wha");
        this.tree.expandPath(this.tree.getSelectionPath());
    }

    public void createNewWindow(dvNode root) {
        guiSubtree newwindow = new guiSubtree(root, this.gui);
        this.gui.desktop.add(newwindow);
        guiTree.moveToFrontAndSelect(newwindow);
    }

    public void createNewEditorWindow(guiEditor win) {
        this.gui.desktop.add(win);
        guiTree.moveToFrontAndSelect(win);
    }

    public static void moveToFrontAndSelect(JInternalFrame win) {
        win.moveToFront();
        try {
            win.setSelected(true);
        }
        catch (Exception e2) {
            m.err("Unable to select window");
        }
    }
}

