/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import lpg.runtime.Adjunct;
import lpg.runtime.ErrorToken;
import lpg.runtime.ILexStream;
import lpg.runtime.IMessageHandler;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.LexStream;
import lpg.runtime.NullExportedSymbolsException;
import lpg.runtime.NullTerminalSymbolsException;
import lpg.runtime.ParseErrorCodes;
import lpg.runtime.Token;
import lpg.runtime.UndefinedEofSymbolException;
import lpg.runtime.UnimplementedTerminalsException;
import lpg.runtime.Utf8LexStream;

public class PrsStream
implements IPrsStream,
ParseErrorCodes {
    private ILexStream iLexStream;
    private int[] kindMap = null;
    private ArrayList tokens = new ArrayList();
    private ArrayList adjuncts = new ArrayList();
    private int index = 0;
    private int len = 0;

    public PrsStream() {
    }

    public PrsStream(ILexStream iLexStream) {
        this.iLexStream = iLexStream;
        if (iLexStream != null) {
            iLexStream.setPrsStream(this);
        }
        this.resetTokenStream();
    }

    public String[] orderedExportedSymbols() {
        return null;
    }

    public void remapTerminalSymbols(String[] ordered_parser_symbols, int eof_symbol) throws UndefinedEofSymbolException, NullExportedSymbolsException, NullTerminalSymbolsException, UnimplementedTerminalsException {
        if (this.iLexStream == null) {
            throw new NullPointerException("lpg.runtime.PrsStream.remapTerminalSymbols(..):  lexStream is null");
        }
        String[] ordered_lexer_symbols = this.iLexStream.orderedExportedSymbols();
        if (ordered_lexer_symbols == null) {
            throw new NullExportedSymbolsException();
        }
        if (ordered_parser_symbols == null) {
            throw new NullTerminalSymbolsException();
        }
        ArrayList<Integer> unimplemented_symbols = new ArrayList<Integer>();
        if (ordered_lexer_symbols != ordered_parser_symbols) {
            int i;
            this.kindMap = new int[ordered_lexer_symbols.length];
            HashMap<String, Integer> terminal_map = new HashMap<String, Integer>();
            for (i = 0; i < ordered_lexer_symbols.length; ++i) {
                terminal_map.put(ordered_lexer_symbols[i], new Integer(i));
            }
            for (i = 0; i < ordered_parser_symbols.length; ++i) {
                Integer k = (Integer)terminal_map.get(ordered_parser_symbols[i]);
                if (k != null) {
                    this.kindMap[k.intValue()] = i;
                    continue;
                }
                if (i == eof_symbol) {
                    throw new UndefinedEofSymbolException();
                }
                unimplemented_symbols.add(new Integer(i));
            }
        }
        if (unimplemented_symbols.size() > 0) {
            throw new UnimplementedTerminalsException(unimplemented_symbols);
        }
    }

    public final int mapKind(int kind) {
        return this.kindMap == null ? kind : this.kindMap[kind];
    }

    public void resetTokenStream() {
        this.tokens = new ArrayList();
        this.index = 0;
        this.adjuncts = new ArrayList();
    }

    public void setLexStream(ILexStream lexStream) {
        this.iLexStream = lexStream;
        this.resetTokenStream();
    }

    public void resetLexStream(LexStream lexStream) {
        this.iLexStream = lexStream;
        if (lexStream != null) {
            lexStream.setPrsStream(this);
        }
    }

    public void makeToken(int startLoc, int endLoc, int kind) {
        Token token = new Token(this, startLoc, endLoc, this.mapKind(kind));
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
    }

    public void removeLastToken() {
        int last_index = this.tokens.size() - 1;
        Token token = (Token)this.tokens.get(last_index);
        int adjuncts_size = this.adjuncts.size();
        while (adjuncts_size > token.getAdjunctIndex()) {
            this.adjuncts.remove(--adjuncts_size);
        }
        this.tokens.remove(last_index);
    }

    public int makeErrorToken(int firsttok, int lasttok, int errortok, int kind) {
        int index = this.tokens.size();
        ErrorToken token = new ErrorToken(this.getIToken(firsttok), this.getIToken(lasttok), this.getIToken(errortok), this.getStartOffset(firsttok), this.getEndOffset(lasttok), kind);
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
        return index;
    }

    public void addToken(IToken token) {
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
    }

    public void makeAdjunct(int startLoc, int endLoc, int kind) {
        int token_index = this.tokens.size() - 1;
        Adjunct adjunct = new Adjunct(this, startLoc, endLoc, this.mapKind(kind));
        adjunct.setAdjunctIndex(this.adjuncts.size());
        adjunct.setTokenIndex(token_index);
        this.adjuncts.add(adjunct);
    }

    public void addAdjunct(IToken adjunct) {
        int token_index = this.tokens.size() - 1;
        adjunct.setTokenIndex(token_index);
        adjunct.setAdjunctIndex(this.adjuncts.size());
        this.adjuncts.add(adjunct);
    }

    public String getTokenText(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.toString();
    }

    public int getStartOffset(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.getStartOffset();
    }

    public int getEndOffset(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.getEndOffset();
    }

    public int getTokenLength(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.getEndOffset() - t.getStartOffset() + 1;
    }

    public int getLineNumberOfTokenAt(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return this.iLexStream.getLineNumberOfCharAt(t.getStartOffset());
    }

    public int getEndLineNumberOfTokenAt(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return this.iLexStream.getLineNumberOfCharAt(t.getEndOffset());
    }

    public int getColumnOfTokenAt(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return this.iLexStream.getColumnOfCharAt(t.getStartOffset());
    }

    public int getEndColumnOfTokenAt(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return this.iLexStream.getColumnOfCharAt(t.getEndOffset());
    }

    public String[] orderedTerminalSymbols() {
        return null;
    }

    public int getLineOffset(int i) {
        return this.iLexStream.getLineOffset(i);
    }

    public int getLineCount() {
        return this.iLexStream.getLineCount();
    }

    public int getLineNumberOfCharAt(int i) {
        return this.iLexStream.getLineNumberOfCharAt(i);
    }

    public int getColumnOfCharAt(int i) {
        return this.getColumnOfCharAt(i);
    }

    public int getFirstErrorToken(int i) {
        return this.getFirstRealToken(i);
    }

    public int getFirstRealToken(int i) {
        while (i >= this.len) {
            i = ((ErrorToken)this.tokens.get(i)).getFirstRealToken().getTokenIndex();
        }
        return i;
    }

    public int getLastErrorToken(int i) {
        return this.getLastRealToken(i);
    }

    public int getLastRealToken(int i) {
        while (i >= this.len) {
            i = ((ErrorToken)this.tokens.get(i)).getLastRealToken().getTokenIndex();
        }
        return i;
    }

    public char[] getInputChars() {
        return this.iLexStream instanceof LexStream ? ((LexStream)this.iLexStream).getInputChars() : null;
    }

    public byte[] getInputBytes() {
        return this.iLexStream instanceof Utf8LexStream ? ((Utf8LexStream)this.iLexStream).getInputBytes() : null;
    }

    public String toString(int first_token, int last_token) {
        return this.toString((IToken)this.tokens.get(first_token), (IToken)this.tokens.get(last_token));
    }

    public String toString(IToken t1, IToken t2) {
        return this.iLexStream.toString(t1.getStartOffset(), t2.getEndOffset());
    }

    public int getSize() {
        return this.tokens.size();
    }

    public void setSize() {
        this.len = this.tokens.size();
    }

    public int getTokenIndexAtCharacter(int offset) {
        int low = 0;
        int high = this.tokens.size();
        while (high > low) {
            int mid = (high + low) / 2;
            IToken mid_element = (IToken)this.tokens.get(mid);
            if (offset >= mid_element.getStartOffset() && offset <= mid_element.getEndOffset()) {
                return mid;
            }
            if (offset < mid_element.getStartOffset()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return -(low - 1);
    }

    public IToken getTokenAtCharacter(int offset) {
        int tokenIndex = this.getTokenIndexAtCharacter(offset);
        return tokenIndex < 0 ? null : this.getTokenAt(tokenIndex);
    }

    public IToken getTokenAt(int i) {
        return (IToken)this.tokens.get(i);
    }

    public IToken getIToken(int i) {
        return (IToken)this.tokens.get(i);
    }

    public ArrayList getTokens() {
        return this.tokens;
    }

    public int getStreamIndex() {
        return this.index;
    }

    public int getStreamLength() {
        return this.len;
    }

    public void setStreamIndex(int index) {
        this.index = index;
    }

    public void setStreamLength() {
        this.len = this.tokens.size();
    }

    public void setStreamLength(int len) {
        this.len = len;
    }

    public ILexStream getILexStream() {
        return this.iLexStream;
    }

    public ILexStream getLexStream() {
        return this.iLexStream;
    }

    public void dumpTokens() {
        if (this.getSize() <= 2) {
            return;
        }
        System.out.println(" Kind \tOffset \tLen \tLine \tCol \tText\n");
        for (int i = 1; i < this.getSize() - 1; ++i) {
            this.dumpToken(i);
        }
    }

    public void dumpToken(int i) {
        System.out.print(" (" + this.getKind(i) + ")");
        System.out.print(" \t" + this.getStartOffset(i));
        System.out.print(" \t" + this.getTokenLength(i));
        System.out.print(" \t" + this.getLineNumberOfTokenAt(i));
        System.out.print(" \t" + this.getColumnOfTokenAt(i));
        System.out.print(" \t" + this.getTokenText(i));
        System.out.println();
    }

    private IToken[] getAdjuncts(int i) {
        int start_index = ((IToken)this.tokens.get(i)).getAdjunctIndex();
        int end_index = i + 1 == this.tokens.size() ? this.adjuncts.size() : ((IToken)this.tokens.get(this.getNext(i))).getAdjunctIndex();
        int size = end_index - start_index;
        IToken[] slice = new IToken[size];
        int j = start_index;
        int k = 0;
        while (j < end_index) {
            slice[k] = (IToken)this.adjuncts.get(j);
            ++j;
            ++k;
        }
        return slice;
    }

    public IToken[] getFollowingAdjuncts(int i) {
        return this.getAdjuncts(i);
    }

    public IToken[] getPrecedingAdjuncts(int i) {
        return this.getAdjuncts(this.getPrevious(i));
    }

    public ArrayList getAdjuncts() {
        return this.adjuncts;
    }

    public int getToken() {
        this.index = this.getNext(this.index);
        return this.index;
    }

    public int getToken(int end_token) {
        this.index = this.index < end_token ? this.getNext(this.index) : this.len - 1;
        return this.index;
    }

    public int getKind(int i) {
        IToken t = (IToken)this.tokens.get(i);
        return t.getKind();
    }

    public int getNext(int i) {
        return ++i < this.len ? i : this.len - 1;
    }

    public int getPrevious(int i) {
        return i <= 0 ? 0 : i - 1;
    }

    public String getName(int i) {
        return this.getTokenText(i);
    }

    public int peek() {
        return this.getNext(this.index);
    }

    public void reset(int i) {
        this.index = this.getPrevious(i);
    }

    public void reset() {
        this.index = 0;
    }

    public int badToken() {
        return 0;
    }

    public int getLine(int i) {
        return this.getLineNumberOfTokenAt(i);
    }

    public int getColumn(int i) {
        return this.getColumnOfTokenAt(i);
    }

    public int getEndLine(int i) {
        return this.getEndLineNumberOfTokenAt(i);
    }

    public int getEndColumn(int i) {
        return this.getEndColumnOfTokenAt(i);
    }

    public boolean afterEol(int i) {
        return i < 1 ? true : this.getEndLineNumberOfTokenAt(i - 1) < this.getLineNumberOfTokenAt(i);
    }

    public String getFileName() {
        return this.iLexStream.getFileName();
    }

    public void setMessageHandler(IMessageHandler errMsg) {
        this.iLexStream.setMessageHandler(errMsg);
    }

    public IMessageHandler getMessageHandler() {
        return this.iLexStream.getMessageHandler();
    }

    public void reportError(int errorCode, int leftToken, int rightToken, String errorInfo) {
        String[] stringArray;
        if (errorInfo == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorInfo;
        }
        this.reportError(errorCode, leftToken, 0, rightToken, stringArray);
    }

    public void reportError(int errorCode, int leftToken, int rightToken, String[] errorInfo) {
        this.reportError(errorCode, leftToken, 0, rightToken, errorInfo);
    }

    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String errorInfo) {
        String[] stringArray;
        if (errorInfo == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = errorInfo;
        }
        this.reportError(errorCode, leftToken, errorToken, rightToken, stringArray);
    }

    public void reportError(int errorCode, int leftToken, int errorToken, int rightToken, String[] errorInfo) {
        this.iLexStream.reportLexicalError(errorCode, this.getStartOffset(leftToken), this.getEndOffset(rightToken), this.getStartOffset(errorToken), this.getEndOffset(errorToken), errorInfo == null ? new String[]{} : errorInfo);
    }
}

