/*
 * Decompiled with CFR 0.152.
 */
package auto.inplace;

import shared.FileUtils;
import shared.IBytedeque;
import shared.m;

public class InplaceFile {
    private String potsfolder;
    private String path;
    private String origpath;
    private String basepath;
    private static final String pathToOriginals = "/originalfiles/wholefiles/";

    public InplaceFile(String potsfolder) {
        this(potsfolder, "");
    }

    public InplaceFile(String potsfolder, String path) {
        this.potsfolder = potsfolder;
        this.path = path;
        this.origpath = potsfolder + "/" + path;
        this.basepath = potsfolder + pathToOriginals + path;
    }

    public InplaceFile File(String newpath) {
        return new InplaceFile(this.potsfolder, newpath);
    }

    public byte[] ReadAsBytes() {
        String path = this.getPath();
        return FileUtils.ReadFile(path);
    }

    private String getPath() {
        if (FileUtils.Exists(this.basepath)) {
            return this.basepath;
        }
        return this.origpath;
    }

    public void SaveFile(byte[] data) {
        this.ensureBaseSaved();
        FileUtils.WriteFile(this.origpath, data);
    }

    public void SaveFile(IBytedeque c) {
        this.ensureBaseSaved();
        c.writeAllBytesToFile(this.origpath);
    }

    private void ensureBaseSaved() {
        if (!this.hasBaseSaved()) {
            FileUtils.CopyFile(this.origpath, this.basepath, false, true, true);
        }
    }

    private boolean hasBaseSaved() {
        return FileUtils.Exists(this.basepath);
    }

    public void RestoreOriginal() {
        m.warn("untested");
        FileUtils.CopyFile(this.basepath, this.origpath, true, true, true);
    }

    public void RestoreAllOriginals() {
        m.warn("untested");
        FileUtils.CopyTree(this.potsfolder + pathToOriginals, this.potsfolder, true, true);
    }

    public boolean exists() {
        String path = this.getPath();
        return FileUtils.Exists(path);
    }

    public String toString() {
        return "InplaceFile: " + this.path;
    }
}

