/*
 * Decompiled with CFR 0.152.
 */
package auto;

import export3ds.FaceArray;
import export3ds.Material;
import export3ds.MeshMatGroup;
import export3ds.NamedObj;
import export3ds.NamedTriangleObject;
import export3ds.PointArray;
import export3ds.Primary;
import export3ds.TextureMap;
import export3ds.UOffset;
import export3ds.UScale;
import export3ds.UvVerts;
import export3ds.VOffset;
import export3ds.VScale;
import export3ds.check;
import images.dds;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import realmyst.Count10;
import realmyst.Count2;
import realmyst.Count3Undone;
import realmyst.Hsm;
import realmyst.Matrix;
import realmyst.Mdb;
import realmyst.Sdb;
import realmyst.rmcontext;
import shared.Bytedeque2;
import shared.FileUtils;
import shared.Flt;
import shared.FltPair;
import shared.Format;
import shared.IBytedeque;
import shared.IBytestream;
import shared.Ntstring;
import shared.SerialBytestream;
import shared.ShortTriplet;
import shared.Vertex;
import shared.ignore;
import shared.m;
import shared.uncaughtexception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class realmyst {
    public static void testrun2(Vector<Sdb> sdbs, Vector<Mdb> mdbs) {
        Primary main = Primary.createNull();
        HashMap<Integer, Count3Undone> materialmap = new HashMap<Integer, Count3Undone>();
        for (Sdb sdb : sdbs) {
            if (!sdb.sourceName.endsWith("70919002.vdb")) continue;
            for (int matindex = 0; matindex < sdb.count3s.length; ++matindex) {
                int textureIndex;
                Count3Undone c3 = sdb.count3s[matindex];
                if (c3.possibilities.length != 1 || (textureIndex = c3.possibilities[0]) == -1) continue;
                String textureFilename = sdb.count2s[textureIndex].textureFilename.toString();
                String matname = c3.sb2.str.toString();
                Material mat = Material.create(matname);
                mat.texturemap = TextureMap.create(textureFilename + ".dds");
                Matrix matrix = null;
                if (c3.subs != null && c3.subs.length > 0) {
                    matrix = c3.subs[0].m400;
                }
                if (matrix != null) {
                    Flt uscale = matrix.values[0][0];
                    Flt vscale = matrix.values[1][1];
                    Flt uoffset = matrix.values[0][3];
                    Flt voffset = matrix.values[1][3];
                    voffset.multModify(-1.0f);
                    mat.texturemap.uoffset = UOffset.create(uoffset.toJavaFloat());
                    mat.texturemap.voffset = VOffset.create(voffset.toJavaFloat());
                    mat.texturemap.uscale = UScale.create(uscale.toJavaFloat());
                    mat.texturemap.vscale = VScale.create(vscale.toJavaFloat());
                }
                main.meshdata.mats.add(mat);
                materialmap.put(matindex, c3);
            }
        }
        for (Mdb mdb : mdbs) {
            if (!mdb.name.toString().equals("myst..portstairstep")) continue;
            NamedObj namedobj = realmyst.createnamedobj(mdb, materialmap);
            main.meshdata.objs.add(namedobj);
        }
        Bytedeque2 out = new Bytedeque2(Format.realmyst);
        main.compile(out);
        byte[] filedata = ((IBytedeque)out).getAllBytes();
        FileUtils.WriteFile("c:/hsmout/000test.3ds", filedata);
    }

    public static NamedObj createnamedobj(Mdb mdb, HashMap<Integer, Count3Undone> materialmap) {
        String ignorereason = "";
        if (mdb.fs == null) {
            ignorereason = ignorereason + "Skipping NamedObj because it has no fs. ";
        }
        if (mdb.bunch == null) {
            ignorereason = ignorereason + "Skipping NamedObj because it has no bunch. ";
        }
        if (mdb.whas == null) {
            ignorereason = ignorereason + "Skipping NamedObj because it has no whas. ";
        }
        if (mdb.trips == null) {
            ignorereason = ignorereason + "NamedObj has no trips.";
        }
        if (!ignorereason.equals("")) {
            throw new ignore(ignorereason);
        }
        Vertex[] verts = new Vertex[mdb.fs.length];
        for (int i = 0; i < mdb.fs.length; ++i) {
            int to = mdb.fs[i].v2;
            int from = mdb.fs[i].v3;
            Flt x = mdb.bunch[to].f1;
            Flt y = mdb.bunch[to].f2;
            Flt z = mdb.bunch[to].f3;
            verts[i] = Vertex.createFromFlts(x, y, z);
        }
        FltPair[] uvcoords = new FltPair[mdb.trips.length];
        for (int i = 0; i < mdb.trips.length; ++i) {
            Flt u = mdb.trips[i].x;
            Flt v = mdb.trips[i].y;
            Flt w = mdb.trips[i].z;
            Flt u2 = Flt.createFromJavaFloat(1.0f - u.toJavaFloat());
            Flt v2 = Flt.createFromJavaFloat(1.0f - v.toJavaFloat());
            Flt w2 = Flt.createFromJavaFloat(1.0f - w.toJavaFloat());
            uvcoords[i] = FltPair.createFromFlts(u, v2);
        }
        ShortTriplet[] faces = new ShortTriplet[mdb.whas.length];
        for (int i = 0; i < mdb.whas.length; ++i) {
            int v1 = mdb.whas[i].u6;
            int v2 = mdb.whas[i].u7;
            int v3 = mdb.whas[i].u8;
            faces[i] = ShortTriplet.createFromShorts((short)v1, (short)v2, (short)v3);
            Flt uscale = mdb.whas[i].f12;
        }
        String objname = mdb.name.toString();
        NamedObj newobj = NamedObj.createNull(objname);
        newobj.namedTriangleObject = NamedTriangleObject.createNull();
        newobj.namedTriangleObject.points = PointArray.create(verts);
        newobj.namedTriangleObject.faces = FaceArray.createNull();
        newobj.namedTriangleObject.faces.facecount = check.intToShort(faces.length);
        newobj.namedTriangleObject.faces.faces = new FaceArray.tdsface[faces.length];
        for (int i = 0; i < faces.length; ++i) {
            short v1 = faces[i].p;
            short v2 = faces[i].q;
            short v3 = faces[i].r;
            short flags = 0;
            newobj.namedTriangleObject.faces.faces[i] = new FaceArray.tdsface(v1, v2, v3, flags);
        }
        for (int curmat = 0; curmat < mdb.ii.count; ++curmat) {
            int curmatindex = mdb.ii.indices[curmat];
            Count3Undone c3 = materialmap.get(curmatindex);
            String curmatname = c3.sb2.str.toString();
            int curmatvertcount = 0;
            for (int i = 0; i < mdb.ifi.values.length; ++i) {
                if (mdb.ifi.values[i] != curmatindex) continue;
                ++curmatvertcount;
            }
            short[] facesToApplyTo = new short[curmatvertcount];
            int curface = 0;
            for (int i = 0; i < mdb.ifi.values.length; ++i) {
                if (mdb.ifi.values[i] != curmatindex) continue;
                facesToApplyTo[curface] = (short)i;
                ++curface;
            }
            MeshMatGroup mmg = MeshMatGroup.create(curmatname, facesToApplyTo);
            newobj.namedTriangleObject.faces.mats.add(mmg);
        }
        for (ShortTriplet face : faces) {
            if (face.p < verts.length && face.q < verts.length && face.r < verts.length) continue;
            boolean dummy = false;
        }
        if (uvcoords.length != 0) {
            if (uvcoords.length != verts.length) {
                boolean dummy = false;
            } else if (uvcoords.length != 0) {
                newobj.namedTriangleObject.uvcoords = UvVerts.create(uvcoords);
            }
        }
        return newobj;
    }

    public static void testrun(Vector<Sdb> sdbs, Vector<Mdb> mdbs) {
        Primary main = Primary.createNull();
        String[] mystrooms = realmyst.findRoomInfo(sdbs, "Myst");
        int matnum = 0;
        for (Sdb sdb : sdbs) {
            if (!sdb.sourceName.endsWith("70919002.vdb")) continue;
            int i = 0;
            for (Count2 c2 : sdb.count2s) {
                String texsrch = "stonestep.hsm";
                if (c2.textureFilename.toString().equals(texsrch)) {
                    boolean dummy = false;
                }
                ++i;
            }
            int j = 0;
            for (Count3Undone c3 : sdb.count3s) {
                int textureIndex = c3.possibility;
                if (textureIndex != -1) {
                    boolean dummy;
                    String textureFilename = sdb.count2s[textureIndex].textureFilename.toString();
                    String name = c3.sb2.str.toString();
                    if (textureIndex == 185) {
                        dummy = false;
                    }
                    if (name.startsWith("myst..portstairstep")) {
                        dummy = false;
                    }
                    for (Mdb mdb : mdbs) {
                        String mdbname = mdb.name.toString();
                        if (!name.equals(mdbname)) continue;
                        String matname = "mat" + Integer.toString(++matnum);
                        Material mat = Material.create(matname);
                        mat.texturemap = TextureMap.create(textureFilename + ".dds");
                        main.meshdata.mats.add(mat);
                        try {
                            NamedObj obj = realmyst.createNamedObj(mdb);
                            obj.namedTriangleObject.faces.mats.get((int)0).name = Ntstring.createFromString(matname);
                            main.meshdata.objs.add(obj);
                        }
                        catch (ignore e2) {
                            boolean dummy2 = false;
                        }
                        boolean dummy3 = false;
                    }
                }
                ++j;
            }
        }
        Bytedeque2 out = new Bytedeque2(Format.realmyst);
        main.compile(out);
        byte[] filedata = ((IBytedeque)out).getAllBytes();
        FileUtils.WriteFile("c:/hsmout/000test.3ds", filedata);
    }

    public static Vector<Mdb> filterMdbsByRoom(Vector<Mdb> mdbs, String[] rooms) {
        Vector<Mdb> result = new Vector<Mdb>();
        for (Mdb mdb : mdbs) {
            String objname = mdb.name.toString();
            int ind = objname.indexOf("..");
            if (ind == -1) {
                m.msg("objectname has no .. : " + objname);
                break;
            }
            String curroom = objname.substring(0, ind);
            m.msg("objectname: " + curroom);
            for (String room : rooms) {
                if (!room.equals(curroom)) continue;
                result.add(mdb);
            }
        }
        return result;
    }

    public static Vector<Hsm> readAllHsms(String folder) {
        File f = new File(folder + "/scn/maps");
        Vector<Hsm> hsms = new Vector<Hsm>();
        int count = 0;
        for (File child : f.listFiles()) {
            if (!child.getName().toLowerCase().endsWith(".hsm")) continue;
            ++count;
            try {
                boolean dummy;
                int fs = (int)child.length();
                IBytestream bs = SerialBytestream.createFromFile(child);
                Hsm hsm = new Hsm(bs, child.getName());
                int offset = bs.getAbsoluteOffset();
                int bytesleft = bs.getBytesRemaining();
                if (bytesleft != 0) {
                    dummy = false;
                }
                hsms.add(hsm);
                dummy = false;
            }
            catch (ignore e2) {
                m.warn("Error so skipping file.");
            }
        }
        return hsms;
    }

    public static Vector<Mdb> readAllMdbs(String folder) {
        File f = new File(folder + "/mdb");
        rmcontext.get().curnum = 0;
        Vector<Mdb> mdbs = new Vector<Mdb>();
        int count = 0;
        for (File child : f.listFiles()) {
            if (!child.getName().toLowerCase().endsWith(".vdb")) continue;
            ++rmcontext.get().curnum;
            ++count;
            try {
                boolean dummy;
                int fs = (int)child.length();
                IBytestream bs = SerialBytestream.createFromFile(child);
                Mdb mdb = new Mdb(bs, "102445243.vdb");
                int offset = bs.getAbsoluteOffset();
                int bytesleft = bs.getBytesRemaining();
                if (bytesleft != 0) {
                    dummy = false;
                }
                mdbs.add(mdb);
                dummy = false;
            }
            catch (ignore e2) {
                m.warn("Error so skipping file.");
            }
        }
        return mdbs;
    }

    public static Vector<Sdb> readAllSdbs(String folder) {
        File f = new File(folder + "/sdb");
        Vector<Sdb> sdbs = new Vector<Sdb>();
        for (File child : f.listFiles()) {
            if (!child.getName().toLowerCase().endsWith(".vdb")) continue;
            try {
                boolean dummy;
                int fs = (int)child.length();
                IBytestream bs = SerialBytestream.createFromFile(child);
                Sdb sdb = new Sdb(bs);
                int offset = bs.getAbsoluteOffset();
                int bytesleft = bs.getBytesRemaining();
                if (sdb.filesizeMinusHeader != fs - offset) {
                    dummy = false;
                }
                if (bytesleft != 0) {
                    dummy = false;
                }
                dummy = false;
                sdbs.add(sdb);
            }
            catch (ignore e2) {
                m.warn("Error so skipping file.");
            }
        }
        return sdbs;
    }

    public static String[] findRoomInfo(Vector<Sdb> sdbs, String agecode) {
        String soughtObject;
        if (agecode.equals("Myst")) {
            soughtObject = "HoldingPen_Channel";
        } else if (agecode.equals("Channel") || agecode.equals("Channel") || agecode.equals("Channel") || agecode.equals("Channel") || agecode.equals("Channel") || agecode.equals("Channel") || agecode.equals("Channel")) {
            soughtObject = "HoldingPen_" + agecode + "ToMyst";
        } else {
            throw new uncaughtexception("realMyst Agename wasn't known, it was probably a typo.:" + agecode);
        }
        for (Sdb sdb : sdbs) {
            String objname = sdb.name.toString();
            if (objname.startsWith("HoldingPen_")) {
                boolean dummy;
                String room = sdb.strs[0].toString();
                if (room.equals("global")) {
                    if (objname.equals(soughtObject)) {
                        Vector<String> list2500 = new Vector<String>();
                        Vector<String> list2501 = new Vector<String>();
                        for (Count10.occref occ : sdb.count10s[0].occrefs1) {
                            if (occ.u3 == 2500) {
                                list2500.add(occ.subs[0].xstr.toString());
                            }
                            if (occ.u3 != 2501) continue;
                            list2501.add(occ.subs[0].xstr.toString());
                        }
                        String[] result = ((String)list2501.get(0)).split(",");
                        return result;
                    }
                    dummy = false;
                }
                dummy = false;
            }
            boolean dummy = false;
        }
        return null;
    }

    public static void saveDdsFiles(Vector<Hsm> hsms, String outfolder) {
        for (Hsm hsm : hsms) {
            byte[] outdata;
            Bytedeque2 out;
            int compressionType = hsm.getCompressionType();
            if (compressionType == 0) {
                out = new Bytedeque2(Format.realmyst);
                dds.createFromUncompressed(out, hsm.xagrb, hsm.widthMaybe, hsm.heightMaybe);
                outdata = ((IBytedeque)out).getAllBytes();
                FileUtils.WriteFile(outfolder + "/" + hsm.name + ".dds", outdata);
                continue;
            }
            if (compressionType != 1 && compressionType != 5) continue;
            out = new Bytedeque2(Format.realmyst);
            dds.createFromDxt(out, hsm.dxt);
            outdata = ((IBytedeque)out).getAllBytes();
            FileUtils.WriteFile(outfolder + "/" + hsm.name + ".dds", outdata);
        }
    }

    public static void save3dsFile(Vector<Mdb> mdbs) {
        Primary main = Primary.createNull();
        Material mat = Material.create("defaultmat");
        mat.texturemap = TextureMap.create("active.hsm.dds");
        main.meshdata.mats.add(mat);
        for (Mdb mdb : mdbs) {
            try {
                NamedObj obj = realmyst.createNamedObj(mdb);
                main.meshdata.objs.add(obj);
            }
            catch (ignore e2) {}
        }
        Bytedeque2 out = new Bytedeque2(Format.realmyst);
        main.compile(out);
        byte[] filedata = ((IBytedeque)out).getAllBytes();
        FileUtils.WriteFile("c:/test.3ds", filedata);
    }

    public static NamedObj createNamedObj(Mdb mdb) {
        String ignorereason = "";
        if (mdb.fs == null) {
            ignorereason = ignorereason + "Skipping NamedObj because it has no fs. ";
        }
        if (mdb.bunch == null) {
            ignorereason = ignorereason + "Skipping NamedObj because it has no bunch. ";
        }
        if (mdb.whas == null) {
            ignorereason = ignorereason + "Skipping NamedObj because it has no whas. ";
        }
        if (mdb.trips == null) {
            ignorereason = ignorereason + "NamedObj has no trips.";
        }
        if (!ignorereason.equals("")) {
            throw new ignore(ignorereason);
        }
        Vertex[] verts = new Vertex[mdb.fs.length];
        for (int i = 0; i < mdb.fs.length; ++i) {
            int to = mdb.fs[i].v2;
            int from = mdb.fs[i].v3;
            Flt x = mdb.bunch[to].f1;
            Flt y = mdb.bunch[to].f2;
            Flt z = mdb.bunch[to].f3;
            verts[i] = Vertex.createFromFlts(x, y, z);
        }
        ShortTriplet[] faces = new ShortTriplet[mdb.whas.length];
        for (int i = 0; i < mdb.whas.length; ++i) {
            int v1 = mdb.whas[i].u6;
            int v2 = mdb.whas[i].u7;
            int v3 = mdb.whas[i].u8;
            faces[i] = ShortTriplet.createFromShorts((short)v1, (short)v2, (short)v3);
        }
        String objname = mdb.name.toString();
        FltPair[] uvcoords = new FltPair[mdb.trips.length];
        for (int i = 0; i < mdb.trips.length; ++i) {
            Flt u = mdb.trips[i].x;
            Flt v = mdb.trips[i].y;
            Flt w = mdb.trips[i].z;
            Flt u2 = Flt.createFromJavaFloat(1.0f - u.toJavaFloat());
            Flt v2 = Flt.createFromJavaFloat(1.0f - v.toJavaFloat());
            Flt w2 = Flt.createFromJavaFloat(1.0f - w.toJavaFloat());
            uvcoords[i] = FltPair.createFromFlts(u, v2);
        }
        NamedObj newobj = NamedObj.createNull(objname);
        newobj.namedTriangleObject = NamedTriangleObject.createNull();
        newobj.namedTriangleObject.points = PointArray.create(verts);
        newobj.namedTriangleObject.faces = FaceArray.create(faces, "defaultmat");
        for (ShortTriplet face : faces) {
            if (face.p < verts.length && face.q < verts.length && face.r < verts.length) continue;
            boolean dummy = false;
        }
        if (uvcoords.length != 0) {
            if (uvcoords.length != verts.length) {
                boolean dummy = false;
            } else if (uvcoords.length != 0) {
                newobj.namedTriangleObject.uvcoords = UvVerts.create(uvcoords);
            }
        }
        return newobj;
    }
}

