/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.h2.command.Prepared;
import org.h2.command.dml.ScriptBase;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.util.ScriptReader;

public class RunScriptCommand
extends ScriptBase {
    private String charset = SysProperties.FILE_ENCODING;

    public RunScriptCommand(Session session) {
        super(session);
    }

    public int update() {
        this.session.getUser().checkAdmin();
        int n = 0;
        try {
            String string;
            this.openInput();
            InputStreamReader inputStreamReader = new InputStreamReader(this.in, this.charset);
            ScriptReader scriptReader = new ScriptReader(inputStreamReader);
            while ((string = scriptReader.readStatement()) != null) {
                this.execute(string);
                ++n;
            }
            ((Reader)inputStreamReader).close();
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
        finally {
            this.closeIO();
        }
        return n;
    }

    private void execute(String string) {
        try {
            Prepared prepared = this.session.prepare(string);
            if (prepared.isQuery()) {
                prepared.query(0);
            } else {
                prepared.update();
            }
            if (this.session.getAutoCommit()) {
                this.session.commit(false);
            }
        }
        catch (DbException dbException) {
            throw dbException.addSQL(string);
        }
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public ResultInterface queryMeta() {
        return null;
    }
}

