/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.io.nio.RandomAccessFileBuffer;
import org.eclipse.jetty.util.log.Log;

public class ChannelEndPoint
implements EndPoint {
    protected final ByteChannel _channel;
    protected final ByteBuffer[] _gather2 = new ByteBuffer[2];
    protected final Socket _socket;
    protected InetSocketAddress _local;
    protected InetSocketAddress _remote;
    protected int _maxIdleTime;

    public ChannelEndPoint(ByteChannel channel) throws IOException {
        this._channel = channel;
        Socket socket = this._socket = channel instanceof SocketChannel ? ((SocketChannel)channel).socket() : null;
        if (this._socket != null) {
            this._maxIdleTime = this._socket.getSoTimeout();
        }
    }

    protected ChannelEndPoint(ByteChannel channel, int maxIdleTime) throws IOException {
        this._channel = channel;
        this._maxIdleTime = maxIdleTime;
        Socket socket = this._socket = channel instanceof SocketChannel ? ((SocketChannel)channel).socket() : null;
        if (this._socket != null) {
            this._socket.setSoTimeout(this._maxIdleTime);
        }
    }

    public boolean isBlocking() {
        return !(this._channel instanceof SelectableChannel) || ((SelectableChannel)((Object)this._channel)).isBlocking();
    }

    public boolean blockReadable(long millisecs) throws IOException {
        return true;
    }

    public boolean blockWritable(long millisecs) throws IOException {
        return true;
    }

    public boolean isOpen() {
        return this._channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this._channel.isOpen()) {
            try {
                Socket socket;
                if (this._channel instanceof SocketChannel && !(socket = ((SocketChannel)this._channel).socket()).isClosed() && !socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException e2) {
                Log.ignore(e2);
            }
            catch (UnsupportedOperationException e3) {
                Log.ignore(e3);
            }
            finally {
                this._channel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(Buffer buffer) throws IOException {
        Buffer buf = buffer.buffer();
        int len = 0;
        if (buf instanceof NIOBuffer) {
            ByteBuffer bbuf;
            NIOBuffer nbuf = (NIOBuffer)buf;
            ByteBuffer byteBuffer = bbuf = nbuf.getByteBuffer();
            synchronized (byteBuffer) {
                try {
                    bbuf.position(buffer.putIndex());
                    len = this._channel.read(bbuf);
                    if (len < 0) {
                        this._channel.close();
                    }
                }
                finally {
                    buffer.setPutIndex(bbuf.position());
                    bbuf.position(0);
                }
            }
        }
        throw new IOException("Not Implemented");
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer buffer) throws IOException {
        Buffer buf = buffer.buffer();
        int len = 0;
        if (buf instanceof NIOBuffer) {
            ByteBuffer bbuf;
            NIOBuffer nbuf = (NIOBuffer)buf;
            ByteBuffer byteBuffer = bbuf = nbuf.getByteBuffer();
            synchronized (byteBuffer) {
                try {
                    bbuf.position(buffer.getIndex());
                    bbuf.limit(buffer.putIndex());
                    len = this._channel.write(bbuf);
                }
                finally {
                    if (len > 0) {
                        buffer.skip(len);
                    }
                    bbuf.position(0);
                    bbuf.limit(bbuf.capacity());
                }
            }
        }
        if (buf instanceof RandomAccessFileBuffer) {
            len = buffer.length();
            ((RandomAccessFileBuffer)buf).writeTo(this._channel, buffer.getIndex(), buffer.length());
            if (len > 0) {
                buffer.skip(len);
            }
        } else if (buffer.array() != null) {
            ByteBuffer b2 = ByteBuffer.wrap(buffer.array(), buffer.getIndex(), buffer.length());
            len = this._channel.write(b2);
            if (len > 0) {
                buffer.skip(len);
            }
        } else {
            throw new IOException("Not Implemented");
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        Buffer buf1;
        int length = 0;
        Buffer buf0 = header == null ? null : header.buffer();
        Buffer buffer2 = buf1 = buffer == null ? null : buffer.buffer();
        if (this._channel instanceof GatheringByteChannel && header != null && header.length() != 0 && buf0 instanceof NIOBuffer && buffer != null && buffer.length() != 0 && buf1 instanceof NIOBuffer) {
            NIOBuffer nbuf0 = (NIOBuffer)buf0;
            ByteBuffer bbuf0 = nbuf0.getByteBuffer();
            NIOBuffer nbuf1 = (NIOBuffer)buf1;
            ByteBuffer bbuf1 = nbuf1.getByteBuffer();
            ChannelEndPoint channelEndPoint = this;
            synchronized (channelEndPoint) {
                ByteBuffer byteBuffer = bbuf0;
                synchronized (byteBuffer) {
                    ByteBuffer byteBuffer2 = bbuf1;
                    synchronized (byteBuffer2) {
                        try {
                            bbuf0.position(header.getIndex());
                            bbuf0.limit(header.putIndex());
                            bbuf1.position(buffer.getIndex());
                            bbuf1.limit(buffer.putIndex());
                            this._gather2[0] = bbuf0;
                            this._gather2[1] = bbuf1;
                            length = (int)((GatheringByteChannel)((Object)this._channel)).write(this._gather2);
                            int hl = header.length();
                            if (length > hl) {
                                header.clear();
                                buffer.skip(length - hl);
                            } else if (length > 0) {
                                header.skip(length);
                            }
                        }
                        finally {
                            if (!header.isImmutable()) {
                                header.setGetIndex(bbuf0.position());
                            }
                            if (!buffer.isImmutable()) {
                                buffer.setGetIndex(bbuf1.position());
                            }
                            bbuf0.position(0);
                            bbuf1.position(0);
                            bbuf0.limit(bbuf0.capacity());
                            bbuf1.limit(bbuf1.capacity());
                        }
                    }
                }
            }
        }
        if (header != null) {
            if (buffer != null && buffer.length() > 0 && header.space() > buffer.length()) {
                header.put(buffer);
                buffer.clear();
            }
            if (trailer != null && trailer.length() > 0 && header.space() > trailer.length()) {
                header.put(trailer);
                trailer.clear();
            }
        }
        if (header != null && header.length() > 0) {
            length = this.flush(header);
        }
        if ((header == null || header.length() == 0) && buffer != null && buffer.length() > 0) {
            length += this.flush(buffer);
        }
        if (!(header != null && header.length() != 0 || buffer != null && buffer.length() != 0 || trailer == null || trailer.length() <= 0)) {
            length += this.flush(trailer);
        }
        return length;
    }

    public ByteChannel getChannel() {
        return this._channel;
    }

    public String getLocalAddr() {
        if (this._socket == null) {
            return null;
        }
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getHostAddress();
    }

    public String getLocalHost() {
        if (this._socket == null) {
            return null;
        }
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getCanonicalHostName();
    }

    public int getLocalPort() {
        if (this._socket == null) {
            return 0;
        }
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null) {
            return -1;
        }
        return this._local.getPort();
    }

    public String getRemoteAddr() {
        if (this._socket == null) {
            return null;
        }
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        if (this._socket == null) {
            return null;
        }
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getCanonicalHostName();
    }

    public int getRemotePort() {
        if (this._socket == null) {
            return 0;
        }
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        return this._remote == null ? -1 : this._remote.getPort();
    }

    public Object getTransport() {
        return this._channel;
    }

    public void flush() throws IOException {
    }

    public boolean isBufferingInput() {
        return false;
    }

    public boolean isBufferingOutput() {
        return false;
    }

    public boolean isBufferred() {
        return false;
    }

    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(int timeMs) throws IOException {
        if (this._socket != null && timeMs != this._maxIdleTime) {
            this._socket.setSoTimeout(timeMs > 0 ? timeMs : 0);
        }
        this._maxIdleTime = timeMs;
    }
}

