/*
 * Decompiled with CFR 0.152.
 */
package pythondec;

import java.util.Vector;
import pythondec.PyObject;
import shared.IBytedeque;
import shared.IBytestream;

public class PyTuple
extends PyObject {
    int n;
    public PyObject[] items;

    public PyTuple(IBytestream c) {
        this.n = c.readInt();
        this.items = new PyObject[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.items[i] = PyObject.read(c);
        }
    }

    @Override
    public void marshal(IBytedeque c) {
        c.writeByte((byte)40);
        c.writeInt(this.n);
        for (PyObject item : this.items) {
            item.marshal(c);
        }
    }

    private PyTuple() {
    }

    public String toString() {
        String result = "(PyTuple) ";
        for (PyObject obj : this.items) {
            result = result + obj.toString() + " , ";
        }
        return result;
    }

    public static PyTuple create(Vector<PyObject> objs) {
        PyTuple r = new PyTuple();
        r.n = objs.size();
        r.items = new PyObject[r.n];
        for (int i = 0; i < r.n; ++i) {
            r.items[i] = objs.get(i);
        }
        return r;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == null) {
            return false;
        }
        if (o2.getClass() != PyTuple.class) {
            return false;
        }
        PyTuple o = (PyTuple)o2;
        if (this.items.length != o.items.length) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].compare(o.items[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean compare(PyObject o2) {
        return this.equals(o2);
    }
}

