/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.geom.Area;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class Environment {
    public IPrimitive osm;
    public MultiCascade mc;
    public String layer;
    public StyleSource source;
    private Condition.Context context = Condition.Context.PRIMITIVE;
    private final Selector selector;
    public static final String DEFAULT_LAYER = "default";
    public IPrimitive parent;
    public IPrimitive child;
    public Integer index;
    public Integer count;
    public Set<IPrimitive> children;
    public Map<IPrimitive, Map<List<Way>, List<WaySegment>>> crossingWaysMap;
    public Map<IPrimitive, Area> intersections;
    public Map<IPrimitive, Area> mpAreaCache;
    public Set<IPrimitive> toMatchForSurrounding;

    public Environment() {
        this.selector = null;
    }

    public Environment(IPrimitive osm) {
        this(osm, null, null, null);
    }

    public Environment(IPrimitive osm, MultiCascade mc, String layer, StyleSource source) {
        this.osm = osm;
        this.mc = mc;
        this.layer = layer;
        this.source = source;
        this.selector = null;
    }

    public Environment(Environment other) {
        this(other, other.selector);
    }

    private Environment(Environment other, Selector selector) {
        CheckParameterUtil.ensureParameterNotNull(other);
        this.osm = other.osm;
        this.mc = other.mc;
        this.layer = other.layer;
        this.parent = other.parent;
        this.child = other.child;
        this.source = other.source;
        this.index = other.index;
        this.count = other.count;
        this.context = other.getContext();
        this.children = other.children == null ? null : new LinkedHashSet<IPrimitive>(other.children);
        this.intersections = other.intersections;
        this.crossingWaysMap = other.crossingWaysMap;
        this.mpAreaCache = other.mpAreaCache;
        this.toMatchForSurrounding = other.toMatchForSurrounding;
        this.selector = selector;
    }

    public Environment withPrimitive(IPrimitive osm) {
        Environment e = new Environment(this);
        e.osm = osm;
        return e;
    }

    public Environment withParent(IPrimitive parent) {
        Environment e = new Environment(this);
        e.parent = parent;
        return e;
    }

    public Environment withParentAndIndexAndLinkContext(IPrimitive parent, int index, int count) {
        Environment e = new Environment(this);
        e.parent = parent;
        e.index = index;
        e.count = count;
        e.context = Condition.Context.LINK;
        return e;
    }

    public Environment withChild(IPrimitive child) {
        Environment e = new Environment(this);
        e.child = child;
        return e;
    }

    public Environment withChildAndIndexAndLinkContext(IPrimitive child, int index, int count) {
        Environment e = new Environment(this);
        e.child = child;
        e.index = index;
        e.count = count;
        e.context = Condition.Context.LINK;
        return e;
    }

    public Environment withIndex(int index, int count) {
        Environment e = new Environment(this);
        e.index = index;
        e.count = count;
        return e;
    }

    public Environment withContext(Condition.Context context) {
        Environment e = new Environment(this);
        e.context = context == null ? Condition.Context.PRIMITIVE : context;
        return e;
    }

    public Environment withLinkContext() {
        Environment e = new Environment(this);
        e.context = Condition.Context.LINK;
        return e;
    }

    public Environment withSelector(Selector selector) {
        return new Environment(this, selector);
    }

    public boolean isLinkContext() {
        return Condition.Context.LINK == this.context;
    }

    public boolean hasParentRelation() {
        return this.parent instanceof Relation;
    }

    public Condition.Context getContext() {
        return this.context == null ? Condition.Context.PRIMITIVE : this.context;
    }

    public String getRole() {
        if (this.getContext() == Condition.Context.PRIMITIVE) {
            return null;
        }
        if (this.parent instanceof Relation) {
            return ((Relation)this.parent).getMember(this.index).getRole();
        }
        if (this.child != null && this.osm instanceof Relation) {
            return ((Relation)this.osm).getMember(this.index).getRole();
        }
        return null;
    }

    public Selector selector() {
        return this.selector;
    }

    public Environment clearSelectorMatchingInformation() {
        this.parent = null;
        this.child = null;
        this.index = null;
        this.count = null;
        this.children = null;
        this.intersections = null;
        this.crossingWaysMap = null;
        return this;
    }

    public Cascade getCascade() {
        return this.getCascade(null);
    }

    public Cascade getCascade(String layer) {
        return this.mc == null ? null : this.mc.getCascade(layer == null ? this.layer : layer);
    }
}

