/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;

public class MultipolygonBuilder {
    public final List<JoinedPolygon> outerWays;
    public final List<JoinedPolygon> innerWays;

    public MultipolygonBuilder(List<JoinedPolygon> outerWays, List<JoinedPolygon> innerWays) {
        this.outerWays = outerWays;
        this.innerWays = innerWays;
    }

    public MultipolygonBuilder() {
        this.outerWays = new ArrayList<JoinedPolygon>(0);
        this.innerWays = new ArrayList<JoinedPolygon>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeFromWays(Collection<Way> ways) {
        MultipolygonTest mpTest = new MultipolygonTest();
        Relation calculated = mpTest.makeFromWays(ways);
        try {
            if (!mpTest.getErrors().isEmpty()) {
                String string = mpTest.getErrors().iterator().next().getMessage();
                return string;
            }
            Pair<List<JoinedPolygon>, List<JoinedPolygon>> outerInner = MultipolygonBuilder.joinWays(calculated);
            this.outerWays.clear();
            this.innerWays.clear();
            this.outerWays.addAll((Collection)outerInner.a);
            this.innerWays.addAll((Collection)outerInner.b);
            String string = null;
            return string;
        }
        finally {
            calculated.setMembers((List<RelationMember>)null);
        }
    }

    public static Pair<List<JoinedPolygon>, List<JoinedPolygon>> joinWays(Relation multipolygon) {
        CheckParameterUtil.ensureThat(multipolygon.isMultipolygon(), "multipolygon.isMultipolygon");
        Map members = multipolygon.getMembers().stream().filter(RelationMember::isWay).collect(Collectors.groupingBy(RelationMember::getRole, Collectors.mapping(RelationMember::getWay, Collectors.toSet())));
        List<JoinedPolygon> outerRings = MultipolygonBuilder.joinWays(members.getOrDefault("outer", Collections.emptySet()));
        List<JoinedPolygon> innerRings = MultipolygonBuilder.joinWays(members.getOrDefault("inner", Collections.emptySet()));
        return Pair.create(outerRings, innerRings);
    }

    public static List<JoinedPolygon> joinWays(Collection<Way> ways) {
        ArrayList<JoinedPolygon> joinedWays = new ArrayList<JoinedPolygon>();
        MultiMap<Node, Way> nodesWithConnectedWays = new MultiMap<Node, Way>();
        HashSet<Way> usedWays = new HashSet<Way>();
        for (Way w : ways) {
            if (w.getNodesCount() < 2) {
                throw new JoinedPolygonCreationException(I18n.tr("Cannot add a way with only {0} nodes.", w.getNodesCount()));
            }
            if (w.isClosed()) {
                JoinedPolygon jw = new JoinedPolygon(w);
                joinedWays.add(jw);
                usedWays.add(w);
                continue;
            }
            nodesWithConnectedWays.put(w.lastNode(), w);
            nodesWithConnectedWays.put(w.firstNode(), w);
        }
        for (Way startWay : ways) {
            if (usedWays.contains(startWay)) continue;
            Node startNode = startWay.firstNode();
            ArrayList<Way> collectedWays = new ArrayList<Way>();
            ArrayList<Boolean> collectedWaysReverse = new ArrayList<Boolean>();
            Way curWay = startWay;
            Node prevNode = startNode;
            while (true) {
                boolean curWayReverse = prevNode == curWay.lastNode();
                Node nextNode = curWayReverse ? curWay.firstNode() : curWay.lastNode();
                collectedWays.add(curWay);
                collectedWaysReverse.add(curWayReverse);
                if (nextNode == startNode) break;
                Set adjacentWays = nodesWithConnectedWays.get(nextNode);
                if (adjacentWays.size() != 2) {
                    throw new JoinedPolygonCreationException(I18n.tr("Each node must connect exactly 2 ways", new Object[0]));
                }
                Way nextWay = null;
                for (Way way : adjacentWays) {
                    if (way == curWay) continue;
                    nextWay = way;
                }
                curWay = nextWay;
                prevNode = nextNode;
            }
            usedWays.addAll(collectedWays);
            joinedWays.add(new JoinedPolygon(collectedWays, collectedWaysReverse));
        }
        return joinedWays;
    }

    public static class JoinedPolygonCreationException
    extends RuntimeException {
        public JoinedPolygonCreationException(String message) {
            super(message);
        }
    }

    public static class JoinedPolygon {
        public final List<Way> ways;
        public final List<Boolean> reversed;
        public final List<Node> nodes;
        public final Area area;

        public JoinedPolygon(List<Way> ways, List<Boolean> reversed) {
            this.ways = ways;
            this.reversed = reversed;
            this.nodes = this.getNodes();
            this.area = Geometry.getArea(this.nodes);
        }

        public JoinedPolygon(Way way) {
            this(Collections.singletonList(way), Collections.singletonList(Boolean.FALSE));
        }

        public List<Node> getNodes() {
            ArrayList<Node> ringNodes = new ArrayList<Node>();
            for (int waypos = 0; waypos < this.ways.size(); ++waypos) {
                int pos;
                Way way = this.ways.get(waypos);
                if (Boolean.FALSE.equals(this.reversed.get(waypos))) {
                    for (pos = 0; pos < way.getNodesCount() - 1; ++pos) {
                        ringNodes.add(way.getNode(pos));
                    }
                    continue;
                }
                for (pos = way.getNodesCount() - 1; pos > 0; --pos) {
                    ringNodes.add(way.getNode(pos));
                }
            }
            return ringNodes;
        }
    }
}

