/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Charsets;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.exif.makernotes.NikonPictureControl1Descriptor;
import java.io.IOException;
import java.util.HashMap;

public final class NikonPictureControl1Directory
extends Directory {
    public static final int TAG_PICTURE_CONTROL_VERSION = 0;
    public static final int TAG_PICTURE_CONTROL_NAME = 4;
    public static final int TAG_PICTURE_CONTROL_BASE = 24;
    public static final int TAG_PICTURE_CONTROL_ADJUST = 48;
    public static final int TAG_PICTURE_CONTROL_QUICK_ADJUST = 49;
    public static final int TAG_SHARPNESS = 50;
    public static final int TAG_CONTRAST = 51;
    public static final int TAG_BRIGHTNESS = 52;
    public static final int TAG_SATURATION = 53;
    public static final int TAG_HUE_ADJUSTMENT = 54;
    public static final int TAG_FILTER_EFFECT = 55;
    public static final int TAG_TONING_EFFECT = 56;
    public static final int TAG_TONING_SATURATION = 57;
    private static final HashMap<Integer, String> TAG_NAME_MAP = new HashMap();

    public NikonPictureControl1Directory() {
        this.setDescriptor(new NikonPictureControl1Descriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Nikon PictureControl 1";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return TAG_NAME_MAP;
    }

    public static NikonPictureControl1Directory read(byte[] bytes) throws IOException {
        int EXPECTED_LENGTH = 58;
        if (bytes.length != 58) {
            throw new IllegalArgumentException("Must have 58 bytes.");
        }
        SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
        NikonPictureControl1Directory directory = new NikonPictureControl1Directory();
        directory.setObject(0, reader.getStringValue(4, Charsets.UTF_8));
        directory.setObject(4, reader.getStringValue(20, Charsets.UTF_8));
        directory.setObject(24, reader.getStringValue(20, Charsets.UTF_8));
        reader.skip(4L);
        directory.setObject(48, reader.getUInt8());
        directory.setObject(49, reader.getUInt8());
        directory.setObject(50, reader.getUInt8());
        directory.setObject(51, reader.getUInt8());
        directory.setObject(52, reader.getUInt8());
        directory.setObject(53, reader.getUInt8());
        directory.setObject(54, reader.getUInt8());
        directory.setObject(55, reader.getUInt8());
        directory.setObject(56, reader.getUInt8());
        directory.setObject(57, reader.getUInt8());
        assert (reader.getPosition() == 58L);
        return directory;
    }

    static {
        TAG_NAME_MAP.put(0, "Picture Control Version");
        TAG_NAME_MAP.put(4, "Picture Control Name");
        TAG_NAME_MAP.put(24, "Picture Control Base");
        TAG_NAME_MAP.put(48, "Picture Control Adjust");
        TAG_NAME_MAP.put(49, "Picture Control Quick Adjust");
        TAG_NAME_MAP.put(50, "Sharpness");
        TAG_NAME_MAP.put(51, "Contrast");
        TAG_NAME_MAP.put(52, "Brightness");
        TAG_NAME_MAP.put(53, "Saturation");
        TAG_NAME_MAP.put(54, "Hue Adjustment");
        TAG_NAME_MAP.put(55, "Filter Effect");
        TAG_NAME_MAP.put(56, "Toning Effect");
        TAG_NAME_MAP.put(57, "Toning Saturation");
    }
}

