/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.net.URI;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.io.auth.CredentialsAgent;
import org.openstreetmap.josm.io.auth.CredentialsAgentException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class OAuthAccessTokenHolder {
    private static OAuthAccessTokenHolder instance;
    private boolean saveToPreferences;
    private final Map<String, Map<OAuthVersion, IOAuthToken>> tokenMap = new HashMap<String, Map<OAuthVersion, IOAuthToken>>();

    public static synchronized OAuthAccessTokenHolder getInstance() {
        if (instance == null) {
            instance = new OAuthAccessTokenHolder();
        }
        return instance;
    }

    public boolean isSaveToPreferences() {
        return this.saveToPreferences;
    }

    public void setSaveToPreferences(boolean saveToPreferences) {
        this.saveToPreferences = saveToPreferences;
    }

    public IOAuthToken getAccessToken(String api, OAuthVersion version) {
        if (this.tokenMap.containsKey(api = Optional.ofNullable(URI.create(api).getHost()).orElse(api)) && this.tokenMap.get(api).containsKey((Object)version)) {
            Map<OAuthVersion, IOAuthToken> map = this.tokenMap.get(api);
            return map.get((Object)version);
        }
        try {
            IOAuthToken token = CredentialsManager.getInstance().lookupOAuthAccessToken(api);
            if (token == null || token.getOAuthType() == version) {
                this.setAccessToken(api, token);
                return token;
            }
        }
        catch (CredentialsAgentException exception) {
            Logging.trace(exception);
        }
        return null;
    }

    public void setAccessToken(String api, IOAuthToken token) {
        Objects.requireNonNull(api, "api url");
        api = Optional.ofNullable(URI.create(api).getHost()).orElse(api);
        if (token == null) {
            if (this.tokenMap.containsKey(api)) {
                this.tokenMap.get(api).clear();
            }
        } else {
            this.tokenMap.computeIfAbsent(api, key -> new EnumMap(OAuthVersion.class)).put(token.getOAuthType(), token);
        }
    }

    public void init(CredentialsAgent cm) {
        CheckParameterUtil.ensureParameterNotNull(cm, "cm");
        this.saveToPreferences = Config.getPref().getBoolean("oauth.access-token.save-to-preferences", true);
    }

    public void save(CredentialsAgent cm) {
        CheckParameterUtil.ensureParameterNotNull(cm, "cm");
        Config.getPref().putBoolean("oauth.access-token.save-to-preferences", this.saveToPreferences);
        try {
            if (!this.saveToPreferences) {
                for (String host : this.tokenMap.keySet()) {
                    cm.storeOAuthAccessToken(host, null);
                }
            } else {
                for (Map.Entry<String, Map<OAuthVersion, IOAuthToken>> entry : this.tokenMap.entrySet()) {
                    if (entry.getValue().isEmpty()) {
                        cm.storeOAuthAccessToken(entry.getKey(), null);
                        continue;
                    }
                    for (OAuthVersion version : OAuthVersion.values()) {
                        if (!entry.getValue().containsKey((Object)version)) continue;
                        cm.storeOAuthAccessToken(entry.getKey(), entry.getValue().get((Object)version));
                    }
                }
            }
        }
        catch (CredentialsAgentException e) {
            Logging.error(e);
            Logging.warn(I18n.tr("Failed to store OAuth Access Token to credentials manager", new Object[0]));
            Logging.warn(I18n.tr("Current credential manager is of type ''{0}''", cm.getClass().getName()));
        }
    }

    public void clear() {
        this.tokenMap.clear();
    }
}

