/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.FallbackProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;

public class NamedColorProperty
extends AbstractProperty<Color> {
    public static final String NAMED_COLOR_PREFIX = "clr.";
    public static final String COLOR_CATEGORY_GENERAL = "general";
    public static final String COLOR_CATEGORY_MAPPAINT = "mappaint";
    private final String category;
    private final String source;
    private final String name;

    public NamedColorProperty(String category, String source, String name, Color defaultValue) {
        super(NamedColorProperty.getKey(category, source, name), defaultValue);
        CheckParameterUtil.ensureParameterNotNull(category, "category");
        CheckParameterUtil.ensureParameterNotNull(name, "name");
        this.category = category;
        this.source = source;
        this.name = name;
    }

    public NamedColorProperty(String name, Color defaultValue) {
        this(COLOR_CATEGORY_GENERAL, null, name, defaultValue);
    }

    private static String getKey(String category, String source, String name) {
        CheckParameterUtil.ensureParameterNotNull(category, "category");
        CheckParameterUtil.ensureParameterNotNull(name, "name");
        return NAMED_COLOR_PREFIX + category + "." + (source == null ? "" : source + ".") + name;
    }

    private List<String> getDefaultValuePref() {
        return this.defaultValue == null ? null : NamedColorProperty.getValuePref((Color)this.defaultValue, this.category, this.source, this.name);
    }

    @Override
    public Color get() {
        List<String> data = this.getPreferences().getList(this.getKey(), this.getDefaultValuePref());
        if (super.isSet() && data != null && !data.isEmpty()) {
            return ColorHelper.html2color(data.get(0));
        }
        return (Color)this.defaultValue;
    }

    @Override
    public boolean isSet() {
        this.get();
        return super.isSet();
    }

    public String getCategory() {
        return this.category;
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    private static List<String> getValuePref(Color color, String category, String source, String name) {
        CheckParameterUtil.ensureParameterNotNull(color, "color");
        CheckParameterUtil.ensureParameterNotNull(category, "category");
        CheckParameterUtil.ensureParameterNotNull(name, "name");
        return Arrays.asList(ColorHelper.color2html(color, true), category, source == null ? "" : source, name);
    }

    @Override
    public boolean put(Color value) {
        return this.getPreferences().putList(this.getKey(), value == null ? null : NamedColorProperty.getValuePref(value, this.category, this.source, this.name));
    }

    public FallbackProperty<Color> getChildColor(String category, String source, String name) {
        return new FallbackProperty<Color>(new NamedColorProperty(category, source, name, (Color)this.defaultValue), this);
    }

    public FallbackProperty<Color> getChildColor(String name) {
        return this.getChildColor(this.category, this.source, name);
    }
}

