/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.languagetool.server.DatabaseLogEntry;

public class DatabaseMiscLogEntry
extends DatabaseLogEntry {
    private final Calendar date;
    private final Long server;
    private final Long client;
    private final Long user;
    private final String message;

    public DatabaseMiscLogEntry(Long server, Long client, Long user, String message) {
        this.server = server;
        this.client = client;
        this.user = user;
        this.message = message;
        this.date = Calendar.getInstance();
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        parameters.put("date", dateFormat.format(this.date.getTime()));
        parameters.put("server", this.server);
        parameters.put("client", this.client);
        parameters.put("user", this.user);
        parameters.put("message", this.message);
        return parameters;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.miscLogs";
    }

    @Override
    public void followup(Map<Object, Object> parameters) {
    }
}

