/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.mining.word2vec;

import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.mining.word2vec.Utility;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public final class VectorsReader {
    public final Charset ENCODING = Charset.forName("UTF-8");
    int words;
    int size;
    String[] vocab;
    float[][] matrix;
    final String file;

    public VectorsReader(String file) {
        this.file = file;
    }

    public void readVectorFile() throws IOException {
        Predefine.logger.info(String.format("reading %s file. please wait...\n", this.file));
        InputStream is = null;
        InputStreamReader r = null;
        BufferedReader br = null;
        try {
            is = IOUtil.newInputStream(this.file);
            r = new InputStreamReader(is, this.ENCODING);
            br = new BufferedReader(r);
            String line = br.readLine();
            this.words = Integer.parseInt(line.split("\\s+")[0].trim());
            this.size = Integer.parseInt(line.split("\\s+")[1].trim());
            this.vocab = new String[this.words];
            this.matrix = new float[this.words][];
            for (int i = 0; i < this.words; ++i) {
                int j;
                line = br.readLine().trim();
                String[] params = line.split("\\s+");
                if (params.length != this.size + 1) {
                    Predefine.logger.info("\u8bcd\u5411\u91cf\u6709\u4e00\u884c\u683c\u5f0f\u4e0d\u89c4\u8303\uff08\u53ef\u80fd\u662f\u5355\u8bcd\u542b\u6709\u7a7a\u683c\uff09\uff1a" + line);
                    --this.words;
                    --i;
                    continue;
                }
                this.vocab[i] = params[0];
                this.matrix[i] = new float[this.size];
                double len = 0.0;
                for (j = 0; j < this.size; ++j) {
                    this.matrix[i][j] = Float.parseFloat(params[j + 1]);
                    len += (double)(this.matrix[i][j] * this.matrix[i][j]);
                }
                len = Math.sqrt(len);
                j = 0;
                while (j < this.size) {
                    float[] fArray = this.matrix[i];
                    int n = j++;
                    fArray[n] = (float)((double)fArray[n] / len);
                }
            }
            if (this.words != this.vocab.length) {
                this.vocab = Utility.shrink(this.vocab, new String[this.words]);
                this.matrix = (float[][])Utility.shrink(this.matrix, new float[this.words][]);
            }
        }
        catch (IOException e) {
            Utility.closeQuietly(br);
            Utility.closeQuietly(r);
            Utility.closeQuietly(is);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getNumWords() {
        return this.words;
    }

    public String getWord(int idx) {
        return this.vocab[idx];
    }

    public float getMatrixElement(int row, int column) {
        return this.matrix[row][column];
    }
}

