/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.io.IOException;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.hints.HtmlRule;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.css.CssIdsVisitor;
import org.netbeans.modules.html.editor.hints.css.MissingCssElement;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MissingIdRule
extends HtmlRule {
    private static final String MSG_MISSING_CSS_ID = NbBundle.getMessage(MissingCssElement.class, (String)"MSG_MissingCssId");
    private static final String MSG_MISSING_CSS_ID_DESC = NbBundle.getMessage(MissingCssElement.class, (String)"MSG_MissingCssId_Desc");

    @Override
    protected void run(HtmlRuleContext context, List<Hint> result) {
        try {
            HtmlParserResult parserResult = context.getHtmlParserResult();
            CssIdsVisitor visitor = new CssIdsVisitor((Rule)this, context, result);
            ElementUtils.visitChildren((Element)parserResult.root(), (ElementVisitor)visitor, (ElementType)ElementType.OPEN_TAG);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    @Override
    public boolean appliesTo(RuleContext context) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        FileObject file = result.getSnapshot().getSource().getFileObject();
        if (file == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        return project != null;
    }

    @Override
    public String getDescription() {
        return MSG_MISSING_CSS_ID_DESC;
    }

    @Override
    public String getDisplayName() {
        return MSG_MISSING_CSS_ID;
    }

    @Override
    public boolean showInTasklist() {
        return false;
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.CURRENT_LINE_WARNING;
    }
}

