/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.spi;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportProvider;
import org.netbeans.modules.websvc.rest.ApplicationSubclassGenerator;
import org.netbeans.modules.websvc.rest.MiscPrivateUtilities;
import org.netbeans.modules.websvc.rest.WebXmlUpdater;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.model.api.RestApplicationModel;
import org.netbeans.modules.websvc.rest.model.api.RestApplications;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.model.spi.RestServicesMetadataModelFactory;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;

public abstract class RestSupport {
    public static final String SWDP_LIBRARY = "restlib";
    public static final String RESTAPI_LIBRARY = "restapi";
    protected static final String GFV3_RESTLIB = "restlib_gfv3ee6";
    protected static final String GFV31_RESTLIB = "restlib_gfv31ee6";
    public static final String PROP_SWDP_CLASSPATH = "libs.swdp.classpath";
    public static final String PROP_RESTBEANS_TEST_DIR = "restbeans.test.dir";
    public static final String PROP_RESTBEANS_TEST_FILE = "restbeans.test.file";
    public static final String PROP_RESTBEANS_TEST_URL = "restbeans.test.url";
    public static final String PROP_BASE_URL_TOKEN = "base.url.token";
    public static final String PROP_APPLICATION_PATH = "rest.application.path";
    public static final String BASE_URL_TOKEN = "___BASE_URL___";
    public static final String RESTBEANS_TEST_DIR = "build/generated-sources/rest-test";
    public static final String COMMAND_TEST_RESTBEANS = "test-restbeans";
    public static final String COMMAND_DEPLOY = "run-deploy";
    public static final String TEST_RESBEANS = "test-resbeans";
    public static final String TEST_RESBEANS_HTML = "test-resbeans.html";
    public static final String TEST_RESBEANS_JS = "test-resbeans.js";
    public static final String TEST_RESBEANS_CSS = "test-resbeans.css";
    public static final String TEST_RESBEANS_CSS2 = "css_master-all.css";
    public static final String REST_SERVLET_ADAPTOR = "ServletAdaptor";
    public static final String JAX_RS_APPLICATION_CLASS = "javax.ws.rs.core.Application";
    public static final String REST_SERVLET_ADAPTOR_CLASS = "com.sun.jersey.spi.container.servlet.ServletContainer";
    public static final String REST_SERVLET_ADAPTOR_CLASS_OLD = "com.sun.ws.rest.impl.container.servlet.ServletAdaptor";
    public static final String REST_SERVLET_ADAPTOR_CLASS_2_0 = "org.glassfish.jersey.servlet.ServletContainer";
    public static final String REST_SPRING_SERVLET_ADAPTOR_CLASS = "com.sun.jersey.spi.spring.container.servlet.SpringServlet";
    public static final String REST_SERVLET_ADAPTOR_MAPPING = "/resources/*";
    public static final String PARAM_WEB_RESOURCE_CLASS = "webresourceclass";
    public static final String WEB_RESOURCE_CLASS = "webresources.WebResources";
    public static final String REST_API_JAR = "jsr311-api.jar";
    public static final String REST_RI_JAR = "jersey";
    public static final String JSR311_JAR_PATTERN = "jsr311-api.*\\.jar";
    public static final String JERSEY_API_LOCATION = "modules/ext/rest";
    public static final String JTA_USER_TRANSACTION_CLASS = "javax/transaction/UserTransaction.class";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String TOMCAT_SERVER_TYPE = "tomcat";
    public static final String GFV3_SERVER_TYPE = "gfv3";
    public static final String GFV2_SERVER_TYPE = "J2EE";
    public static final int PROJECT_TYPE_DESKTOP = 0;
    public static final int PROJECT_TYPE_WEB = 1;
    public static final int PROJECT_TYPE_NB_MODULE = 2;
    public static final String PROP_REST_RESOURCES_PATH = "rest.resources.path";
    public static final String PROP_REST_CONFIG_TYPE = "rest.config.type";
    public static final String PROP_REST_JERSEY = "rest.jersey.type";
    public static final String CONFIG_TYPE_IDE = "ide";
    public static final String CONFIG_TYPE_USER = "user";
    public static final String CONFIG_TYPE_DD = "dd";
    public static final String JERSEY_CONFIG_IDE = "ide";
    public static final String JERSEY_CONFIG_SERVER = "server";
    public static final String CONTAINER_RESPONSE_FILTER = "com.sun.jersey.spi.container.ContainerResponseFilters";
    protected static final String JERSEY_SPRING_JAR_PATTERN = "jersey-spring.*\\.jar";
    private volatile PropertyChangeListener restModelListener;
    private RequestProcessor RP = new RequestProcessor(RestSupport.class);
    private AntProjectHelper helper;
    private RestServicesModel restServicesModel;
    private RestApplicationModel restApplicationModel;
    private final Project project;
    private ApplicationSubclassGenerator applicationSubclassGenerator;
    private WebXmlUpdater webXmlUpdater;

    public RestSupport(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Null project");
        }
        this.project = project;
        this.applicationSubclassGenerator = new ApplicationSubclassGenerator(this);
        this.webXmlUpdater = new WebXmlUpdater(this);
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                String configType = RestSupport.this.getProjectProperty(RestSupport.PROP_REST_CONFIG_TYPE);
                if ("ide".equals(configType)) {
                    RestSupport.this.initListener();
                }
            }
        });
    }

    private void initListener() {
        if (this.restModelListener == null) {
            this.restModelListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    RestSupport.this.applicationSubclassGenerator.refreshApplicationSubclass();
                }
            };
            RestServicesModel servicesModel = this.getRestServicesModel();
            if (servicesModel != null) {
                servicesModel.addPropertyChangeListener(this.restModelListener);
            }
        }
    }

    public final void ensureRestDevelopmentReady(final RestConfig restConfig) throws IOException {
        assert (restConfig != null);
        if (this.isRestSupportOn()) {
            return;
        }
        this.setProjectProperty(PROP_REST_CONFIG_TYPE, restConfig == RestConfig.DD ? CONFIG_TYPE_DD : "ide");
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    RestSupport.this.ensureRestDevelopmentReadyImpl(restConfig);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private void ensureRestDevelopmentReadyImpl(RestConfig restConfig) throws IOException {
        boolean hasJaxRs;
        this.extendBuildScripts();
        boolean hasJersey2 = this.hasJersey2(true);
        boolean hasJaxRsOnClasspath = this.hasJaxRsOnClasspath(false);
        boolean bl = hasJaxRs = this.isEESpecWithJaxRS() || hasJaxRsOnClasspath || this.hasJersey1(true) || hasJersey2;
        if (this.isEE5() && (hasJersey2 || !hasJaxRs)) {
            this.webXmlUpdater.addJersey2ResourceConfigToWebApp(restConfig);
        }
        if (!hasJaxRs || !hasJaxRsOnClasspath) {
            boolean jaxRSApiAdded = false;
            JaxRsStackSupport support = this.getJaxRsStackSupport();
            if (support != null) {
                jaxRSApiAdded = support.addJsr311Api(this.getProject());
            }
            if (!jaxRSApiAdded) {
                JaxRsStackSupport.getDefault().addJsr311Api(this.getProject());
            }
        }
        if (!hasJersey2 && !this.hasJersey1(true)) {
            this.extendJerseyClasspath();
        }
        this.handleSpring();
        ProjectManager.getDefault().saveProject(this.getProject());
    }

    protected void extendJerseyClasspath() {
        JaxRsStackSupport support = this.getJaxRsStackSupport();
        boolean jerseyAdded = false;
        if (support != null) {
            jerseyAdded = support.extendsJerseyProjectClasspath(this.getProject());
        }
        if (!jerseyAdded) {
            JaxRsStackSupport.getDefault().extendsJerseyProjectClasspath(this.getProject());
        }
    }

    protected abstract void extendBuildScripts() throws IOException;

    protected abstract void handleSpring() throws IOException;

    public abstract String getApplicationPathFromDialog(List<RestApplication> var1);

    public synchronized RestServicesModel getRestServicesModel() {
        if (this.restServicesModel == null) {
            FileObject sourceRoot = MiscUtilities.findSourceRoot(this.getProject());
            if (sourceRoot == null) {
                return null;
            }
            ClassPathProvider cpProvider = (ClassPathProvider)this.getProject().getLookup().lookup(ClassPathProvider.class);
            if (cpProvider != null) {
                ClassPath compileCP = cpProvider.findClassPath(sourceRoot, "classpath/compile");
                ClassPath bootCP = cpProvider.findClassPath(sourceRoot, "classpath/boot");
                ClassPath sourceCP = cpProvider.findClassPath(sourceRoot, "classpath/source");
                if (compileCP != null && bootCP != null) {
                    MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)bootCP, (ClassPath)RestSupport.extendClassPathWithJaxRsApisIfNecessary(compileCP), (ClassPath)sourceCP, null);
                    this.restServicesModel = RestServicesMetadataModelFactory.createMetadataModel(metadataUnit, this.project);
                }
            }
        }
        return this.restServicesModel;
    }

    public synchronized RestApplicationModel getRestApplicationsModel() {
        if (this.restApplicationModel == null) {
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)MiscPrivateUtilities.getClassPath(this.getProject(), "classpath/boot"), (ClassPath)MiscPrivateUtilities.getClassPath(this.getProject(), "classpath/compile"), (ClassPath)MiscPrivateUtilities.getClassPath(this.getProject(), "classpath/source"), null);
            this.restApplicationModel = RestServicesMetadataModelFactory.createApplicationMetadataModel(metadataUnit, this.project);
        }
        return this.restApplicationModel;
    }

    private static ClassPath extendClassPathWithJaxRsApisIfNecessary(ClassPath classPath) {
        FileObject fo;
        File[] jsr311Jars;
        if (classPath.findResource("javax/ws/rs/core/Application.class") != null) {
            return classPath;
        }
        File jerseyRoot = InstalledFileLocator.getDefault().locate(JERSEY_API_LOCATION, "org.netbeans.modules.websvc.restlib", false);
        if (jerseyRoot != null && jerseyRoot.isDirectory() && (jsr311Jars = jerseyRoot.listFiles(new MiscPrivateUtilities.JerseyFilter(JSR311_JAR_PATTERN))) != null && jsr311Jars.length > 0 && (fo = FileUtil.toFileObject((File)jsr311Jars[0])) != null && (fo = FileUtil.getArchiveRoot((FileObject)fo)) != null) {
            return ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath, ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fo})});
        }
        return classPath;
    }

    public abstract FileObject generateTestClient(File var1, String var2) throws IOException;

    public Project getProject() {
        return this.project;
    }

    public void setProjectProperty(String name, String value) {
        MiscPrivateUtilities.setProjectProperty(this.getProject(), this.getAntProjectHelper(), name, value, "nbproject/project.properties");
    }

    public void setPrivateProjectProperty(String name, String value) {
        MiscPrivateUtilities.setProjectProperty(this.getProject(), this.getAntProjectHelper(), name, value, "nbproject/private/private.properties");
    }

    public String getProjectProperty(String name) {
        if (this.getAntProjectHelper() == null) {
            return null;
        }
        return this.helper.getStandardPropertyEvaluator().getProperty(name);
    }

    public void removeProjectProperties(final String[] propertyNames) {
        if (this.getAntProjectHelper() == null) {
            return;
        }
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    try {
                        MiscPrivateUtilities.removeProperty(RestSupport.this.getAntProjectHelper(), propertyNames, "nbproject/project.properties");
                        MiscPrivateUtilities.removeProperty(RestSupport.this.getAntProjectHelper(), propertyNames, "nbproject/private/private.properties");
                        ProjectManager.getDefault().saveProject(RestSupport.this.getProject());
                    }
                    catch (IOException ioe) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, ioe.getLocalizedMessage(), ioe);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
        }
    }

    public AntProjectHelper getAntProjectHelper() {
        JAXWSSupport support;
        JAXWSSupportProvider provider;
        if (this.helper == null && (provider = (JAXWSSupportProvider)this.project.getLookup().lookup(JAXWSSupportProvider.class)) != null && (support = provider.findJAXWSSupport(this.project.getProjectDirectory())) != null) {
            this.helper = support.getAntProjectHelper();
        }
        return this.helper;
    }

    public boolean hasJTASupport() {
        return MiscPrivateUtilities.hasResource(this.getProject(), JTA_USER_TRANSACTION_CLASS);
    }

    public boolean hasSpringSupport() {
        return MiscPrivateUtilities.hasResource(this.getProject(), "org/springframework/transaction/annotation/Transactional.class");
    }

    public String getServerType() {
        return this.getProjectProperty(J2EE_SERVER_TYPE);
    }

    public boolean isServerTomcat() {
        String serverType = this.getServerType();
        if (serverType != null) {
            return serverType.toLowerCase().contains(TOMCAT_SERVER_TYPE);
        }
        return false;
    }

    public boolean isServerGFV3() {
        if (this.getServerType() == null) {
            return false;
        }
        return this.getServerType().startsWith(GFV3_SERVER_TYPE);
    }

    public boolean isServerGFV2() {
        return GFV2_SERVER_TYPE.equals(this.getServerType());
    }

    public abstract File getLocalTargetTestRest();

    public String getBaseURL() {
        String applicationPath = this.getApplicationPath();
        if (applicationPath != null && !applicationPath.startsWith("/")) {
            applicationPath = "/" + applicationPath;
        }
        return MiscUtilities.getContextRootURL(this.getProject()) + "||" + applicationPath;
    }

    public abstract void deploy() throws IOException;

    public boolean isRestSupportOn() {
        if (this.getAntProjectHelper() == null) {
            return false;
        }
        return this.getProjectProperty(PROP_REST_CONFIG_TYPE) != null;
    }

    public FileObject getPersistenceXml() {
        PersistenceScope ps = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (ps != null) {
            return ps.getPersistenceXml();
        }
        return null;
    }

    public WebApp getWebApp() throws IOException {
        return this.webXmlUpdater.findWebApp();
    }

    WebXmlUpdater getWebXmlUpdater() {
        return this.webXmlUpdater;
    }

    public boolean hasServerJerseyLibrary() {
        return JaxRsStackSupport.getInstance((Project)this.project) != null;
    }

    public JaxRsStackSupport getJaxRsStackSupport() {
        return JaxRsStackSupport.getInstance((Project)this.project);
    }

    public boolean isEESpecWithJaxRS() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        boolean isJee6 = Profile.JAVA_EE_6_WEB.equals(profile) || Profile.JAVA_EE_6_FULL.equals(profile);
        boolean isJee7 = Profile.JAVA_EE_7_WEB.equals(profile) || Profile.JAVA_EE_7_FULL.equals(profile);
        boolean isJee8 = Profile.JAVA_EE_8_WEB.equals(profile) || Profile.JAVA_EE_8_FULL.equals(profile);
        boolean isJakartaee8 = Profile.JAKARTA_EE_8_WEB.equals(profile) || Profile.JAKARTA_EE_8_FULL.equals(profile);
        boolean isJakartaee9 = Profile.JAKARTA_EE_9_WEB.equals(profile) || Profile.JAKARTA_EE_9_FULL.equals(profile);
        return isJee6 && MiscPrivateUtilities.supportsTargetProfile(this.project, Profile.JAVA_EE_6_FULL) || isJee7;
    }

    public boolean isJakartaEE9() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return Profile.JAKARTA_EE_9_WEB.equals(profile) || Profile.JAKARTA_EE_9_FULL.equals(profile);
    }

    public boolean isJakartaEE8() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return Profile.JAKARTA_EE_8_WEB.equals(profile) || Profile.JAKARTA_EE_8_FULL.equals(profile);
    }

    public boolean isEE8() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return Profile.JAVA_EE_8_WEB.equals(profile) || Profile.JAVA_EE_8_FULL.equals(profile);
    }

    public boolean isEE7() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return Profile.JAVA_EE_7_WEB.equals(profile) || Profile.JAVA_EE_7_FULL.equals(profile);
    }

    public boolean isEE6() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return Profile.JAVA_EE_6_WEB.equals(profile) || Profile.JAVA_EE_6_FULL.equals(profile);
    }

    public boolean isEE5() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return Profile.JAVA_EE_5.equals(profile);
    }

    public boolean hasJersey2(boolean checkServerClasspath) {
        JaxRsStackSupport support;
        if (MiscPrivateUtilities.hasResource(this.getProject(), "org/glassfish/jersey/servlet/ServletContainer.class")) {
            return true;
        }
        if (checkServerClasspath && (support = this.getJaxRsStackSupport()) != null) {
            return support.isBundled(REST_SERVLET_ADAPTOR_CLASS_2_0);
        }
        return false;
    }

    public boolean hasJersey1(boolean checkServerClasspath) {
        JaxRsStackSupport support;
        if (MiscPrivateUtilities.hasResource(this.getProject(), "com/sun/jersey/spi/container/servlet/ServletContainer.class")) {
            return true;
        }
        if (checkServerClasspath && (support = this.getJaxRsStackSupport()) != null) {
            return support.isBundled(REST_SERVLET_ADAPTOR_CLASS);
        }
        return false;
    }

    public boolean hasJaxRsOnClasspath(boolean checkServerClasspath) {
        JaxRsStackSupport support;
        if (MiscPrivateUtilities.hasResource(this.getProject(), "javax/ws/rs/core/Application.class")) {
            return true;
        }
        if (checkServerClasspath && (support = this.getJaxRsStackSupport()) != null) {
            return support.isBundled(JAX_RS_APPLICATION_CLASS);
        }
        return false;
    }

    public void configure(String ... packages) throws IOException {
        String configType = this.getProjectProperty(PROP_REST_CONFIG_TYPE);
        if (CONFIG_TYPE_DD.equals(configType)) {
            this.webXmlUpdater.configRestPackages(packages);
        } else if ("ide".equals(configType)) {
            this.initListener();
            this.applicationSubclassGenerator.refreshApplicationSubclass();
        }
    }

    public String getApplicationPath() {
        String pathFromDD = MiscUtilities.getApplicationPathFromDD(this.webXmlUpdater.findWebApp());
        String applPath = ApplicationSubclassGenerator.getApplicationPathFromAnnotations(this, pathFromDD);
        return applPath == null ? "webresources" : applPath;
    }

    public abstract void logResourceCreation();

    public List<RestApplication> getRestApplications() {
        RestApplicationModel applicationModel = this.getRestApplicationsModel();
        if (applicationModel != null) {
            try {
                return (List)applicationModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestApplications, List<RestApplication>>(){

                    public List<RestApplication> run(RestApplications metadata) throws IOException {
                        return metadata.getRestApplications();
                    }
                });
            }
            catch (IOException ex) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public boolean hasJerseyServlet() {
        return WebXmlUpdater.hasRestServletAdaptor(this.webXmlUpdater.findWebApp());
    }

    protected void addJerseySpringJar() throws IOException {
        File[] jerseyJars;
        File jerseyRoot;
        ClassPath cp;
        FileObject srcRoot = MiscUtilities.findSourceRoot(this.getProject());
        if (srcRoot != null && ((cp = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/compile")) == null || cp.findResource("com/sun/jersey/api/spring/Autowire.class") == null) && (jerseyRoot = InstalledFileLocator.getDefault().locate(JERSEY_API_LOCATION, null, false)) != null && jerseyRoot.isDirectory() && (jerseyJars = jerseyRoot.listFiles(new MiscPrivateUtilities.JerseyFilter(JERSEY_SPRING_JAR_PATTERN))) != null && jerseyJars.length > 0) {
            URL url = FileUtil.getArchiveRoot((URL)jerseyJars[0].toURI().toURL());
            ProjectClassPathModifier.addRoots((URL[])new URL[]{url}, (FileObject)srcRoot, (String)"classpath/compile");
        }
    }

    public int getProjectType() {
        return 1;
    }

    public static enum RestConfig {
        IDE,
        USER,
        DD;

        private String appClassName;

        public void setAppClassName(String appClassName) {
            this.appClassName = appClassName;
        }

        public String getAppClassName() {
            return this.appClassName;
        }
    }
}

