/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.awt.NotificationDisplayer;

class CategoryFilter {
    private final Set<String> enabledCategories = new HashSet<String>();

    public CategoryFilter() {
        this.addDefaultTypes();
    }

    private CategoryFilter(CategoryFilter src) {
        this.enabledCategories.addAll(src.enabledCategories);
    }

    public boolean isEnabled(String category) {
        return this.enabledCategories.contains(category);
    }

    public void setEnabled(String category, boolean enabled) {
        if (enabled) {
            this.enabledCategories.add(category);
        } else {
            this.enabledCategories.remove(category);
        }
    }

    public CategoryFilter clone() {
        return new CategoryFilter(this);
    }

    void clear() {
        this.enabledCategories.clear();
    }

    void load(Preferences prefs, String prefix) throws BackingStoreException {
        this.enabledCategories.clear();
        String enabled = prefs.get(prefix + "_enabled", "");
        if (enabled.trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(enabled, "\n");
            while (tokenizer.hasMoreTokens()) {
                this.enabledCategories.add(tokenizer.nextToken());
            }
        } else {
            this.addDefaultTypes();
        }
    }

    void save(Preferences prefs, String prefix) throws BackingStoreException {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> type = this.enabledCategories.iterator();
        while (type.hasNext()) {
            buffer.append(type.next());
            if (!type.hasNext()) continue;
            buffer.append("\n");
        }
        prefs.put(prefix + "_enabled", buffer.toString());
    }

    private void addDefaultTypes() {
        for (NotificationDisplayer.Category category : NotificationDisplayer.Category.getCategories()) {
            this.enabledCategories.add(category.getName());
        }
    }
}

