/*
 * Decompiled with CFR 0.152.
 */
package io.foojay.api.discoclient.pkg;

import io.foojay.api.discoclient.pkg.ApiFeature;
import java.util.Arrays;
import java.util.List;

public enum PackageType implements ApiFeature
{
    JDK("JDK", "jdk"),
    JRE("JRE", "jre"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private PackageType(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public PackageType getDefault() {
        return NONE;
    }

    @Override
    public PackageType getNotFound() {
        return NOT_FOUND;
    }

    public PackageType[] getAll() {
        return PackageType.values();
    }

    public static PackageType fromText(String text) {
        switch (text) {
            case "-jdk": 
            case "JDK": 
            case "jdk": 
            case "jdk+fx": 
            case "JDK+FX": {
                return JDK;
            }
            case "-jre": 
            case "JRE": 
            case "jre": 
            case "jre+fx": 
            case "JRE+FX": {
                return JRE;
            }
        }
        return NOT_FOUND;
    }

    public static List<PackageType> getAsList() {
        return Arrays.asList(PackageType.values());
    }
}

