/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import java.io.Serializable;
import java.util.Collection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Slot;

public class AssociationImpl
extends RegistryObjectImpl
implements Association,
Serializable {
    boolean isExtramural = false;
    boolean isConfirmedBySourceOwner = false;
    boolean isConfirmedByTargetOwner = false;
    private RegistryObject sourceObject;
    private RegistryObject targetObject;
    private Concept associationType;
    private boolean keyFieldsSet = false;
    private boolean keyGenerated = false;

    public AssociationImpl() {
    }

    public AssociationImpl(RegistryObject targetObject, Concept associationType) throws JAXRException {
        this.targetObject = targetObject;
        this.associationType = associationType;
    }

    public boolean isConfirmedBySourceOwner() throws JAXRException {
        return this.isConfirmedBySourceOwner;
    }

    public boolean isConfirmedByTargetOwner() throws JAXRException {
        return this.isConfirmedByTargetOwner;
    }

    public void setIsConfirmedBySourceOwner(boolean confirmation) throws JAXRException {
        this.isConfirmedBySourceOwner = confirmation;
    }

    public void setIsConfirmedByTargetOwner(boolean confirmation) throws JAXRException {
        this.isConfirmedByTargetOwner = confirmation;
    }

    public boolean isConfirmed() throws JAXRException {
        return this.isConfirmedBySourceOwner && this.isConfirmedByTargetOwner;
    }

    public RegistryObject getSourceObject() throws JAXRException {
        return this.sourceObject;
    }

    public void setSourceObject(RegistryObject srcObject) throws JAXRException {
        this.sourceObject = srcObject;
        this.checkObjects();
        if (this.areKeyFieldsSet()) {
            this.keyGenerated = false;
            this.createKey();
        }
    }

    public RegistryObject getTargetObject() throws JAXRException {
        return this.targetObject;
    }

    public void setTargetObject(RegistryObject targetObject) throws JAXRException {
        this.targetObject = targetObject;
        this.checkObjects();
        if (this.areKeyFieldsSet()) {
            this.keyGenerated = false;
            this.createKey();
        }
    }

    public Concept getAssociationType() throws JAXRException {
        return this.associationType;
    }

    public void setAssociationType(Concept associationType) throws JAXRException {
        this.associationType = associationType;
        if (this.areKeyFieldsSet()) {
            this.keyGenerated = false;
            this.createKey();
        }
    }

    public boolean isExtramural() throws JAXRException {
        return this.checkExtramural();
    }

    public void setIsExtramural(boolean extramural) throws JAXRException {
        this.isExtramural = extramural;
    }

    public void createKey() throws JAXRException {
        if (!this.keyGenerated && this.keyFieldsSet) {
            String sourceKey = this.sourceObject.getKey().getId();
            String targetKey = this.targetObject.getKey().getId();
            String associationTypeValue = this.associationType.getValue();
            StringBuffer keyBuf = new StringBuffer(400);
            keyBuf.append(sourceKey);
            keyBuf.append(":");
            keyBuf.append(targetKey);
            keyBuf.append(":");
            keyBuf.append(associationTypeValue);
            this.key = new KeyImpl(keyBuf.toString());
            this.keyGenerated = true;
        }
    }

    boolean areKeyFieldsSet() throws JAXRException {
        if (this.sourceObject != null && this.targetObject != null && this.associationType != null) {
            Key sourceKey = this.sourceObject.getKey();
            Key targetKey = this.targetObject.getKey();
            String value = this.associationType.getValue();
            if (sourceKey != null && targetKey != null && value != null) {
                this.keyFieldsSet = true;
            }
        }
        return this.keyFieldsSet;
    }

    private void checkObjects() throws JAXRException {
        if (this.sourceObject == null || this.targetObject == null) {
            return;
        }
        Key sourceKey = this.sourceObject.getKey();
        Key targetKey = this.targetObject.getKey();
        if (sourceKey == null && targetKey == null) {
            this.isConfirmedBySourceOwner = true;
            this.isConfirmedByTargetOwner = true;
            this.isExtramural = this.isExtramural();
        }
    }

    private boolean checkExtramural() throws JAXRException {
        if (this.sourceObject != null && this.targetObject != null) {
            if (((RegistryObjectImpl)this.sourceObject).isLoaded() && ((RegistryObjectImpl)this.targetObject).isLoaded()) {
                Slot sourceAuthNameSlot = this.sourceObject.getSlot("authorizedName");
                Collection sourceValues = sourceAuthNameSlot.getValues();
                Slot targetAuthNameSlot = this.targetObject.getSlot("authorizedName");
                Collection targetValues = targetAuthNameSlot.getValues();
                if (!sourceValues.isEmpty() && !targetValues.isEmpty()) {
                    this.isExtramural = !sourceValues.iterator().next().equals(targetValues.iterator().next());
                    return this.isExtramural;
                }
            } else {
                if (((RegistryObjectImpl)this.sourceObject).isNew() || ((RegistryObjectImpl)this.targetObject).isNew()) {
                    return this.checkUserExtramural();
                }
                return this.checkUserExtramural();
            }
        }
        return this.isExtramural;
    }

    private boolean checkUserExtramural() throws JAXRException {
        if (this.sourceObject != null && this.targetObject != null) {
            String tString;
            RegistryServiceImpl sRS = (RegistryServiceImpl)this.sourceObject.getLifeCycleManager().getRegistryService();
            RegistryServiceImpl tRS = (RegistryServiceImpl)this.targetObject.getLifeCycleManager().getRegistryService();
            String sString = sRS.getCurrentUser();
            this.isExtramural = !sString.equals(tString = tRS.getCurrentUser());
        }
        return this.isExtramural;
    }
}

