/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.validation.XMLValidationSchema;

public abstract class XMLValidationSchemaFactory {
    public static final String INTERNAL_ID_SCHEMA_DTD = "dtd";
    public static final String INTERNAL_ID_SCHEMA_RELAXNG = "relaxng";
    public static final String INTERNAL_ID_SCHEMA_W3C = "w3c";
    public static final String INTERNAL_ID_SCHEMA_TREX = "trex";
    static final HashMap<String, String> sSchemaIds = new HashMap();
    static final String JAXP_PROP_FILENAME = "jaxp.properties";
    public static final String SYSTEM_PROPERTY_FOR_IMPL = "org.codehaus.stax2.validation.XMLValidationSchemaFactory.";
    public static final String SERVICE_DEFINITION_PATH = "META-INF/services/org.codehaus.stax2.validation.XMLValidationSchemaFactory.";
    public static final String P_IS_NAMESPACE_AWARE = "org.codehaus2.stax2.validation.isNamespaceAware";
    public static final String P_ENABLE_CACHING = "org.codehaus2.stax2.validation.enableCaching";
    protected final String mSchemaType;

    protected XMLValidationSchemaFactory(String string2) {
        this.mSchemaType = string2;
    }

    public static XMLValidationSchemaFactory newInstance(String string2) throws FactoryConfigurationError {
        return XMLValidationSchemaFactory.newInstance(string2, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLValidationSchemaFactory newInstance(String string2, ClassLoader classLoader) throws FactoryConfigurationError {
        Enumeration<URL> enumeration;
        String string3;
        SecurityException securityException;
        String string4;
        block19: {
            Object object;
            Serializable serializable;
            String string5;
            block18: {
                string5 = sSchemaIds.get(string2);
                if (string5 == null) {
                    throw new FactoryConfigurationError("Unrecognized schema type (id '" + string2 + "')");
                }
                string4 = SYSTEM_PROPERTY_FOR_IMPL + string5;
                securityException = null;
                try {
                    string3 = System.getProperty(string4);
                    if (string3 != null && string3.length() > 0) {
                        return XMLValidationSchemaFactory.createNewInstance(classLoader, string3);
                    }
                }
                catch (SecurityException securityException2) {
                    securityException = securityException2;
                }
                try {
                    string3 = System.getProperty("java.home");
                    enumeration = new File(string3);
                    enumeration = new File((File)((Object)enumeration), "lib");
                    enumeration = new File((File)((Object)enumeration), JAXP_PROP_FILENAME);
                    if (!((File)((Object)enumeration)).exists()) break block18;
                    try {
                        serializable = new Properties();
                        ((Properties)serializable).load(new FileInputStream((File)((Object)enumeration)));
                        object = ((Properties)serializable).getProperty(string4);
                        if (object != null && ((String)object).length() > 0) {
                            return XMLValidationSchemaFactory.createNewInstance(classLoader, (String)object);
                        }
                    }
                    catch (IOException iOException) {}
                }
                catch (SecurityException securityException3) {
                    securityException = securityException3;
                }
            }
            string3 = SERVICE_DEFINITION_PATH + string5;
            try {
                enumeration = classLoader == null ? ClassLoader.getSystemResources(string3) : classLoader.getResources(string3);
                if (enumeration == null) break block19;
                while (enumeration.hasMoreElements()) {
                    serializable = enumeration.nextElement();
                    object = ((URL)serializable).openStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "ISO-8859-1"));
                    String string6 = null;
                    try {
                        String string7;
                        while ((string7 = bufferedReader.readLine()) != null) {
                            if ((string7 = string7.trim()).length() <= 0 || string7.charAt(0) == '#') continue;
                            string6 = string7;
                            break;
                        }
                    }
                    finally {
                        bufferedReader.close();
                    }
                    if (string6 == null || string6.length() <= 0) continue;
                    return XMLValidationSchemaFactory.createNewInstance(classLoader, string6);
                }
            }
            catch (SecurityException securityException4) {
                securityException = securityException4;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        enumeration = "No XMLValidationSchemaFactory implementation class specified or accessible (via system property '" + string4 + "', or service definition under '" + string3 + "')";
        if (securityException != null) {
            throw new FactoryConfigurationError((String)((Object)enumeration) + " (possibly caused by: " + securityException + ")", securityException);
        }
        throw new FactoryConfigurationError((String)((Object)enumeration));
    }

    public XMLValidationSchema createSchema(InputStream inputStream) throws XMLStreamException {
        return this.createSchema(inputStream, null);
    }

    public XMLValidationSchema createSchema(InputStream inputStream, String string2) throws XMLStreamException {
        return this.createSchema(inputStream, string2, null, null);
    }

    public abstract XMLValidationSchema createSchema(InputStream var1, String var2, String var3, String var4) throws XMLStreamException;

    public XMLValidationSchema createSchema(Reader reader) throws XMLStreamException {
        return this.createSchema(reader, null, null);
    }

    public abstract XMLValidationSchema createSchema(Reader var1, String var2, String var3) throws XMLStreamException;

    public abstract XMLValidationSchema createSchema(URL var1) throws XMLStreamException;

    public abstract XMLValidationSchema createSchema(File var1) throws XMLStreamException;

    public abstract boolean isPropertySupported(String var1);

    public abstract boolean setProperty(String var1, Object var2);

    public abstract Object getProperty(String var1);

    public final String getSchemaType() {
        return this.mSchemaType;
    }

    private static XMLValidationSchemaFactory createNewInstance(ClassLoader classLoader, String string2) throws FactoryConfigurationError {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string2) : classLoader.loadClass(string2);
            return (XMLValidationSchemaFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryConfigurationError("XMLValidationSchemaFactory implementation '" + string2 + "' not found (missing jar in classpath?)", classNotFoundException);
        }
        catch (Exception exception) {
            throw new FactoryConfigurationError("XMLValidationSchemaFactory implementation '" + string2 + "' could not be instantiated: " + exception, exception);
        }
    }

    static {
        sSchemaIds.put("http://www.w3.org/XML/1998/namespace", INTERNAL_ID_SCHEMA_DTD);
        sSchemaIds.put("http://relaxng.org/ns/structure/0.9", INTERNAL_ID_SCHEMA_RELAXNG);
        sSchemaIds.put("http://www.w3.org/2001/XMLSchema", INTERNAL_ID_SCHEMA_W3C);
        sSchemaIds.put("http://www.thaiopensource.com/trex", INTERNAL_ID_SCHEMA_TREX);
    }
}

