/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.JsArray;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.spi.FunctionArgument;
import org.netbeans.modules.javascript2.model.spi.FunctionInterceptor;
import org.netbeans.modules.javascript2.model.spi.ModelElementFactory;
import org.netbeans.modules.javascript2.requirejs.editor.index.RequireJsIndexer;
import org.netbeans.modules.javascript2.types.api.DeclarationScope;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ConfigInterceptor
implements FunctionInterceptor {
    private static final Pattern PATTERN = Pattern.compile("(require|requirejs)\\.config");
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_LOCATION = "location";

    public Pattern getNamePattern() {
        return PATTERN;
    }

    public Collection<TypeUsage> intercept(Snapshot snapshot, String name, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (!RequireJsIndexer.Factory.isScannerThread()) {
            return Collections.emptyList();
        }
        FunctionArgument fArg = null;
        for (FunctionArgument farg : args) {
            if (farg.getKind() != FunctionArgument.Kind.ANONYMOUS_OBJECT) continue;
            fArg = farg;
            break;
        }
        if (fArg != null && fArg.getValue() instanceof JsObject) {
            JsObject paths = ((JsObject)fArg.getValue()).getProperty("paths");
            JsObject baseUrl = ((JsObject)fArg.getValue()).getProperty("baseUrl");
            JsObject packages = ((JsObject)fArg.getValue()).getProperty("packages");
            if (paths != null || baseUrl != null || packages != null) {
                Project project;
                Map<String, String> packagesMap;
                Token token;
                TokenSequence ts;
                FileObject fo = globalObject.getFileObject();
                if (fo == null) {
                    return Collections.emptyList();
                }
                Source source = Source.create((FileObject)fo);
                TokenHierarchy th = source.createSnapshot().getTokenHierarchy();
                if (paths != null) {
                    ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)paths.getOffset());
                    if (ts == null) {
                        return Collections.emptyList();
                    }
                    HashMap<String, String> mapping = new HashMap<String, String>();
                    for (JsObject path : paths.getProperties().values()) {
                        String alias = path.getName();
                        String target = null;
                        ts.move(path.getOffset());
                        if (ts.moveNext() && (token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.OPERATOR_COLON))).id() == JsTokenId.OPERATOR_COLON && (token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.OPERATOR_COLON))).id() == JsTokenId.STRING) {
                            target = token.text().toString();
                        }
                        if (target == null) continue;
                        mapping.put(alias, target);
                    }
                    if (!mapping.isEmpty()) {
                        RequireJsIndexer.addPathMapping(fo.toURI(), mapping);
                    }
                }
                if (baseUrl != null) {
                    ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)baseUrl.getOffset());
                    if (ts == null) {
                        return Collections.emptyList();
                    }
                    ts.move(baseUrl.getOffset());
                    String target = null;
                    if (ts.moveNext() && (token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.OPERATOR_COLON))).id() == JsTokenId.OPERATOR_COLON && (token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.OPERATOR_COLON))).id() == JsTokenId.STRING) {
                        target = token.text().toString();
                    }
                    if (target != null) {
                        RequireJsIndexer.addBasePath(fo.toURI(), target);
                    }
                }
                if (packages != null && packages instanceof JsArray && (packagesMap = this.loadPackages(th, packages.getOffset())) != null) {
                    RequireJsIndexer.addPackages(fo.toURI(), packagesMap);
                }
                if ((project = FileOwnerQuery.getOwner((FileObject)fo)) != null) {
                    for (FileObject dir : project.getProjectDirectory().getChildren()) {
                        if (!dir.isFolder() || !FileUtil.isParentOf((FileObject)dir, (FileObject)fo)) continue;
                        RequireJsIndexer.addSourceRoot(fo.toURI(), dir.getName());
                        break;
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    private Map<String, String> loadPackages(TokenHierarchy<?> th, int offset) {
        HashMap<String, String> packagesMap = new HashMap<String, String>();
        TokenSequence ts = LexUtilities.getJsTokenSequence(th, (int)offset);
        if (ts != null) {
            ts.move(offset);
            if (ts.moveNext()) {
                Token token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.BRACKET_LEFT_BRACKET));
                while (token != null && token.id() != JsTokenId.BRACKET_RIGHT_BRACKET) {
                    token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_RIGHT_BRACKET));
                    if (token.id() == JsTokenId.BRACKET_LEFT_CURLY) {
                        String packageName = null;
                        String packageLocation = null;
                        while (token != null && token.id() != JsTokenId.BRACKET_RIGHT_CURLY) {
                            token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER, JsTokenId.BRACKET_RIGHT_CURLY));
                            if (token.text().equals(PROPERTY_NAME)) {
                                ts.moveNext();
                                token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.OPERATOR_COLON, JsTokenId.WHITESPACE, JsTokenId.STRING_BEGIN));
                                packageName = token != null && token.id() == JsTokenId.STRING ? token.text().toString() : null;
                                continue;
                            }
                            if (token.text().equals(PROPERTY_LOCATION)) {
                                ts.moveNext();
                                token = LexUtilities.findNext((TokenSequence)ts, Arrays.asList(JsTokenId.OPERATOR_COLON, JsTokenId.WHITESPACE, JsTokenId.STRING_BEGIN));
                                packageLocation = token != null && token.id() == JsTokenId.STRING ? token.text().toString() : null;
                                continue;
                            }
                            ts.moveNext();
                        }
                        if (packageName == null || packageName.isEmpty() || packageLocation == null || packageLocation.isEmpty()) continue;
                        packagesMap.put(packageName, packageLocation);
                        continue;
                    }
                    if (!ts.moveNext()) break;
                    token = ts.token();
                }
            }
        }
        return packagesMap;
    }
}

