/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.awt.Font;
import java.beans.PropertyVetoException;
import java.io.InvalidObjectException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ArrayTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalArgumentExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ShortenedStrings;
import org.netbeans.modules.debugger.jpda.util.JPDAUtils;
import org.openide.util.NbBundle;
import sun.reflect.ReflectionFactory;

public class VariableMirrorTranslator {
    private static final Logger logger = Logger.getLogger(VariableMirrorTranslator.class.getName());
    private static final Object NO_MIRROR = new String("NO_MIRROR");

    private VariableMirrorTranslator() {
    }

    static Object createMirrorObject(Value value) {
        return VariableMirrorTranslator.createMirrorObject(value, new HashMap<Value, Object>());
    }

    private static Object createMirrorObject(Value value, Map<Value, Object> mirrorsMap) {
        block19: {
            try {
                String typeStr;
                Type type = ValueWrapper.type(value);
                if (type instanceof ArrayType) {
                    typeStr = TypeWrapper.signature(type);
                    typeStr = typeStr.replace('/', '.');
                } else {
                    typeStr = TypeWrapper.name(type);
                }
                if (value instanceof ObjectReference && type instanceof ReferenceType) {
                    try {
                        Class<?> clazz = Class.forName(typeStr);
                        if (String.class.equals(clazz)) {
                            return ShortenedStrings.getStringWithLengthControl((StringReference)value);
                        }
                        return VariableMirrorTranslator.createMirrorObject((ObjectReference)value, (ReferenceType)type, clazz, mirrorsMap);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        break block19;
                    }
                    catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                        break block19;
                    }
                }
                if ("boolean".equals(typeStr)) {
                    return ((BooleanValue)value).booleanValue();
                }
                if ("byte".equals(typeStr)) {
                    return new Byte(((ByteValue)value).byteValue());
                }
                if ("char".equals(typeStr)) {
                    return new Character(((CharValue)value).charValue());
                }
                if ("short".equals(typeStr)) {
                    return new Short(((ShortValue)value).shortValue());
                }
                if ("int".equals(typeStr)) {
                    return new Integer(((IntegerValue)value).intValue());
                }
                if ("long".equals(typeStr)) {
                    return new Long(((LongValue)value).longValue());
                }
                if ("float".equals(typeStr)) {
                    return new Float(((FloatValue)value).floatValue());
                }
                if ("double".equals(typeStr)) {
                    return new Double(((DoubleValue)value).doubleValue());
                }
                throw new IllegalArgumentException("Unknown primitive type: " + typeStr + " from " + type);
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                // empty catch block
            }
        }
        return null;
    }

    private static Object createPristineInstanceOf(Class clazz) {
        try {
            Constructor<Object> constructor;
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException nsmex) {
                ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
                constructor = rf.newConstructorForSerialization(clazz, Object.class.getDeclaredConstructor(new Class[0]));
            }
            Object newInstance = constructor.newInstance(new Object[0]);
            return newInstance;
        }
        catch (InstantiationException ex) {
            logger.log(Level.INFO, "Problem while creating a pristine instance of " + clazz, ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.INFO, "Problem while creating a pristine instance of " + clazz, ex);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.INFO, "Problem while creating a pristine instance of " + clazz, ex);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.INFO, "Problem while creating a pristine instance of " + clazz, ex);
        }
        catch (NoSuchMethodException ex) {
            logger.log(Level.INFO, "Problem while creating a pristine instance of " + clazz, ex);
        }
        catch (SecurityException ex) {
            logger.log(Level.INFO, "Problem while creating a pristine instance of " + clazz, ex);
        }
        return null;
    }

    private static Field getDeclaredOrInheritedField(Class clazz, String name) throws SecurityException {
        try {
            Field field = clazz.getDeclaredField(name);
            return field;
        }
        catch (NoSuchFieldException field) {
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return VariableMirrorTranslator.getDeclaredOrInheritedField(superClass, name);
            }
            return null;
        }
    }

    private static Object createMirrorObject(ObjectReference value, ReferenceType type, Class clazz, Map<Value, Object> mirrorsMap) throws ClassNotPreparedExceptionWrapper, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        logger.log(Level.FINE, "createMirrorObject({0}, {1}, {2})", new Object[]{value, type, clazz});
        if (clazz.isArray() && value instanceof ArrayReference) {
            ArrayReference arrayRef = (ArrayReference)value;
            int l = ArrayReferenceWrapper.length(arrayRef);
            Object array = Array.newInstance(clazz.getComponentType(), l);
            List<Value> values = ArrayReferenceWrapper.getValues(arrayRef);
            for (int i = 0; i < l; ++i) {
                Object element;
                Value v = values.get(i);
                if (v == null) {
                    element = null;
                } else {
                    element = mirrorsMap.get(v);
                    if (element == null) {
                        element = VariableMirrorTranslator.createMirrorObject(v, mirrorsMap);
                    }
                    if (element == null) {
                        return null;
                    }
                }
                Array.set(array, i, element);
            }
            logger.log(Level.FINE, "  return {0}", array);
            return array;
        }
        if (clazz.equals(Class.class)) {
            return null;
        }
        Object newInstance = VariableMirrorTranslator.createSpecialized(value, type, clazz, mirrorsMap);
        if (newInstance != null) {
            if (NO_MIRROR == newInstance) {
                return null;
            }
            mirrorsMap.put(value, newInstance);
            return newInstance;
        }
        newInstance = VariableMirrorTranslator.createPristineInstanceOf(clazz);
        if (newInstance == null) {
            return null;
        }
        mirrorsMap.put(value, newInstance);
        List<com.sun.jdi.Field> fields = ReferenceTypeWrapper.allFields0(type);
        ArrayList<com.sun.jdi.Field> fieldsToAskFor = new ArrayList<com.sun.jdi.Field>();
        for (com.sun.jdi.Field f : fields) {
            if (f.isStatic()) continue;
            fieldsToAskFor.add(f);
        }
        Map<com.sun.jdi.Field, Value> fieldValues = ObjectReferenceWrapper.getValues(value, fieldsToAskFor);
        newInstance = VariableMirrorTranslator.setFieldsValues(newInstance, clazz, fieldValues, mirrorsMap);
        logger.log(Level.FINE, "  return {0}", newInstance);
        return newInstance;
    }

    private static Object setFieldsValues(Object newInstance, Class clazz, Map<com.sun.jdi.Field, Value> fieldValues, Map<Value, Object> mirrorsMap) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        for (com.sun.jdi.Field f : fieldValues.keySet()) {
            String name = TypeComponentWrapper.name(f);
            Field field = VariableMirrorTranslator.getDeclaredOrInheritedField(clazz, name);
            if (field == null) {
                logger.log(Level.CONFIG, "No Such Field({0}) of class {1}", new Object[]{name, clazz});
                return null;
            }
            field.setAccessible(true);
            Value v = fieldValues.get(f);
            try {
                if (v == null) {
                    field.set(newInstance, null);
                    continue;
                }
                Object mv = mirrorsMap.get(v);
                if (mv == null) {
                    mv = VariableMirrorTranslator.createMirrorObject(v, mirrorsMap);
                }
                if (mv != null) {
                    field.set(newInstance, mv);
                    continue;
                }
                logger.log(Level.CONFIG, "Unable to translate field {0} of class {1}", new Object[]{name, clazz});
                return null;
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.CONFIG, "IllegalAccessException({0}) of field {1}", new Object[]{ex.getLocalizedMessage(), field});
                return null;
            }
        }
        return newInstance;
    }

    private static Object createSpecialized(ObjectReference value, ReferenceType type, Class clazz, Map<Value, Object> mirrorsMap) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        if (Font.class.isAssignableFrom(clazz)) {
            Map<com.sun.jdi.Field, Value> fieldValues = VariableMirrorTranslator.getFieldValues(value, type, "values", "name", "size", "pointSize", "style");
            if (fieldValues == null) {
                return NO_MIRROR;
            }
            Object fontInstance = VariableMirrorTranslator.createPristineInstanceOf(Font.class);
            if (fontInstance == null) {
                return NO_MIRROR;
            }
            mirrorsMap.put(value, fontInstance);
            fontInstance = VariableMirrorTranslator.setFieldsValues(fontInstance, Font.class, fieldValues, mirrorsMap);
            if (fontInstance == null) {
                return NO_MIRROR;
            }
            return fontInstance;
        }
        if (URL.class.isAssignableFrom(clazz)) {
            Map<com.sun.jdi.Field, Value> fieldValues = VariableMirrorTranslator.getFieldValues(value, type, "handler");
            if (fieldValues == null) {
                return NO_MIRROR;
            }
            for (Value v : fieldValues.values()) {
                if (v != null) continue;
                return NO_MIRROR;
            }
            return null;
        }
        return null;
    }

    private static Map<com.sun.jdi.Field, Value> getFieldValues(ObjectReference value, ReferenceType type, String ... names) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        int n = names.length;
        ArrayList<com.sun.jdi.Field> fieldsToAskFor = new ArrayList<com.sun.jdi.Field>(n);
        for (String name : names) {
            com.sun.jdi.Field field = ReferenceTypeWrapper.fieldByName(type, name);
            if (field == null) {
                return null;
            }
            fieldsToAskFor.add(field);
        }
        Map<com.sun.jdi.Field, Value> fieldValues = ObjectReferenceWrapper.getValues(value, fieldsToAskFor);
        return fieldValues;
    }

    private static boolean willInvokeMethods(boolean isObject, Class clazz) {
        return isObject && !clazz.isPrimitive() && !String.class.equals((Object)clazz);
    }

    public static Value createValueFromMirror(Object mirror, boolean isObject, JPDADebuggerImpl debugger) throws InvalidObjectException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, InvalidTypeException, ClassNotLoadedException, ClassNotPreparedExceptionWrapper, IllegalArgumentExceptionWrapper {
        Lock lock;
        JPDAThreadImpl currentThread;
        VirtualMachine vm = debugger.getVirtualMachine();
        if (vm == null) {
            throw new VMDisconnectedExceptionWrapper(new VMDisconnectedException());
        }
        Class<?> clazz = mirror.getClass();
        if (VariableMirrorTranslator.willInvokeMethods(isObject, clazz)) {
            currentThread = (JPDAThreadImpl)debugger.getCurrentThread();
            if (currentThread == null) {
                throw new InvalidObjectException(NbBundle.getMessage(JPDADebuggerImpl.class, (String)"MSG_NoCurrentContext"));
            }
            lock = currentThread.accessLock.writeLock();
            lock.lock();
        } else {
            currentThread = null;
            lock = null;
        }
        boolean invoking = false;
        try {
            ThreadReference threadReference;
            if (currentThread != null) {
                threadReference = currentThread.getThreadReference();
                currentThread.notifyMethodInvoking();
                invoking = true;
            } else {
                threadReference = null;
            }
            Value value = VariableMirrorTranslator.createValueFromMirror(mirror, clazz, isObject, vm, threadReference);
            return value;
        }
        catch (IncompatibleThreadStateException ex) {
            InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (UnsupportedOperationExceptionWrapper ex) {
            InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
            ioex.initCause(ex);
            throw ioex;
        }
        catch (PropertyVetoException pvex) {
            InvalidObjectException ioex = new InvalidObjectException(pvex.getLocalizedMessage());
            ioex.initCause(pvex);
            throw ioex;
        }
        finally {
            if (invoking) {
                currentThread.notifyMethodInvokeDone();
            }
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private static Value createValueFromMirror(Object mirror, Class clazz, boolean isObject, VirtualMachine vm, ThreadReference thread) throws InvalidObjectException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, InvalidTypeException, ClassNotLoadedException, ClassNotPreparedExceptionWrapper, IllegalArgumentExceptionWrapper, IncompatibleThreadStateException, UnsupportedOperationExceptionWrapper {
        boolean isPrimitive = clazz.isPrimitive();
        if (!isObject || isPrimitive) {
            if (Boolean.TYPE.equals(clazz) || Boolean.class.equals((Object)clazz)) {
                return vm.mirrorOf((Boolean)mirror);
            }
            if (Byte.TYPE.equals(clazz) || Byte.class.equals((Object)clazz)) {
                return vm.mirrorOf((Byte)mirror);
            }
            if (Character.TYPE.equals(clazz) || Character.class.equals((Object)clazz)) {
                return vm.mirrorOf(((Character)mirror).charValue());
            }
            if (Short.TYPE.equals(clazz) || Short.class.equals((Object)clazz)) {
                return vm.mirrorOf((Short)mirror);
            }
            if (Integer.TYPE.equals(clazz) || Integer.class.equals((Object)clazz)) {
                return vm.mirrorOf((Integer)mirror);
            }
            if (Long.TYPE.equals(clazz) || Long.class.equals((Object)clazz)) {
                return vm.mirrorOf((Long)mirror);
            }
            if (Float.TYPE.equals(clazz) || Float.class.equals((Object)clazz)) {
                return vm.mirrorOf(((Float)mirror).floatValue());
            }
            if (Double.TYPE.equals(clazz) || Double.class.equals((Object)clazz)) {
                return vm.mirrorOf((Double)mirror);
            }
            throw new InvalidObjectException("Unknown primitive type " + clazz);
        }
        if (String.class.equals((Object)clazz)) {
            return vm.mirrorOf((String)mirror);
        }
        if (clazz.isArray()) {
            int l = Array.getLength(mirror);
            String typeName = clazz.getCanonicalName();
            ArrayType arrayType = (ArrayType)VariableMirrorTranslator.getOrLoadClass(vm, typeName);
            if (arrayType == null) {
                throw new InvalidObjectException("Unknown class " + typeName);
            }
            ArrayReference array = ArrayTypeWrapper.newInstance(arrayType, l);
            for (int i = 0; i < l; ++i) {
                Object element = Array.get(mirror, i);
                if (element == null) continue;
                Value v = VariableMirrorTranslator.createValueFromMirror(element, clazz.getComponentType(), true, vm, thread);
                ArrayReferenceWrapper.setValue(array, i, v);
            }
            return array;
        }
        String typeName = clazz.getName();
        ReferenceType type = VariableMirrorTranslator.getOrLoadClass(vm, typeName);
        if (type instanceof ClassType) {
            ObjectReference obj;
            try {
                obj = VariableMirrorTranslator.createObjectOfType((ClassType)type, vm, thread);
            }
            catch (InvocationException ex) {
                InvalidObjectException ioex = new InvalidObjectException(ex.getLocalizedMessage());
                ioex.initCause(ex);
                throw ioex;
            }
            List<com.sun.jdi.Field> fields = ReferenceTypeWrapper.allFields0(type);
            ArrayList<com.sun.jdi.Field> fieldsToSet = new ArrayList<com.sun.jdi.Field>();
            for (com.sun.jdi.Field f : fields) {
                if (f.isStatic()) continue;
                fieldsToSet.add(f);
            }
            for (com.sun.jdi.Field f : fieldsToSet) {
                Class<?> fieldType;
                Object fm;
                String name = TypeComponentWrapper.name(f);
                try {
                    Field field = VariableMirrorTranslator.getDeclaredOrInheritedField(clazz, name);
                    if (field == null) {
                        InvalidObjectException ioex = new InvalidObjectException("No field " + name + " of class " + clazz);
                        throw ioex;
                    }
                    field.setAccessible(true);
                    fm = field.get(mirror);
                    fieldType = field.getType();
                }
                catch (SecurityException seex) {
                    InvalidObjectException ioex = new InvalidObjectException("Retrieving field " + name + " of class " + clazz);
                    ioex.initCause(seex);
                    throw ioex;
                }
                catch (IllegalAccessException iaex) {
                    InvalidObjectException ioex = new InvalidObjectException("Illegal access to field " + name + " of class " + clazz);
                    ioex.initCause(iaex);
                    throw ioex;
                }
                catch (IllegalArgumentException iaex) {
                    InvalidObjectException ioex = new InvalidObjectException("Illegal argument to field " + name + " of class " + clazz);
                    ioex.initCause(iaex);
                    throw ioex;
                }
                Value fv = fm == null ? null : (fieldType.isPrimitive() ? VariableMirrorTranslator.createValueFromMirror(fm, fieldType, true, vm, thread) : VariableMirrorTranslator.createValueFromMirror(fm, fm.getClass(), true, vm, thread));
                if (!f.isFinal()) {
                    ObjectReferenceWrapper.setValue(obj, f, fv);
                    continue;
                }
                VariableMirrorTranslator.setValueToFinalField(obj, name, (ClassType)type, fv, vm, thread);
            }
            return obj;
        }
        throw new InvalidObjectException("Type " + typeName + " (" + type + ") is not a class type.");
    }

    private static ReferenceType getOrLoadClass(VirtualMachine vm, String name) {
        List<ReferenceType> types = vm.classesByName(name);
        if (types.size() > 0) {
            if (types.size() == 1) {
                return types.get(0);
            }
            try {
                ReferenceType preferedType = JPDAUtils.getPreferredReferenceType(types, null);
                if (preferedType != null) {
                    return preferedType;
                }
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                throw ex.getCause();
            }
            return types.get(0);
        }
        return null;
    }

    private static ObjectReference createObjectOfType(ClassType type, VirtualMachine vm, ThreadReference thread) throws InvalidObjectException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper, ObjectCollectedExceptionWrapper, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, UnsupportedOperationExceptionWrapper {
        Method c = ClassTypeWrapper.concreteMethodByName(type, "<init>", "()V");
        if (c == null || !c.declaringType().equals(type)) {
            ClassType reflectionFactoryType = (ClassType)VariableMirrorTranslator.getOrLoadClass(vm, "sun.reflect.ReflectionFactory");
            if (reflectionFactoryType == null) {
                throw new InvalidObjectException("No constructor for " + TypeWrapper.name(type));
            }
            Method getReflectionFactoryMethod = ClassTypeWrapper.concreteMethodByName(reflectionFactoryType, "getReflectionFactory", "()Lsun/reflect/ReflectionFactory;");
            if (getReflectionFactoryMethod == null) {
                throw new InvalidObjectException("Reflection Factory getter not found.");
            }
            ClassType objectClassType = (ClassType)VariableMirrorTranslator.getOrLoadClass(vm, "java.lang.Object");
            if (objectClassType == null) {
                throw new InvalidObjectException("No Object class found in the target VM.");
            }
            ClassObjectReference objectClass = ReferenceTypeWrapper.classObject(objectClassType);
            Method getDeclaredConstructorMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ObjectReferenceWrapper.referenceType(objectClass), "getDeclaredConstructor", "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
            if (getDeclaredConstructorMethod == null) {
                throw new InvalidObjectException("getDeclaredConstructor() method not found on Object class. Can not create a new instance.");
            }
            Method newConstructorForSerializationMethod = ClassTypeWrapper.concreteMethodByName(reflectionFactoryType, "newConstructorForSerialization", "(Ljava/lang/Class;Ljava/lang/reflect/Constructor;)Ljava/lang/reflect/Constructor;");
            if (newConstructorForSerializationMethod == null) {
                throw new InvalidObjectException("newConstructorForSerialization() method not found on Object class. Can not create a new instance.");
            }
            ObjectReference objectConstructor = (ObjectReference)ObjectReferenceWrapper.invokeMethod(objectClass, thread, getDeclaredConstructorMethod, Collections.emptyList(), 1);
            ObjectReference rf = (ObjectReference)ClassTypeWrapper.invokeMethod(reflectionFactoryType, thread, getReflectionFactoryMethod, Collections.emptyList(), 1);
            ObjectReference constructor = (ObjectReference)ObjectReferenceWrapper.invokeMethod(rf, thread, newConstructorForSerializationMethod, Arrays.asList(ReferenceTypeWrapper.classObject(type), objectConstructor), 1);
            Method newInstanceMethod = ClassTypeWrapper.concreteMethodByName((ClassType)ObjectReferenceWrapper.referenceType(constructor), "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;");
            if (newInstanceMethod == null) {
                throw new InvalidObjectException("newInstance() method not found on Constructor class. Can not create a new instance.");
            }
            ObjectReference newInstance = (ObjectReference)ObjectReferenceWrapper.invokeMethod(constructor, thread, newInstanceMethod, Collections.emptyList(), 1);
            return newInstance;
        }
        return ClassTypeWrapper.newInstance(type, thread, c, Collections.emptyList(), 1);
    }

    private static void setValueToFinalField(ObjectReference obj, String name, ClassType clazz, Value fv, VirtualMachine vm, ThreadReference thread) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper, ClassNotLoadedException, ObjectCollectedExceptionWrapper, IncompatibleThreadStateException, UnsupportedOperationExceptionWrapper, InvalidTypeException, InvalidObjectException {
        ObjectReference fieldRef = VariableMirrorTranslator.getDeclaredOrInheritedField(clazz, name, vm, thread);
        if (fieldRef == null) {
            InvalidObjectException ioex = new InvalidObjectException("No field " + name + " of class " + clazz);
            throw ioex;
        }
        ClassType fieldClassType = (ClassType)ValueWrapper.type(fieldRef);
        Method setAccessibleMethod = ClassTypeWrapper.concreteMethodByName(fieldClassType, "setAccessible", "(Z)V");
        try {
            ObjectReferenceWrapper.invokeMethod(fieldRef, thread, setAccessibleMethod, Collections.singletonList(vm.mirrorOf(true)), 1);
            Method setMethod = ClassTypeWrapper.concreteMethodByName(fieldClassType, "set", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            if (fv instanceof PrimitiveValue) {
                PrimitiveType pt = (PrimitiveType)ValueWrapper.type(fv);
                ReferenceType fieldBoxingClass = EvaluatorVisitor.adjustBoxingType(clazz, pt, null);
                fv = EvaluatorVisitor.box((PrimitiveValue)fv, fieldBoxingClass, thread, null);
            }
            List<Value> args = Arrays.asList(obj, fv);
            ObjectReferenceWrapper.invokeMethod(fieldRef, thread, setMethod, args, 1);
        }
        catch (InvocationException iex) {
            throw new InvalidObjectException("Problem setting value " + fv + " to field " + name + " of class " + clazz + " : " + iex.exception());
        }
    }

    private static Type boxType(Type t) {
        if (t instanceof ClassType) {
            String name = ((ClassType)t).name();
            if (name.equals("java.lang.Boolean")) {
                t = t.virtualMachine().mirrorOf(true).type();
            } else if (name.equals("java.lang.Byte")) {
                t = t.virtualMachine().mirrorOf((byte)10).type();
            } else if (name.equals("java.lang.Character")) {
                t = t.virtualMachine().mirrorOf('a').type();
            } else if (name.equals("java.lang.Integer")) {
                t = t.virtualMachine().mirrorOf(10).type();
            } else if (name.equals("java.lang.Long")) {
                t = t.virtualMachine().mirrorOf(10L).type();
            } else if (name.equals("java.lang.Short")) {
                t = t.virtualMachine().mirrorOf((short)10).type();
            } else if (name.equals("java.lang.Float")) {
                t = t.virtualMachine().mirrorOf(10.0f).type();
            } else if (name.equals("java.lang.Double")) {
                t = t.virtualMachine().mirrorOf(10.0).type();
            }
        }
        return t;
    }

    private static ObjectReference getDeclaredOrInheritedField(ClassType clazz, String name, VirtualMachine vm, ThreadReference thread) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper, ClassNotLoadedException, ObjectCollectedExceptionWrapper, IncompatibleThreadStateException, UnsupportedOperationExceptionWrapper, InvalidTypeException {
        ClassType classType = (ClassType)VariableMirrorTranslator.getOrLoadClass(vm, "java.lang.Class");
        Method getDeclaredFieldMethod = ClassTypeWrapper.concreteMethodByName(classType, "getDeclaredField", "(Ljava/lang/String;)Ljava/lang/reflect/Field;");
        try {
            ObjectReference fieldRef = (ObjectReference)ObjectReferenceWrapper.invokeMethod(ReferenceTypeWrapper.classObject(clazz), thread, getDeclaredFieldMethod, Collections.singletonList(vm.mirrorOf(name)), 1);
            return fieldRef;
        }
        catch (InvocationException fieldRef) {
            ClassType superClass = ClassTypeWrapper.superclass(clazz);
            if (superClass != null) {
                return VariableMirrorTranslator.getDeclaredOrInheritedField(superClass, name, vm, thread);
            }
            return null;
        }
    }
}

