/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.runjar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.netbeans.api.extexecution.base.ExplicitProcessParameters;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.runjar.MavenExecuteUtils;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class LaunchArgPrereqsChecker
implements LateBoundPrerequisitesChecker {
    @Override
    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        StartupExtender.StartMode mode;
        String actionName = config.getActionName();
        if ("run".equals(actionName) || "run.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.NORMAL;
        } else if ("debug".equals(actionName) || "debug.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.DEBUG;
        } else if ("profile".equals(actionName) || "profile.single".equals(actionName) || "profile.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.PROFILE;
        } else if ("profile.test.single".equals(actionName)) {
            mode = StartupExtender.StartMode.TEST_PROFILE;
        } else {
            return true;
        }
        Map<? extends String, ? extends String> props = config.getProperties();
        if ("true".equals(props.get("NbIde.ExplicitParametersApplied"))) {
            return true;
        }
        boolean vmArgsPresent = props.containsKey("exec.vmArgs");
        boolean appArgsPresent = props.containsKey("exec.appArgs");
        boolean execArgsPresent = props.containsKey("exec.args");
        ArrayList fixedArgs = new ArrayList();
        if (execArgsPresent || vmArgsPresent || appArgsPresent) {
            InstanceContent ic = new InstanceContent();
            Project p = config.getProject();
            if (p != null) {
                ic.add((Object)p);
                ActiveJ2SEPlatformProvider pp = (ActiveJ2SEPlatformProvider)p.getLookup().lookup(ActiveJ2SEPlatformProvider.class);
                if (pp != null) {
                    ic.add((Object)pp.getJavaPlatform());
                }
            }
            for (StartupExtender group : StartupExtender.getExtenders((Lookup)new AbstractLookup((AbstractLookup.Content)ic), (StartupExtender.StartMode)mode)) {
                fixedArgs.addAll(group.getRawArguments());
            }
        }
        ExplicitProcessParameters changedParams = null;
        ArrayList<String> vmArgsValue = new ArrayList<String>(Arrays.asList(MavenExecuteUtils.splitCommandLine(props.get("exec.vmArgs"))));
        ArrayList<String> appArgsValue = new ArrayList<String>(Arrays.asList(MavenExecuteUtils.splitCommandLine(props.get("exec.appArgs"))));
        ExplicitProcessParameters injectParams = ExplicitProcessParameters.buildExplicitParameters((Lookup)config.getActionContext());
        ArrayList<String> vmArgs = new ArrayList<String>(fixedArgs);
        if (!fixedArgs.isEmpty() || !injectParams.isEmpty()) {
            changedParams = ExplicitProcessParameters.builder().launcherArgs(vmArgsValue).args(appArgsValue).combine(injectParams).build();
            vmArgs.addAll(changedParams.getLauncherArguments());
            config.setProperty("exec.vmArgs", MavenExecuteUtils.joinParameters(vmArgs));
            config.setProperty("exec.appArgs", MavenExecuteUtils.joinParameters(changedParams.getArguments()));
        } else {
            vmArgs.addAll(vmArgsValue);
            config.setProperty("exec.vmArgs", MavenExecuteUtils.joinParameters(vmArgs));
            config.setProperty("exec.appArgs", MavenExecuteUtils.joinParameters(appArgsValue));
        }
        return true;
    }
}

