/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.model.WebServiceDataEvent;
import org.netbeans.modules.websvc.manager.model.WebServiceDataListener;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;

public class WebServiceData
implements WsdlData {
    public static final String JAX_WS = "jaxws";
    public static final String JAX_RPC = "jaxrpc";
    private String websvcId;
    private String wsdlFile;
    private String originalWsdlUrl;
    private String catalog;
    private String groupId;
    private String packageName;
    WSService wsdlService;
    private String wsName;
    private boolean jaxWsEnabled;
    private boolean jaxRpcEnabled;
    @Deprecated
    private boolean compiled;
    private State wsdlState = State.WSDL_UNRETRIEVED;
    private boolean resolved;
    private WebServiceDescriptor jaxWsDescriptor;
    private WebServiceDescriptor jaxRpcDescriptor;
    private String jaxWsDescriptorPath;
    private String jaxRpcDescriptorPath;
    private List<WebServiceDataListener> listeners = new ArrayList<WebServiceDataListener>();
    private List<PropertyChangeListener> propertyListeners = new ArrayList<PropertyChangeListener>();

    public WebServiceData() {
        this.resolved = true;
    }

    public WebServiceData(String originalWsdlUrl, String groupId) {
        this(null, originalWsdlUrl, groupId);
        this.wsdlState = State.WSDL_UNRETRIEVED;
    }

    public WebServiceData(String file, String originalWsdl, String groupId) {
        this.websvcId = WebServiceListModel.getInstance().getUniqueWebServiceId();
        this.wsdlFile = file;
        this.groupId = groupId;
        this.compiled = false;
        this.originalWsdlUrl = originalWsdl;
        this.resolved = true;
        if (file != null) {
            this.wsdlState = State.WSDL_RETRIEVED;
        }
    }

    public WebServiceData(WSService service, String wsdlFile, String originalWsdl, String groupId) {
        this(wsdlFile, originalWsdl, groupId);
        this.wsdlService = service;
        this.wsName = service.getName();
    }

    public WebServiceData(WebServiceData that) {
        this(that.getWsdlFile(), that.getOriginalWsdlUrl(), that.getGroupId());
        this.packageName = that.packageName;
        this.jaxWsDescriptor = that.jaxWsDescriptor;
        this.jaxWsDescriptorPath = that.jaxWsDescriptorPath;
        this.jaxWsEnabled = that.jaxWsEnabled;
        this.jaxRpcDescriptor = that.jaxRpcDescriptor;
        this.jaxRpcDescriptorPath = that.jaxRpcDescriptorPath;
        this.jaxRpcEnabled = that.jaxRpcEnabled;
        this.catalog = that.catalog;
        this.wsdlService = that.wsdlService;
        this.wsName = that.wsName;
        this.wsdlState = that.wsdlState;
    }

    public void reset() {
        this.jaxWsDescriptor = null;
        this.jaxWsDescriptorPath = null;
        this.jaxWsEnabled = false;
        this.jaxRpcDescriptor = null;
        this.jaxRpcDescriptorPath = null;
        this.jaxRpcEnabled = false;
        this.catalog = null;
        this.wsdlService = null;
        this.setState(State.WSDL_UNRETRIEVED);
    }

    public boolean isReady() {
        if (this.wsdlFile == null || !new File(this.wsdlFile).isFile() || this.getCatalog() == null || !new File(this.getCatalog()).isFile()) {
            return false;
        }
        if (this.getName() == null || this.getWsdlService() == null) {
            return false;
        }
        return this.getJaxWsDescriptor() != null && !this.getJaxWsDescriptor().getJars().isEmpty();
    }

    public void setResolved(boolean resolved) {
        boolean oldValue = this.resolved;
        this.resolved = resolved;
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "resolved", oldValue, this.resolved);
        for (PropertyChangeListener listener : this.propertyListeners) {
            listener.propertyChange(evt);
        }
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setWsdlService(WSService svc) {
        this.wsdlService = svc;
        if (this.jaxRpcDescriptor != null) {
            this.jaxRpcDescriptor.setModel(this.wsdlService);
        }
        if (this.jaxWsDescriptor != null) {
            this.jaxWsDescriptor.setModel(this.wsdlService);
        }
    }

    public WSService getWsdlService() {
        return this.wsdlService;
    }

    public void setId(String id) {
        this.websvcId = id;
    }

    public String getId() {
        return this.websvcId;
    }

    public void setName(String name) {
        this.wsName = name;
    }

    public String getName() {
        return this.wsName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String id) {
        this.setModelDirty();
        this.groupId = id;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String fileName) {
        this.setModelDirty();
        this.wsdlFile = fileName;
    }

    @Deprecated
    public String getURL() {
        return this.wsdlFile;
    }

    @Deprecated
    public void setURL(String url) {
        this.setModelDirty();
        this.wsdlFile = url;
    }

    public String getOriginalWsdlUrl() {
        return this.originalWsdlUrl;
    }

    public void setOriginalWsdlUrl(String originalWsdl) {
        this.originalWsdlUrl = originalWsdl;
    }

    @Deprecated
    public String getOriginalWsdl() {
        return this.originalWsdlUrl;
    }

    @Deprecated
    public void setOriginalWsdl(String originalWsdl) {
        this.originalWsdlUrl = originalWsdl;
    }

    public void setPackageName(String inPackageName) {
        this.setModelDirty();
        this.packageName = inPackageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getEffectivePackageName() {
        int endIndex;
        String javaName;
        if (this.packageName != null && this.packageName.trim().length() > 0) {
            return this.packageName;
        }
        if (this.wsdlService != null && (javaName = this.wsdlService.getJavaName()) != null && (endIndex = javaName.lastIndexOf(46)) >= 0) {
            return javaName.substring(0, endIndex);
        }
        return "";
    }

    public WebServiceDescriptor getJaxWsDescriptor() {
        return this.jaxWsDescriptor;
    }

    public void setJaxWsDescriptor(WebServiceDescriptor jaxWsDescriptor) {
        this.jaxWsDescriptor = jaxWsDescriptor;
    }

    public WebServiceDescriptor getJaxRpcDescriptor() {
        return this.jaxRpcDescriptor;
    }

    public void setJaxRpcDescriptor(WebServiceDescriptor jaxRpcDescriptor) {
        this.jaxRpcDescriptor = jaxRpcDescriptor;
    }

    public String getJaxWsDescriptorPath() {
        return this.jaxWsDescriptorPath;
    }

    public void setJaxWsDescriptorPath(String jaxWsDescriptorPath) {
        this.jaxWsDescriptorPath = jaxWsDescriptorPath;
    }

    public String getJaxRpcDescriptorPath() {
        return this.jaxRpcDescriptorPath;
    }

    public void setJaxRpcDescriptorPath(String jaxRpcDescriptorPath) {
        this.jaxRpcDescriptorPath = jaxRpcDescriptorPath;
    }

    private void setModelDirty() {
        WebServiceListModel.getInstance().setDirty(true);
    }

    public boolean isJaxRpcEnabled() {
        return this.jaxRpcEnabled;
    }

    public boolean isJaxWsEnabled() {
        return this.jaxWsEnabled;
    }

    public void setJaxRpcEnabled(boolean b) {
        this.jaxRpcEnabled = b;
    }

    public void setJaxWsEnabled(boolean b) {
        this.jaxWsEnabled = b;
    }

    public State getState() {
        return this.wsdlState;
    }

    public void setState(State state) {
        boolean fireEvent = !this.wsdlState.equals((Object)State.WSDL_SERVICE_COMPILED) && state.equals((Object)State.WSDL_SERVICE_COMPILED);
        State old = this.wsdlState;
        WsdlData.Status oldStatus = this.getStatus();
        this.wsdlState = state;
        WsdlData.Status newStatus = this.getStatus();
        if (fireEvent) {
            for (WebServiceDataListener listener : this.listeners) {
                listener.webServiceCompiled(new WebServiceDataEvent(this));
            }
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, "state", oldStatus, newStatus);
        for (PropertyChangeListener listener : this.propertyListeners) {
            listener.propertyChange(evt);
        }
    }

    public String getStateName() {
        return this.wsdlState.name();
    }

    public void setStateName(String name) {
        this.wsdlState = State.valueOf(name);
    }

    @Deprecated
    public boolean isCompiled() {
        return this.compiled;
    }

    @Deprecated
    public void setCompiled(boolean compiled) {
        boolean fireEvent = false;
        if (!this.compiled && compiled) {
            fireEvent = true;
        }
        this.compiled = compiled;
        if (fireEvent) {
            for (WebServiceDataListener listener : this.listeners) {
                listener.webServiceCompiled(new WebServiceDataEvent(this));
            }
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void addWebServiceDataListener(WebServiceDataListener listener) {
        this.listeners.add(listener);
    }

    public void removeWebServiceDataListener(WebServiceDataListener listener) {
        this.listeners.remove(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
    }

    public WsdlData.Status getStatus() {
        if (this.getState() == State.WSDL_UNRETRIEVED) {
            return WsdlData.Status.WSDL_UNRETRIEVED;
        }
        if (this.getState() == State.WSDL_RETRIEVED) {
            return WsdlData.Status.WSDL_RETRIEVED;
        }
        if (this.getState() == State.WSDL_RETRIEVING) {
            return WsdlData.Status.WSDL_RETRIEVING;
        }
        if (this.getState() == State.WSDL_SERVICE_COMPILED) {
            return WsdlData.Status.WSDL_SERVICE_COMPILED;
        }
        if (this.getState() == State.WSDL_SERVICE_COMPILE_FAILED) {
            return WsdlData.Status.WSDL_SERVICE_COMPILE_FAILED;
        }
        if (this.getState() == State.WSDL_SERVICE_COMPILING) {
            return WsdlData.Status.WSDL_SERVICE_COMPILING;
        }
        return WsdlData.Status.WSDL_SERVICE_COMPILING;
    }

    public static enum State {
        WSDL_UNRETRIEVED,
        WSDL_RETRIEVING,
        WSDL_RETRIEVED,
        WSDL_SERVICE_COMPILING,
        WSDL_SERVICE_COMPILED,
        WSDL_SERVICE_COMPILE_FAILED;

    }
}

