/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjshell;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jshell.JShell;
import jdk.jshell.Snippet;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.spi.ExecutionControl;
import org.netbeans.lib.nbjshell.RemoteJShellService;
import org.netbeans.lib.nbjshell.SnippetWrapping;

public class JShellAccessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCompileClasspath(JShell instance, String classpath) throws ExecutionControl.ExecutionControlException {
        try {
            Field factory = JShell.class.getDeclaredField("taskFactory");
            factory.setAccessible(true);
            Class<?> taskFactoryClazz = Class.forName("jdk.jshell.TaskFactory");
            Field f = taskFactoryClazz.getDeclaredField("classpath");
            f.setAccessible(true);
            Object factoryInstance = factory.get(instance);
            f.set(factoryInstance, "");
            Method m = instance.getClass().getDeclaredMethod("executionControl", new Class[0]);
            m.setAccessible(true);
            ExecutionControl ctrl = (ExecutionControl)m.invoke((Object)instance, new Object[0]);
            RemoteJShellService rjs = (RemoteJShellService)ctrl;
            rjs.suppressClasspathChanges(true);
            try {
                instance.addToClasspath(classpath);
            }
            finally {
                rjs.suppressClasspathChanges(false);
            }
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause();
            if (t instanceof ExecutionControl.ExecutionControlException) {
                throw (ExecutionControl.ExecutionControlException)t;
            }
            ExecutionControl.InternalException x = new ExecutionControl.InternalException("Error during setting classpath");
            x.initCause(t);
            throw x;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException ex) {
            Logger.getLogger(JShellAccessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static int getWrappedPosition(JShell state, Snippet snip, int snippetPos) {
        return state.sourceCodeAnalysis().wrapper(snip).sourceToWrappedPosition(snippetPos);
    }

    public static SnippetWrapping snippetWrap(JShell state, Snippet s) {
        SourceCodeAnalysis.SnippetWrapper wrp = state.sourceCodeAnalysis().wrapper(s);
        return new WrappedWrapper(s, wrp, state);
    }

    public static SnippetWrapping wrapInput(JShell state, String input) {
        List<SourceCodeAnalysis.SnippetWrapper> wraps;
        if (input.trim().isEmpty()) {
            input = input + ";";
        }
        if ((wraps = state.sourceCodeAnalysis().wrappers(input)).size() != 1) {
            return null;
        }
        return new WrappedWrapper(null, wraps.get(0), state);
    }

    public static Collection<Snippet> getDependents(JShell state, Snippet snip) {
        return state.sourceCodeAnalysis().dependents(snip);
    }

    private static class WrappedWrapper
    implements SnippetWrapping {
        private final Snippet snippet;
        private final SourceCodeAnalysis.SnippetWrapper wrapper;
        private final JShell jshell;

        public WrappedWrapper(Snippet snippet, SourceCodeAnalysis.SnippetWrapper wrapper, JShell jshell) {
            this.snippet = snippet;
            this.wrapper = wrapper;
            this.jshell = jshell;
        }

        @Override
        public Snippet.Kind getSnippetKind() {
            return this.wrapper.kind();
        }

        @Override
        public Snippet.Status getStatus() {
            return this.snippet == null ? Snippet.Status.NONEXISTENT : this.jshell.status(this.snippet);
        }

        @Override
        public Snippet getSnippet() {
            return this.snippet;
        }

        @Override
        public String getCode() {
            return this.wrapper.wrapped();
        }

        @Override
        public String getSource() {
            return this.wrapper.source();
        }

        @Override
        public int getWrappedPosition(int pos) {
            return this.wrapper.sourceToWrappedPosition(pos);
        }

        @Override
        public String getClassName() {
            return this.wrapper.fullClassName();
        }

        public String toString() {
            return "Wrapper(snippet = " + (this.snippet == null ? "none" : this.snippet.id()) + ", status = " + (Object)((Object)this.getStatus()) + ")";
        }
    }
}

