/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLElement;

public abstract class HCLContainer
extends HCLElement {
    final List<HCLElement> elements = new LinkedList<HCLElement>();
    final List<HCLBlock> blocks = new LinkedList<HCLBlock>();
    final List<HCLAttribute> attributes = new LinkedList<HCLAttribute>();

    public HCLContainer(HCLContainer parent) {
        super(parent);
    }

    public void add(HCLBlock block) {
        this.elements.add(block);
        this.blocks.add(block);
    }

    public void add(HCLAttribute attr) {
        this.elements.add(attr);
        this.attributes.add(attr);
    }

    @Override
    public HCLContainer getContainer() {
        return (HCLContainer)this.parent;
    }

    public Collection<? extends HCLBlock> getBlocks() {
        return Collections.unmodifiableCollection(this.blocks);
    }

    public Collection<? extends HCLAttribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes);
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }
}

