/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.markdown;

import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.markdown.Bundle;
import org.netbeans.modules.markdown.MarkdownDataObject;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class MarkdownViewerElement
implements MultiViewElement {
    private static final Logger LOG = Logger.getLogger(MarkdownViewerElement.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(MarkdownViewerElement.class);
    private static final int UPDATE_DELAY = 500;
    private final MarkdownDataObject dataObject;
    private transient JToolBar toolbar;
    private transient JComponent component;
    private transient JEditorPane viewer;
    private transient MultiViewElementCallback callback;
    static final DataHolder OPTIONS = new MutableDataSet().set(Parser.EXTENSIONS, Arrays.asList(AnchorLinkExtension.create(), TablesExtension.create())).set(HtmlRenderer.INDENT_SIZE, (Object)2).set(HtmlRenderer.RENDER_HEADER_ID, (Object)true).set(HtmlRenderer.FENCED_CODE_LANGUAGE_CLASS_PREFIX, (Object)"").set(AnchorLinkExtension.ANCHORLINKS_SET_NAME, (Object)true).set(AnchorLinkExtension.ANCHORLINKS_SET_ID, (Object)false).set(AnchorLinkExtension.ANCHORLINKS_ANCHOR_CLASS, (Object)"").set(AnchorLinkExtension.ANCHORLINKS_TEXT_PREFIX, (Object)"").set(TablesExtension.COLUMN_SPANS, (Object)false).set(TablesExtension.MIN_HEADER_ROWS, (Object)1).set(TablesExtension.MAX_HEADER_ROWS, (Object)1).set(TablesExtension.APPEND_MISSING_COLUMNS, (Object)true).set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true).set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)true).toImmutable();
    final Parser parser = Parser.builder((DataHolder)OPTIONS).build();
    final HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)OPTIONS).build();
    final DocumentListener dl = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            MarkdownViewerElement.this.updater.schedule(500);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MarkdownViewerElement.this.updater.schedule(500);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            MarkdownViewerElement.this.updater.schedule(500);
        }
    };
    private final RequestProcessor.Task updater = RP.create(this::updateView);
    private StyledDocument source;

    public MarkdownViewerElement(Lookup lookup) {
        this.dataObject = (MarkdownDataObject)((Object)lookup.lookup(MarkdownDataObject.class));
    }

    public JComponent getVisualRepresentation() {
        if (this.component == null) {
            this.viewer = new JEditorPane();
            this.viewer.setContentType("text/html");
            this.viewer.setEditable(false);
            this.viewer.addHyperlinkListener(this::linkHandler);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JScrollPane(this.viewer), "Center");
            this.component = panel;
        }
        return this.component;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
        }
        return this.toolbar;
    }

    public Action[] getActions() {
        return this.callback.createDefaultActions();
    }

    public Lookup getLookup() {
        return this.dataObject.getLookup();
    }

    public void componentOpened() {
        FileObject fo = this.dataObject.getPrimaryFile();
        this.callback.updateTitle(fo.getNameExt());
    }

    public void componentClosed() {
    }

    public void componentShowing() {
        EditorCookie ec = (EditorCookie)this.getLookup().lookup(EditorCookie.class);
        if (ec != null) {
            RP.post(() -> {
                try {
                    this.source = ec.openDocument();
                    this.source.addDocumentListener(this.dl);
                    this.updateView();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
    }

    public void componentHidden() {
        if (this.source != null) {
            this.source.removeDocumentListener(this.dl);
        }
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
        this.callback = callback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public void updateView() {
        if (this.source != null && this.viewer != null) {
            try {
                Rectangle vis = this.viewer.getVisibleRect();
                String content = this.source.getText(0, this.source.getLength());
                String html = this.renderer.render((Node)this.parser.parse(content));
                StringReader htmlReader = new StringReader(html);
                HTMLEditorKit kit = new HTMLEditorKit();
                HTMLDocument doc = (HTMLDocument)this.viewer.getDocument();
                doc.remove(0, doc.getLength());
                kit.read(htmlReader, (Document)doc, 0);
                this.viewer.scrollRectToVisible(vis);
            }
            catch (IOException ex) {
                this.viewer.setText(Bundle.TXT_MarkdownViewerElement_Error());
                LOG.log(Level.WARNING, "Could not parse markdown!", ex);
            }
            catch (BadLocationException ex) {
                this.viewer.setText(Bundle.TXT_MarkdownViewerElement_Error());
            }
        }
    }

    private void linkHandler(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String dsc = evt.getDescription();
            if (evt.getURL() == null && dsc != null) {
                String[] parts = dsc.split("#");
                if (parts.length == 1) {
                    FileObject parent = this.dataObject.getPrimaryFile().getParent();
                    FileObject fo = parent.getFileObject(parts[0]);
                    if (fo != null) {
                        try {
                            DataObject dat = DataObject.find((FileObject)fo);
                            OpenCookie open = (OpenCookie)dat.getLookup().lookup(OpenCookie.class);
                            open.open();
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {}
                    }
                } else if (parts[0].isEmpty() && !parts[1].isEmpty()) {
                    this.viewer.scrollToReference(parts[1]);
                }
            } else if (evt.getURL() != null) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(evt.getURL());
            }
        }
    }
}

