/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.EnumCaseElement;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.model.CaseElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.nodes.CaseDeclarationInfo;

class CaseElementImpl
extends ModelElementImpl
implements CaseElement {
    private final String typeName;
    private final String value;
    private static final String UNKOWN_VALUE = "?";

    CaseElementImpl(Scope inScope, EnumCaseElement indexedCase) {
        super(inScope, indexedCase, PhpElementKind.ENUM_CASE);
        assert (inScope instanceof TypeScope);
        String in = indexedCase.getIn();
        this.typeName = in != null ? in : inScope.getName();
        this.value = indexedCase.getValue();
    }

    CaseElementImpl(Scope inScope, CaseDeclarationInfo info, boolean isDeprecated) {
        super(inScope, info, info.getAccessModifiers(), isDeprecated);
        this.typeName = inScope.getName();
        this.value = info.getValue();
    }

    @Override
    public String getNormalizedName() {
        return this.typeName + super.getNormalizedName();
    }

    @Override
    public void addSelfToIndex(IndexDocument indexDocument) {
        indexDocument.addPair("enum.case", this.getIndexSignature(), true, true);
    }

    private String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(';');
        sb.append(this.getName()).append(';');
        sb.append(this.getOffset()).append(';');
        sb.append(this.getValue() != null ? Signature.encodeItem(this.getValue()) : UNKOWN_VALUE).append(';');
        sb.append(this.isDeprecated() ? 1 : 0).append(';');
        sb.append(this.getFilenameUrl()).append(';');
        sb.append(this.getPhpModifiers().toFlags()).append(';');
        return sb.toString();
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

