/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.form.EventProperty;
import org.netbeans.modules.form.FormUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class EventCustomEditor
extends JPanel {
    static final long serialVersionUID = -4825059521634962952L;
    private JButton addButton;
    private JButton editButton;
    private JList handlersList;
    private JLabel handlersListLabel;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    EventProperty eventProperty;
    DefaultListModel handlersModel = new DefaultListModel();
    EventProperty.Change changes = new EventProperty.Change();

    EventCustomEditor(EventProperty eventProperty) {
        this.eventProperty = eventProperty;
        this.initComponents();
        this.enableButtons();
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)FormUtils.getBundleString("CTL_EE_ADD"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)FormUtils.getBundleString("CTL_EE_REMOVE"));
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)FormUtils.getBundleString("CTL_EE_RENAME"));
        Mnemonics.setLocalizedText((JLabel)this.handlersListLabel, (String)FormUtils.getBundleString("CTL_EE_Handlers"));
        this.handlersList.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_EE_Handlers"));
        this.addButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_EE_ADD"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_EE_REMOVE"));
        this.editButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_EE_RENAME"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_EventCustomEditor"));
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.csh.handlers");
    }

    private void initComponents() {
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.addButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        String[] handlers = this.eventProperty.getEventHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            this.handlersModel.addElement(handlers[i]);
        }
        this.handlersList = new JList();
        this.handlersList.setModel(this.handlersModel);
        if (handlers.length > 0) {
            this.handlersList.setSelectedIndex(0);
        }
        this.handlersListLabel = new JLabel();
        this.editButton.setText("Rename...");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventCustomEditor.this.editButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventCustomEditor.this.removeButtonActionPerformed(evt);
            }
        });
        this.addButton.setText("Add...");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventCustomEditor.this.addButtonActionPerformed(evt);
            }
        });
        this.handlersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                EventCustomEditor.this.handlersListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.handlersList);
        this.handlersListLabel.setLabelFor(this.handlersList);
        this.handlersListLabel.setText("Handlers");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 189, Short.MAX_VALUE).addComponent(this.handlersListLabel, -1, 189, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.editButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.handlersListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addContainerGap(188, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 275, Short.MAX_VALUE))));
    }

    private void handlersListValueChanged(ListSelectionEvent evt) {
        this.enableButtons();
    }

    private void enableButtons() {
        if (this.handlersList.isSelectionEmpty()) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
        this.editButton.setEnabled(this.handlersList.getSelectedIndices().length == 1);
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int i = this.handlersList.getSelectedIndex();
        if (i >= 0) {
            String oldName = (String)this.handlersModel.get(i);
            NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(FormUtils.getBundleString("CTL_EE_RENAME_LABEL"), FormUtils.getBundleString("CTL_EE_RENAME_CAPTION"));
            nd.setInputText(oldName);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.OK_OPTION)) {
                String newName = nd.getInputText();
                if (newName.equals(oldName)) {
                    return;
                }
                if (!Utilities.isJavaIdentifier((String)newName)) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)FormUtils.getBundleString("CTL_EE_NOT_IDENTIFIER"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    return;
                }
                if (this.handlersModel.indexOf(newName) >= 0) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)FormUtils.getBundleString("CTL_EE_ALREADY_EXIST"), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    return;
                }
                int ii = this.changes.getAdded().indexOf(oldName);
                if (ii >= 0) {
                    this.changes.getAdded().set(ii, newName);
                } else {
                    ii = this.changes.getRenamedNewNames().indexOf(oldName);
                    if (ii >= 0) {
                        this.changes.getRenamedNewNames().set(ii, newName);
                    } else {
                        this.changes.getRenamedOldNames().add(oldName);
                        this.changes.getRenamedNewNames().add(newName);
                    }
                }
                this.handlersModel.set(i, newName);
                this.handlersList.setSelectedIndex(i);
                this.enableButtons();
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object[] handlers = this.handlersList.getSelectedValues();
        for (int i = 0; i < handlers.length; ++i) {
            int ii = this.changes.getAdded().indexOf(handlers[i]);
            if (ii >= 0) {
                this.changes.getAdded().remove(ii);
            } else {
                String toRemove;
                ii = this.changes.getRenamedNewNames().indexOf(handlers[i]);
                if (ii >= 0) {
                    this.changes.getRenamedNewNames().remove(ii);
                    toRemove = this.changes.getRenamedOldNames().get(ii);
                    this.changes.getRenamedOldNames().remove(ii);
                } else {
                    toRemove = (String)handlers[i];
                }
                this.changes.getRemoved().add(toRemove);
            }
            this.handlersModel.removeElement(handlers[i]);
            this.enableButtons();
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine(FormUtils.getBundleString("CTL_EE_ADD_LABEL"), FormUtils.getBundleString("CTL_EE_ADD_CAPTION"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.OK_OPTION)) {
            String newHandler = nd.getInputText();
            if (!Utilities.isJavaIdentifier((String)newHandler)) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)FormUtils.getBundleString("CTL_EE_NOT_IDENTIFIER"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            if (this.handlersModel.indexOf(newHandler) >= 0) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)FormUtils.getBundleString("CTL_EE_ALREADY_EXIST"), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                return;
            }
            int ir = this.changes.getRemoved().indexOf(newHandler);
            if (ir >= 0) {
                this.changes.getRemoved().remove(ir);
            } else {
                this.changes.getAdded().add(newHandler);
            }
            this.handlersModel.addElement(newHandler);
            this.handlersList.setSelectedIndex(this.handlersModel.size() - 1);
            this.enableButtons();
        }
    }

    public void doChanges() {
        try {
            this.eventProperty.setValue(this.changes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

