/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.hints.pom.Bundle;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMQName;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginExecution;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Line;

public class UseReleaseOptionHint
implements POMErrorFixProvider {
    private static final String TARGET_TAG = "target";
    private static final String SOURCE_TAG = "source";
    private static final String RELEASE_TAG = "release";
    private static final ComparableVersion COMPILER_PLUGIN_VERSION = new ComparableVersion("3.6.0");
    private static final ComparableVersion MAVEN_VERSION = new ComparableVersion("3.9.0");
    private static final Configuration config = new Configuration(UseReleaseOptionHint.class.getName(), Bundle.TIT_UseReleaseVersionHint(), Bundle.DESC_UseReleaseVersionHint(), true, Configuration.HintSeverity.WARNING);

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        ComparableVersion mavenVersion;
        Optional<Plugin> compilerPlugin;
        String pluginVersion;
        if (prj == null) {
            return Collections.emptyList();
        }
        NbMavenProject nbproject = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        if (nbproject != null && (pluginVersion = PluginPropertyUtils.getPluginVersion((MavenProject)nbproject.getMavenProject(), (String)"org.apache.maven.plugins", (String)"maven-compiler-plugin")) != null && new ComparableVersion(pluginVersion).compareTo(COMPILER_PLUGIN_VERSION) <= 0) {
            return Collections.emptyList();
        }
        Build build = model.getProject().getBuild();
        ArrayList<ErrorDescription> hints = new ArrayList<ErrorDescription>();
        boolean releaseSupportedByDeclaredPlugin = false;
        if (build != null && build.getPlugins() != null && (compilerPlugin = build.getPlugins().stream().filter(p -> "maven-compiler-plugin".equals(p.getArtifactId())).filter(this::isPluginCompatible).findFirst()).isPresent()) {
            releaseSupportedByDeclaredPlugin = true;
            hints.addAll(this.createHintsForParent("", (POMComponent)compilerPlugin.get().getConfiguration()));
            if (compilerPlugin.get().getExecutions() != null) {
                for (PluginExecution exec : compilerPlugin.get().getExecutions()) {
                    hints.addAll(this.createHintsForParent("", (POMComponent)exec.getConfiguration()));
                }
            }
        }
        if (!(releaseSupportedByDeclaredPlugin || (mavenVersion = PomModelUtils.getActiveMavenVersion()) != null && mavenVersion.compareTo(MAVEN_VERSION) > 0)) {
            return Collections.emptyList();
        }
        Properties properties = model.getProject().getProperties();
        if (properties != null) {
            hints.addAll(this.createHintsForParent("maven.compiler.", (POMComponent)properties));
        }
        return hints;
    }

    private List<ErrorDescription> createHintsForParent(String prefix, POMComponent parent) {
        int target;
        int source;
        if (parent == null) {
            return Collections.emptyList();
        }
        String release = null;
        try {
            String targetText;
            String sourceText = parent.getChildElementText(POMQName.createQName((String)(prefix + SOURCE_TAG), (boolean)true));
            if (PomModelUtils.isPropertyExpression(sourceText)) {
                release = sourceText;
                sourceText = PomModelUtils.getProperty(parent.getModel(), sourceText);
            }
            if (PomModelUtils.isPropertyExpression(targetText = parent.getChildElementText(POMQName.createQName((String)(prefix + TARGET_TAG), (boolean)true)))) {
                release = targetText;
                targetText = PomModelUtils.getProperty(parent.getModel(), targetText);
            }
            source = Integer.parseInt(sourceText);
            target = Integer.parseInt(targetText);
            if (release == null) {
                release = String.valueOf(target);
            }
        }
        catch (NumberFormatException ignored) {
            return Collections.emptyList();
        }
        if (source == target && source >= 9) {
            ArrayList<ErrorDescription> hints = new ArrayList<ErrorDescription>();
            for (POMComponent prop : parent.getChildren()) {
                String name = prop.getPeer().getNodeName();
                if (!name.equals(prefix + SOURCE_TAG) && !name.equals(prefix + TARGET_TAG)) continue;
                hints.add(this.createHintForComponent(prefix, prop, parent.getModel(), release));
            }
            return hints;
        }
        return Collections.emptyList();
    }

    private ErrorDescription createHintForComponent(String prefix, POMComponent component, POMModel model, String release) {
        Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)component.findPosition(), (boolean)false);
        List<ConvertToReleaseOptionFix> fix = Collections.singletonList(new ConvertToReleaseOptionFix(prefix, release, component));
        return ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)Bundle.FIX_UseReleaseVersionHint(), fix, (Document)model.getBaseDocument(), (int)(line.getLineNumber() + 1));
    }

    private boolean isPluginCompatible(Plugin plugin) {
        String version = plugin.getVersion();
        if (version == null || version.isEmpty()) {
            return false;
        }
        return new ComparableVersion(version).compareTo(COMPILER_PLUGIN_VERSION) >= 0;
    }

    @Override
    public void cancel() {
    }

    @Override
    public Configuration getConfiguration() {
        return config;
    }

    @Override
    public String getSavedValue(JComponent customizer, String key) {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    private static class ConvertToReleaseOptionFix
    implements Fix {
        private final String prefix;
        private final String release;
        private final POMComponent component;

        private ConvertToReleaseOptionFix(String prefix, String release, POMComponent component) {
            this.prefix = prefix;
            this.component = component;
            this.release = release;
        }

        public ChangeInfo implement() throws Exception {
            ChangeInfo info = new ChangeInfo();
            POMModel model = this.component.getModel();
            PomModelUtils.implementInTransaction((Model)model, () -> {
                POMComponent parent = (POMComponent)this.component.getParent();
                for (POMComponent child : parent.getChildren()) {
                    String name = child.getPeer().getNodeName();
                    if (!name.equals(this.prefix + UseReleaseOptionHint.SOURCE_TAG) && !name.equals(this.prefix + UseReleaseOptionHint.TARGET_TAG) && !name.equals(this.prefix + UseReleaseOptionHint.RELEASE_TAG)) continue;
                    parent.removeExtensibilityElement((POMExtensibilityElement)child);
                }
                POMExtensibilityElement element = model.getFactory().createPOMExtensibilityElement(QName.valueOf(this.prefix + UseReleaseOptionHint.RELEASE_TAG));
                element.setElementText(this.release);
                parent.addExtensibilityElement(element);
            });
            return info;
        }

        public String getText() {
            return Bundle.FIX_UseReleaseVersionHint();
        }
    }
}

