/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.netbeans.modules.jshell.tool.ArgTokenizer;
import org.netbeans.modules.jshell.tool.ContinuousCompletionProvider;
import org.netbeans.modules.jshell.tool.JShellTool;
import org.netbeans.modules.jshell.tool.MessageHandler;

class Feedback {
    private static final Pattern FIELD_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final String TRUNCATION_FIELD = "<truncation>";
    private static final String RECORD_SEPARATOR = "\u241e";
    private Mode mode = new Mode("");
    private Mode retainedCurrentMode = null;
    private final Map<String, Mode> modeMap = new HashMap<String, Mode>();
    private final Map<String, String> retainedMap = new HashMap<String, String>();
    private final Map<String, Selector<?>> selectorMap = new HashMap();
    private static final long ALWAYS = Feedback.bits(FormatCase.all, FormatAction.all, FormatWhen.all, FormatResolve.all, FormatUnresolved.all, FormatErrors.all);
    private static final long ANY = 0L;

    Feedback() {
        for (FormatCase formatCase : FormatCase.all) {
            this.selectorMap.put(formatCase.name().toLowerCase(Locale.US), formatCase);
        }
        for (FormatAction formatAction : FormatAction.all) {
            this.selectorMap.put(formatAction.name().toLowerCase(Locale.US), formatAction);
        }
        for (FormatResolve formatResolve : FormatResolve.all) {
            this.selectorMap.put(formatResolve.name().toLowerCase(Locale.US), formatResolve);
        }
        for (FormatUnresolved formatUnresolved : FormatUnresolved.all) {
            this.selectorMap.put(formatUnresolved.name().toLowerCase(Locale.US), formatUnresolved);
        }
        for (FormatErrors formatErrors : FormatErrors.all) {
            this.selectorMap.put(formatErrors.name().toLowerCase(Locale.US), formatErrors);
        }
        for (FormatWhen formatWhen : FormatWhen.all) {
            this.selectorMap.put(formatWhen.name().toLowerCase(Locale.US), formatWhen);
        }
    }

    public boolean shouldDisplayCommandFluff() {
        return this.mode.commandFluff;
    }

    public String getPre() {
        return this.mode.format("pre", 0L);
    }

    public String getPost() {
        return this.mode.format("post", 0L);
    }

    public String getErrorPre() {
        return this.mode.format("errorpre", 0L);
    }

    public String getErrorPost() {
        return this.mode.format("errorpost", 0L);
    }

    public String format(FormatCase fc, FormatAction fa, FormatWhen fw, FormatResolve fr, FormatUnresolved fu, FormatErrors fe, String name, String type, String value, String unresolved, List<String> errorLines) {
        return this.mode.format(fc, fa, fw, fr, fu, fe, name, type, value, unresolved, errorLines);
    }

    public String getPrompt(String nextId) {
        return this.mode.getPrompt(nextId);
    }

    public String getContinuationPrompt(String nextId) {
        return this.mode.getContinuationPrompt(nextId);
    }

    public boolean setFeedback(MessageHandler messageHandler, ArgTokenizer at, Consumer<String> retainer) {
        return new Setter(messageHandler, at).setFeedback(retainer);
    }

    public boolean setFormat(MessageHandler messageHandler, ArgTokenizer at) {
        return new Setter(messageHandler, at).setFormat();
    }

    public boolean setTruncation(MessageHandler messageHandler, ArgTokenizer at) {
        return new Setter(messageHandler, at).setTruncation();
    }

    public boolean setMode(MessageHandler messageHandler, ArgTokenizer at, Consumer<String> retainer) {
        return new Setter(messageHandler, at).setMode(retainer);
    }

    public boolean setPrompt(MessageHandler messageHandler, ArgTokenizer at) {
        return new Setter(messageHandler, at).setPrompt();
    }

    public boolean restoreEncodedModes(MessageHandler messageHandler, String encoded) {
        return new Setter(messageHandler, new ArgTokenizer("<init>", "")).restoreEncodedModes(encoded);
    }

    public void markModesReadOnly() {
        this.modeMap.values().stream().forEach(m -> {
            m.readOnly = true;
        });
    }

    JShellTool.CompletionProvider modeCompletions() {
        return this.modeCompletions(JShellTool.EMPTY_COMPLETION_PROVIDER);
    }

    JShellTool.CompletionProvider modeCompletions(JShellTool.CompletionProvider successor) {
        return new ContinuousCompletionProvider(() -> this.modeMap.keySet().stream().collect(Collectors.toMap(Function.identity(), m -> successor)), ContinuousCompletionProvider.PERFECT_MATCHER);
    }

    private static long bits(FormatCase fc, FormatAction fa, FormatWhen fw, FormatResolve fr, FormatUnresolved fu, FormatErrors fe) {
        long res = 0L;
        res |= (long)(1 << fc.ordinal());
        res <<= FormatAction.count;
        res |= (long)(1 << fa.ordinal());
        res <<= FormatWhen.count;
        res |= (long)(1 << fw.ordinal());
        res <<= FormatResolve.count;
        res |= (long)(1 << fr.ordinal());
        res <<= FormatUnresolved.count;
        res |= (long)(1 << fu.ordinal());
        res <<= FormatErrors.count;
        return res |= (long)(1 << fe.ordinal());
    }

    private static long bits(Collection<FormatCase> cc, Collection<FormatAction> ca, Collection<FormatWhen> cw, Collection<FormatResolve> cr, Collection<FormatUnresolved> cu, Collection<FormatErrors> ce) {
        long res = 0L;
        for (FormatCase fc : cc) {
            res |= (long)(1 << fc.ordinal());
        }
        res <<= FormatAction.count;
        for (FormatAction fa : ca) {
            res |= (long)(1 << fa.ordinal());
        }
        res <<= FormatWhen.count;
        for (FormatWhen fw : cw) {
            res |= (long)(1 << fw.ordinal());
        }
        res <<= FormatResolve.count;
        for (FormatResolve fr : cr) {
            res |= (long)(1 << fr.ordinal());
        }
        res <<= FormatUnresolved.count;
        for (FormatUnresolved fu : cu) {
            res |= (long)(1 << fu.ordinal());
        }
        res <<= FormatErrors.count;
        for (FormatErrors fe : ce) {
            res |= (long)(1 << fe.ordinal());
        }
        return res;
    }

    private static SelectorSets unpackEnumbits(long enumBits) {
        class Unpacker {
            SelectorSets u = new SelectorSets();
            long b = this.val$enumBits;
            final /* synthetic */ long val$enumBits;

            Unpacker(long l) {
                this.val$enumBits = l;
            }

            <E extends Enum<E>> Set<E> unpackEnumbits(E[] values) {
                HashSet<E> c = new HashSet<E>();
                for (int i = 0; i < values.length; ++i) {
                    if ((this.b & (long)(1 << i)) == 0L) continue;
                    c.add(values[i]);
                }
                this.b >>>= values.length;
                return c;
            }

            SelectorSets unpack() {
                this.u.ce = this.unpackEnumbits(FormatErrors.values());
                this.u.cu = this.unpackEnumbits(FormatUnresolved.values());
                this.u.cr = this.unpackEnumbits(FormatResolve.values());
                this.u.cw = this.unpackEnumbits(FormatWhen.values());
                this.u.ca = this.unpackEnumbits(FormatAction.values());
                this.u.cc = this.unpackEnumbits(FormatCase.values());
                return this.u;
            }
        }
        return new Unpacker(enumBits).unpack();
    }

    String modeName() {
        return this.mode.name;
    }

    private class Setter {
        private final ArgTokenizer at;
        private final MessageHandler messageHandler;
        boolean valid = true;

        Setter(MessageHandler messageHandler, ArgTokenizer at) {
            this.messageHandler = messageHandler;
            this.at = at;
            at.allowedOptions("-retain");
        }

        void fluff(String format, Object ... args) {
            this.messageHandler.fluff(format, args);
        }

        void hard(String format, Object ... args) {
            this.messageHandler.hard(format, args);
        }

        void fluffmsg(String messageKey, Object ... args) {
            this.messageHandler.fluffmsg(messageKey, args);
        }

        void hardmsg(String messageKey, Object ... args) {
            this.messageHandler.hardmsg(messageKey, args);
        }

        boolean showFluff() {
            return this.messageHandler.showFluff();
        }

        void errorat(String messageKey, Object ... args) {
            if (!this.valid) {
                return;
            }
            this.valid = false;
            Object[] a2 = Arrays.copyOf(args, args.length + 2);
            a2[args.length] = this.at.whole();
            this.messageHandler.errormsg(messageKey, a2);
        }

        String selectorsToString(SelectorSets u) {
            StringBuilder sb = new StringBuilder();
            this.selectorToString(sb, u.cc, FormatCase.values());
            this.selectorToString(sb, u.ca, FormatAction.values());
            this.selectorToString(sb, u.cw, FormatWhen.values());
            this.selectorToString(sb, u.cr, FormatResolve.values());
            this.selectorToString(sb, u.cu, FormatUnresolved.values());
            this.selectorToString(sb, u.ce, FormatErrors.values());
            return sb.toString();
        }

        private <E extends Enum<E>> void selectorToString(final StringBuilder sb, Set<E> c, E[] values) {
            if (!c.containsAll(Arrays.asList(values))) {
                sb.append(c.stream().sorted((x, y) -> x.ordinal() - y.ordinal()).map(v -> v.name().toLowerCase(Locale.US)).collect(new Collector<CharSequence, StringJoiner, String>(){

                    @Override
                    public BiConsumer<StringJoiner, CharSequence> accumulator() {
                        return StringJoiner::add;
                    }

                    @Override
                    public Supplier<StringJoiner> supplier() {
                        return () -> new StringJoiner(",", sb.length() == 0 ? "" : "-", "").setEmptyValue("");
                    }

                    @Override
                    public BinaryOperator<StringJoiner> combiner() {
                        return StringJoiner::merge;
                    }

                    @Override
                    public Function<StringJoiner, String> finisher() {
                        return StringJoiner::toString;
                    }

                    @Override
                    public Set<Collector.Characteristics> characteristics() {
                        return Collections.emptySet();
                    }
                }));
            }
        }

        void showFormatSettings(Mode sm, String f) {
            if (sm == null) {
                Feedback.this.modeMap.entrySet().stream().sorted((es1, es2) -> ((String)es1.getKey()).compareTo((String)es2.getKey())).forEach(m -> this.showFormatSettings((Mode)m.getValue(), f));
            } else {
                sm.cases.entrySet().stream().filter(ec -> f == null ? !((String)ec.getKey()).equals(Feedback.TRUNCATION_FIELD) : ((String)ec.getKey()).equals(f)).sorted((ec1, ec2) -> ((String)ec1.getKey()).compareTo((String)ec2.getKey())).forEach(ec -> ((List)ec.getValue()).forEach(s -> this.hard("/set format %s %s %s %s", sm.name, ec.getKey(), this.toStringLiteral(s.format), this.selectorsToString(Feedback.unpackEnumbits(s.enumBits)))));
            }
        }

        void showTruncationSettings(Mode sm) {
            if (sm == null) {
                Feedback.this.modeMap.values().forEach(m -> this.showTruncationSettings((Mode)m));
            } else {
                List<Mode.Setting> trunc = sm.cases.get(Feedback.TRUNCATION_FIELD);
                if (trunc != null) {
                    trunc.forEach(s -> this.hard("/set truncation %s %s %s", sm.name, s.format, this.selectorsToString(Feedback.unpackEnumbits(s.enumBits))));
                }
            }
        }

        void showPromptSettings(Mode sm) {
            if (sm == null) {
                Feedback.this.modeMap.values().forEach(m -> this.showPromptSettings((Mode)m));
            } else {
                this.hard("/set prompt %s %s %s", sm.name, this.toStringLiteral(sm.prompt), this.toStringLiteral(sm.continuationPrompt));
            }
        }

        void showModeSettings(String umode, String msg) {
            if (umode == null) {
                Feedback.this.modeMap.values().forEach(n -> this.showModeSettings((Mode)n));
            } else {
                Mode m;
                String retained = (String)Feedback.this.retainedMap.get(umode);
                if (retained == null) {
                    m = this.searchForMode(umode, msg);
                    if (m == null) {
                        return;
                    }
                    umode = m.name;
                    retained = (String)Feedback.this.retainedMap.get(umode);
                } else {
                    m = (Mode)Feedback.this.modeMap.get(umode);
                }
                if (retained != null) {
                    Mode rm = new Mode(this.encodedModeIterator(retained));
                    this.showModeSettings(rm);
                    this.hard("/set mode -retain %s", umode);
                    if (m != null && !m.equals(rm)) {
                        this.hard("", new Object[0]);
                        this.showModeSettings(m);
                    }
                } else {
                    this.showModeSettings(m);
                }
            }
        }

        void showModeSettings(Mode sm) {
            this.hard("/set mode %s %s", sm.name, sm.commandFluff ? "-command" : "-quiet");
            this.showPromptSettings(sm);
            this.showFormatSettings(sm, null);
            this.showTruncationSettings(sm);
        }

        void showFeedbackSetting() {
            if (Feedback.this.retainedCurrentMode != null) {
                this.hard("/set feedback -retain %s", ((Feedback)Feedback.this).retainedCurrentMode.name);
            }
            if (Feedback.this.mode != Feedback.this.retainedCurrentMode) {
                this.hard("/set feedback %s", ((Feedback)Feedback.this).mode.name);
            }
        }

        boolean setPrompt() {
            Mode m = this.nextMode();
            String prompt = this.nextFormat();
            String continuationPrompt = this.nextFormat();
            this.checkOptionsAndRemainingInput();
            if (this.valid && prompt == null) {
                this.showPromptSettings(m);
                return this.valid;
            }
            if (this.valid && m.readOnly) {
                this.errorat("jshell.err.not.valid.with.predefined.mode", m.name);
            } else if (continuationPrompt == null) {
                this.errorat("jshell.err.continuation.prompt.required", new Object[0]);
            }
            if (this.valid) {
                m.setPrompts(prompt, continuationPrompt);
            } else {
                this.fluffmsg("jshell.msg.see", "/help /set prompt");
            }
            return this.valid;
        }

        boolean setMode(final Consumer<String> retainer) {
            class SetMode {
                final String umode;
                final String omode;
                final boolean commandOption;
                final boolean quietOption;
                final boolean deleteOption;
                final boolean retainOption;

                SetMode() {
                    Setter.this.at.allowedOptions("-command", "-quiet", "-delete", "-retain");
                    this.umode = Setter.this.nextModeIdentifier();
                    this.omode = Setter.this.nextModeIdentifier();
                    Setter.this.checkOptionsAndRemainingInput();
                    this.commandOption = Setter.this.at.hasOption("-command");
                    this.quietOption = Setter.this.at.hasOption("-quiet");
                    this.deleteOption = Setter.this.at.hasOption("-delete");
                    this.retainOption = Setter.this.at.hasOption("-retain");
                }

                void delete() {
                    if (this.commandOption || this.quietOption) {
                        Setter.this.errorat("jshell.err.conflicting.options", new Object[0]);
                    } else if (!(this.retainOption ? Feedback.this.retainedMap : Feedback.this.modeMap).containsKey(this.umode)) {
                        Setter.this.errorat("jshell.err.mode.unknown", this.umode);
                    } else if (this.omode != null) {
                        Setter.this.errorat("jshell.err.unexpected.at.end", this.omode);
                    } else if (((Feedback)Feedback.this).mode.name.equals(this.umode)) {
                        Setter.this.errorat("jshell.err.cannot.delete.current.mode", this.umode);
                    } else if (this.retainOption && Feedback.this.retainedCurrentMode != null && ((Feedback)Feedback.this).retainedCurrentMode.name.equals(this.umode)) {
                        Setter.this.errorat("jshell.err.cannot.delete.retained.mode", this.umode);
                    } else {
                        Mode m = (Mode)Feedback.this.modeMap.get(this.umode);
                        if (m != null && m.readOnly) {
                            Setter.this.errorat("jshell.err.not.valid.with.predefined.mode", this.umode);
                        } else {
                            Feedback.this.modeMap.remove(this.umode);
                            if (this.retainOption) {
                                Feedback.this.retainedMap.remove(this.umode);
                                this.updateRetainedModes();
                            }
                        }
                    }
                }

                void retain() {
                    if (this.commandOption || this.quietOption) {
                        Setter.this.errorat("jshell.err.conflicting.options", new Object[0]);
                    } else if (this.omode != null) {
                        Setter.this.errorat("jshell.err.unexpected.at.end", this.omode);
                    } else {
                        Mode m = (Mode)Feedback.this.modeMap.get(this.umode);
                        if (m == null) {
                            Setter.this.errorat("jshell.err.mode.unknown", this.umode);
                        } else if (m.readOnly) {
                            Setter.this.errorat("jshell.err.not.valid.with.predefined.mode", this.umode);
                        } else {
                            Feedback.this.retainedMap.put(m.name, m.encode());
                            this.updateRetainedModes();
                        }
                    }
                }

                void updateRetainedModes() {
                    String encoded = String.join((CharSequence)Feedback.RECORD_SEPARATOR, Feedback.this.retainedMap.values());
                    retainer.accept(encoded);
                }

                void create() {
                    if (this.commandOption && this.quietOption) {
                        Setter.this.errorat("jshell.err.conflicting.options", new Object[0]);
                    } else if (!this.commandOption && !this.quietOption) {
                        Setter.this.errorat("jshell.err.mode.creation", new Object[0]);
                    } else if (Feedback.this.modeMap.containsKey(this.umode)) {
                        Setter.this.errorat("jshell.err.mode.exists", this.umode);
                    } else {
                        Mode om = Setter.this.searchForMode(this.omode);
                        if (Setter.this.valid) {
                            Mode m = om != null ? new Mode(this.umode, om) : new Mode(this.umode);
                            Feedback.this.modeMap.put(this.umode, m);
                            Setter.this.fluffmsg("jshell.msg.feedback.new.mode", m.name);
                            m.setCommandFluff(this.commandOption);
                        }
                    }
                }

                boolean set() {
                    if (!(!Setter.this.valid || this.commandOption || this.quietOption || this.deleteOption || this.omode != null || this.retainOption)) {
                        Setter.this.showModeSettings(this.umode, "jshell.err.mode.creation");
                    } else if (Setter.this.valid && this.umode == null) {
                        Setter.this.errorat("jshell.err.missing.mode", new Object[0]);
                    } else if (Setter.this.valid && this.deleteOption) {
                        this.delete();
                    } else if (Setter.this.valid && this.retainOption) {
                        this.retain();
                    } else if (Setter.this.valid) {
                        this.create();
                    }
                    if (!Setter.this.valid) {
                        Setter.this.fluffmsg("jshell.msg.see", "/help /set mode");
                    }
                    return Setter.this.valid;
                }
            }
            return new SetMode().set();
        }

        boolean setFormat() {
            Mode m = this.nextMode();
            String field = this.toIdentifier(this.next(), "jshell.err.field.name");
            String format = this.nextFormat();
            if (this.valid && format == null) {
                if (field != null && m != null && !m.cases.containsKey(field)) {
                    this.errorat("jshell.err.field.name", field);
                } else {
                    this.showFormatSettings(m, field);
                }
            } else {
                this.installFormat(m, field, format, "/help /set format");
            }
            return this.valid;
        }

        boolean setTruncation() {
            Mode m = this.nextMode();
            String length = this.next();
            if (length == null) {
                this.showTruncationSettings(m);
            } else {
                try {
                    Integer.parseUnsignedInt(length);
                }
                catch (NumberFormatException ex) {
                    this.errorat("jshell.err.truncation.length.not.integer", length);
                }
                this.installFormat(m, Feedback.TRUNCATION_FIELD, length, "/help /set truncation");
            }
            return this.valid;
        }

        boolean setFeedback(Consumer<String> retainer) {
            String umode = this.next();
            this.checkOptionsAndRemainingInput();
            boolean retainOption = this.at.hasOption("-retain");
            if (this.valid && umode == null && !retainOption) {
                this.showFeedbackSetting();
                this.hard("", new Object[0]);
                this.showFeedbackModes();
                return true;
            }
            if (this.valid) {
                Mode m;
                Mode mode = m = umode == null ? Feedback.this.mode : this.searchForMode(this.toModeIdentifier(umode));
                if (this.valid && retainOption && !m.readOnly && !Feedback.this.retainedMap.containsKey(m.name)) {
                    this.errorat("jshell.err.retained.feedback.mode.must.be.retained.or.predefined", new Object[0]);
                }
                if (this.valid) {
                    if (umode != null) {
                        Feedback.this.mode = m;
                        this.fluffmsg("jshell.msg.feedback.mode", ((Feedback)Feedback.this).mode.name);
                    }
                    if (retainOption) {
                        Feedback.this.retainedCurrentMode = m;
                        retainer.accept(m.name);
                    }
                }
            }
            if (!this.valid) {
                this.fluffmsg("jshell.msg.see", "/help /set feedback");
                return false;
            }
            return true;
        }

        boolean restoreEncodedModes(String allEncoded) {
            try {
                Iterator<String> itr = this.encodedModeIterator(allEncoded);
                while (itr.hasNext()) {
                    Mode m = new Mode(itr);
                    Feedback.this.modeMap.put(m.name, m);
                    Feedback.this.retainedMap.put(m.name, m.encode());
                }
                return true;
            }
            catch (Throwable exc) {
                this.errorat("jshell.err.retained.mode.failure", exc);
                Feedback.this.retainedMap.clear();
                return false;
            }
        }

        Iterator<String> encodedModeIterator(String encoded) {
            String[] ms = encoded.split(Feedback.RECORD_SEPARATOR);
            return Arrays.asList(ms).iterator();
        }

        void installFormat(Mode m, String field, String format, String help) {
            String slRaw;
            ArrayList<SelectorList> slList = new ArrayList<SelectorList>();
            while (this.valid && (slRaw = this.next()) != null) {
                SelectorList sl2 = new SelectorList();
                sl2.parseSelectorList(slRaw);
                slList.add(sl2);
            }
            this.checkOptionsAndRemainingInput();
            if (this.valid) {
                if (m.readOnly) {
                    this.errorat("jshell.err.not.valid.with.predefined.mode", m.name);
                } else if (slList.isEmpty()) {
                    m.set(field, ALWAYS, format);
                } else {
                    slList.stream().forEach(sl -> m.set(field, sl.cases.getSet(), sl.actions.getSet(), sl.whens.getSet(), sl.resolves.getSet(), sl.unresolvedCounts.getSet(), sl.errorCounts.getSet(), format));
                }
            } else {
                this.fluffmsg("jshell.msg.see", help);
            }
        }

        void checkOptionsAndRemainingInput() {
            String junk = this.at.remainder();
            if (!junk.isEmpty()) {
                this.errorat("jshell.err.unexpected.at.end", junk);
            } else {
                String bad = this.at.badOptions();
                if (!bad.isEmpty()) {
                    this.errorat("jshell.err.unknown.option", bad);
                }
            }
        }

        String next() {
            String s = this.at.next();
            if (s == null) {
                this.checkOptionsAndRemainingInput();
            }
            return s;
        }

        private String toIdentifier(String id, String err) {
            if (!this.valid || id == null) {
                return null;
            }
            if (this.at.isQuoted() || !id.codePoints().allMatch(cp -> Character.isJavaIdentifierPart(cp))) {
                this.errorat(err, id);
                return null;
            }
            return id;
        }

        private String toModeIdentifier(String id) {
            return this.toIdentifier(id, "jshell.err.mode.name");
        }

        private String nextModeIdentifier() {
            return this.toModeIdentifier(this.next());
        }

        private Mode nextMode() {
            String umode = this.nextModeIdentifier();
            return this.searchForMode(umode);
        }

        private Mode searchForMode(String umode) {
            return this.searchForMode(umode, null);
        }

        private Mode searchForMode(String umode, String msg) {
            if (!this.valid || umode == null) {
                return null;
            }
            Mode m = (Mode)Feedback.this.modeMap.get(umode);
            if (m != null) {
                return m;
            }
            Mode[] matches = (Mode[])Feedback.this.modeMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(umode)).map(e -> (Mode)e.getValue()).toArray(Mode[]::new);
            if (matches.length == 1) {
                return matches[0];
            }
            if (msg != null) {
                this.hardmsg(msg, "");
            }
            if (matches.length == 0) {
                this.errorat("jshell.err.feedback.does.not.match.mode", umode);
            } else {
                this.errorat("jshell.err.feedback.ambiguous.mode", umode);
            }
            if (this.showFluff()) {
                this.showFeedbackModes();
            }
            return null;
        }

        void showFeedbackModes() {
            if (!Feedback.this.retainedMap.isEmpty()) {
                this.hardmsg("jshell.msg.feedback.retained.mode.following", new Object[0]);
                Feedback.this.retainedMap.keySet().stream().sorted().forEach(mk -> this.hard("   %s", mk));
            }
            this.hardmsg("jshell.msg.feedback.mode.following", new Object[0]);
            Feedback.this.modeMap.keySet().stream().sorted().forEach(mk -> this.hard("   %s", mk));
        }

        private String nextFormat() {
            return this.toFormat(this.next());
        }

        private String toFormat(String format) {
            if (!this.valid || format == null) {
                return null;
            }
            if (!this.at.isQuoted()) {
                this.errorat("jshell.err.feedback.must.be.quoted", format);
                return null;
            }
            return format;
        }

        private String toStringLiteral(String s) {
            int codepoint;
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            int length = s.length();
            block10: for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
                codepoint = s.codePointAt(offset);
                switch (codepoint) {
                    case 8: {
                        sb.append("\\b");
                        continue block10;
                    }
                    case 9: {
                        sb.append("\\t");
                        continue block10;
                    }
                    case 10: {
                        sb.append("\\n");
                        continue block10;
                    }
                    case 12: {
                        sb.append("\\f");
                        continue block10;
                    }
                    case 13: {
                        sb.append("\\r");
                        continue block10;
                    }
                    case 34: {
                        sb.append("\\\"");
                        continue block10;
                    }
                    case 39: {
                        sb.append("\\'");
                        continue block10;
                    }
                    case 92: {
                        sb.append("\\\\");
                        continue block10;
                    }
                    default: {
                        if (codepoint < 32) {
                            sb.append(String.format("\\%o", codepoint));
                            continue block10;
                        }
                        sb.appendCodePoint(codepoint);
                    }
                }
            }
            sb.append('\"');
            return sb.toString();
        }

        class SelectorList {
            SelectorCollector<FormatCase> cases;
            SelectorCollector<FormatAction> actions;
            SelectorCollector<FormatWhen> whens;
            SelectorCollector<FormatResolve> resolves;
            SelectorCollector<FormatUnresolved> unresolvedCounts;
            SelectorCollector<FormatErrors> errorCounts;

            SelectorList() {
                this.cases = new SelectorCollector<FormatCase>(FormatCase.all);
                this.actions = new SelectorCollector<FormatAction>(FormatAction.all);
                this.whens = new SelectorCollector<FormatWhen>(FormatWhen.all);
                this.resolves = new SelectorCollector<FormatResolve>(FormatResolve.all);
                this.unresolvedCounts = new SelectorCollector<FormatUnresolved>(FormatUnresolved.all);
                this.errorCounts = new SelectorCollector<FormatErrors>(FormatErrors.all);
            }

            final void parseSelectorList(String sl) {
                for (String s : sl.split("-")) {
                    SelectorCollector lastCollector = null;
                    for (String as : s.split(",")) {
                        if (as.isEmpty()) continue;
                        Selector sel = (Selector)Feedback.this.selectorMap.get(as);
                        if (sel == null) {
                            Setter.this.errorat("jshell.err.feedback.not.a.valid.selector", as, s);
                            return;
                        }
                        SelectorCollector collector = sel.collector(this);
                        if (lastCollector == null) {
                            if (!collector.isEmpty()) {
                                Setter.this.errorat("jshell.err.feedback.multiple.sections", as, s);
                                return;
                            }
                        } else if (collector != lastCollector) {
                            Setter.this.errorat("jshell.err.feedback.different.selector.kinds", as, s);
                            return;
                        }
                        collector.add(sel);
                        lastCollector = collector;
                    }
                }
            }
        }
    }

    class SelectorCollector<E extends Enum<E>> {
        final EnumSet<E> all;
        EnumSet<E> set = null;

        SelectorCollector(EnumSet<E> all) {
            this.all = all;
        }

        void add(Object o) {
            Enum e = (Enum)o;
            if (this.set == null) {
                this.set = EnumSet.of(e);
            } else {
                this.set.add(e);
            }
        }

        boolean isEmpty() {
            return this.set == null;
        }

        EnumSet<E> getSet() {
            return this.set == null ? this.all : this.set;
        }
    }

    public static enum FormatErrors implements Selector<FormatErrors>
    {
        ERROR0("no errors"),
        ERROR1("one error"),
        ERROR2("two or more errors");

        String doc;
        static final EnumSet<FormatErrors> all;
        static final int count;

        @Override
        public SelectorCollector<FormatErrors> collector(Setter.SelectorList sl) {
            return sl.errorCounts;
        }

        @Override
        public String doc() {
            return this.doc;
        }

        private FormatErrors(String doc) {
            this.doc = doc;
        }

        static {
            all = EnumSet.allOf(FormatErrors.class);
            count = all.size();
        }
    }

    public static enum FormatUnresolved implements Selector<FormatUnresolved>
    {
        UNRESOLVED0("no names are unresolved"),
        UNRESOLVED1("one name is unresolved"),
        UNRESOLVED2("two or more names are unresolved");

        String doc;
        static final EnumSet<FormatUnresolved> all;
        static final int count;

        @Override
        public SelectorCollector<FormatUnresolved> collector(Setter.SelectorList sl) {
            return sl.unresolvedCounts;
        }

        @Override
        public String doc() {
            return this.doc;
        }

        private FormatUnresolved(String doc) {
            this.doc = doc;
        }

        static {
            all = EnumSet.allOf(FormatUnresolved.class);
            count = all.size();
        }
    }

    public static enum FormatResolve implements Selector<FormatResolve>
    {
        OK("resolved correctly"),
        DEFINED("defined despite recoverably unresolved references"),
        NOTDEFINED("not defined because of recoverably unresolved references");

        String doc;
        static final EnumSet<FormatResolve> all;
        static final int count;

        @Override
        public SelectorCollector<FormatResolve> collector(Setter.SelectorList sl) {
            return sl.resolves;
        }

        @Override
        public String doc() {
            return this.doc;
        }

        private FormatResolve(String doc) {
            this.doc = doc;
        }

        static {
            all = EnumSet.allOf(FormatResolve.class);
            count = all.size();
        }
    }

    public static enum FormatWhen implements Selector<FormatWhen>
    {
        PRIMARY("the entered snippet"),
        UPDATE("an update to a dependent snippet");

        String doc;
        static final EnumSet<FormatWhen> all;
        static final int count;

        @Override
        public SelectorCollector<FormatWhen> collector(Setter.SelectorList sl) {
            return sl.whens;
        }

        @Override
        public String doc() {
            return this.doc;
        }

        private FormatWhen(String doc) {
            this.doc = doc;
        }

        static {
            all = EnumSet.allOf(FormatWhen.class);
            count = all.size();
        }
    }

    public static enum FormatAction implements Selector<FormatAction>
    {
        ADDED("snippet has been added"),
        MODIFIED("an existing snippet has been modified"),
        REPLACED("an existing snippet has been replaced with a new snippet"),
        OVERWROTE("an existing snippet has been overwritten"),
        DROPPED("snippet has been dropped"),
        USED("snippet was used when it cannot be");

        String doc;
        static final EnumSet<FormatAction> all;
        static final int count;

        @Override
        public SelectorCollector<FormatAction> collector(Setter.SelectorList sl) {
            return sl.actions;
        }

        @Override
        public String doc() {
            return this.doc;
        }

        private FormatAction(String doc) {
            this.doc = doc;
        }

        static {
            all = EnumSet.allOf(FormatAction.class);
            count = all.size();
        }
    }

    public static enum FormatCase implements Selector<FormatCase>
    {
        IMPORT("import declaration"),
        CLASS("class declaration"),
        INTERFACE("interface declaration"),
        ENUM("enum declaration"),
        ANNOTATION("annotation interface declaration"),
        METHOD("method declaration -- note: {type}==parameter-types"),
        VARDECL("variable declaration without init"),
        VARINIT("variable declaration with init"),
        EXPRESSION("expression -- note: {name}==scratch-variable-name"),
        VARVALUE("variable value expression"),
        ASSIGNMENT("assign variable"),
        STATEMENT("statement");

        String doc;
        static final EnumSet<FormatCase> all;
        static final int count;

        @Override
        public SelectorCollector<FormatCase> collector(Setter.SelectorList sl) {
            return sl.cases;
        }

        @Override
        public String doc() {
            return this.doc;
        }

        private FormatCase(String doc) {
            this.doc = doc;
        }

        static {
            all = EnumSet.allOf(FormatCase.class);
            count = all.size();
        }
    }

    static interface Selector<E extends Enum<E>> {
        public SelectorCollector<E> collector(Setter.SelectorList var1);

        public String doc();
    }

    private static class Mode {
        final String name;
        boolean commandFluff;
        final Map<String, List<Setting>> cases;
        boolean readOnly = false;
        String prompt = "\n-> ";
        String continuationPrompt = ">> ";

        Mode(String name) {
            this.name = name;
            this.cases = new HashMap<String, List<Setting>>();
            this.add("name", new Setting(ALWAYS, "%1$s"));
            this.add("type", new Setting(ALWAYS, "%2$s"));
            this.add("value", new Setting(ALWAYS, "%3$s"));
            this.add("unresolved", new Setting(ALWAYS, "%4$s"));
            this.add("errors", new Setting(ALWAYS, "%5$s"));
            this.add("err", new Setting(ALWAYS, "%6$s"));
            this.add("errorline", new Setting(ALWAYS, "    {err}%n"));
            this.add("pre", new Setting(ALWAYS, "|  "));
            this.add("post", new Setting(ALWAYS, "%n"));
            this.add("errorpre", new Setting(ALWAYS, "|  "));
            this.add("errorpost", new Setting(ALWAYS, "%n"));
        }

        Mode(String name, Mode m) {
            this.name = name;
            this.commandFluff = m.commandFluff;
            this.prompt = m.prompt;
            this.continuationPrompt = m.continuationPrompt;
            this.cases = new HashMap<String, List<Setting>>();
            m.cases.entrySet().stream().forEach(fes -> ((List)fes.getValue()).forEach(ing -> this.add((String)fes.getKey(), (Setting)ing)));
        }

        Mode(Iterator<String> it) {
            String field;
            this.name = it.next();
            this.commandFluff = Boolean.parseBoolean(it.next());
            this.prompt = it.next();
            this.continuationPrompt = it.next();
            this.cases = new HashMap<String, List<Setting>>();
            while (!(field = it.next()).equals("***")) {
                String bits;
                String open = it.next();
                assert (open.equals("("));
                ArrayList<Setting> settings = new ArrayList<Setting>();
                while (!(bits = it.next()).equals(")")) {
                    String format = it.next();
                    Setting ing = new Setting(Long.parseLong(bits), format);
                    settings.add(ing);
                }
                this.cases.put(field, settings);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof Mode) {
                Mode m = (Mode)o;
                return this.name.equals(m.name) && this.commandFluff == m.commandFluff && this.prompt.equals(m.prompt) && this.continuationPrompt.equals(m.continuationPrompt) && this.cases.equals(m.cases);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        void setCommandFluff(boolean fluff) {
            this.commandFluff = fluff;
        }

        String encode() {
            ArrayList<String> el = new ArrayList<String>();
            el.add(this.name);
            el.add(String.valueOf(this.commandFluff));
            el.add(this.prompt);
            el.add(this.continuationPrompt);
            for (Map.Entry<String, List<Setting>> es : this.cases.entrySet()) {
                el.add(es.getKey());
                el.add("(");
                for (Setting ing : es.getValue()) {
                    el.add(String.valueOf(ing.enumBits));
                    el.add(ing.format);
                }
                el.add(")");
            }
            el.add("***");
            return String.join((CharSequence)Feedback.RECORD_SEPARATOR, el);
        }

        private void add(String field, Setting ing) {
            List<Setting> settings = this.cases.get(field);
            if (settings == null) {
                settings = new ArrayList<Setting>();
                this.cases.put(field, settings);
            } else {
                long mask = ing.enumBits ^ 0xFFFFFFFFFFFFFFFFL;
                settings.removeIf(t -> (t.enumBits & mask) == 0L);
            }
            settings.add(ing);
        }

        void set(String field, Collection<FormatCase> cc, Collection<FormatAction> ca, Collection<FormatWhen> cw, Collection<FormatResolve> cr, Collection<FormatUnresolved> cu, Collection<FormatErrors> ce, String format) {
            long bits = Feedback.bits(cc, ca, cw, cr, cu, ce);
            this.set(field, bits, format);
        }

        void set(String field, long bits, String format) {
            this.add(field, new Setting(bits, format));
        }

        String format(String field, long bits) {
            List<Setting> settings = this.cases.get(field);
            if (settings == null) {
                return "";
            }
            String format = null;
            for (int i = settings.size() - 1; i >= 0; --i) {
                Setting ing = settings.get(i);
                long mask = ing.enumBits;
                if ((bits & mask) != bits) continue;
                format = ing.format;
                break;
            }
            if (format == null || format.isEmpty()) {
                return "";
            }
            Matcher m = FIELD_PATTERN.matcher(format);
            StringBuffer sb = new StringBuffer(format.length());
            while (m.find()) {
                String fieldName = m.group(1);
                String sub = this.format(fieldName, bits);
                m.appendReplacement(sb, Matcher.quoteReplacement(sub));
            }
            m.appendTail(sb);
            return sb.toString();
        }

        String format(FormatCase fc, FormatAction fa, FormatWhen fw, FormatResolve fr, FormatUnresolved fu, FormatErrors fe, String name, String type, String value, String unresolved, List<String> errorLines) {
            String fvalue;
            String ftype;
            long bits = Feedback.bits(fc, fa, fw, fr, fu, fe);
            String fname = name == null ? "" : name;
            String string = ftype = type == null ? "" : type;
            if (value == null) {
                fvalue = "";
            } else {
                String truncField = this.format(Feedback.TRUNCATION_FIELD, bits);
                if (truncField.isEmpty()) {
                    fvalue = value;
                } else {
                    int trunc = Integer.parseUnsignedInt(truncField);
                    fvalue = value.length() > trunc ? (trunc <= 5 ? value.substring(0, trunc) : value.substring(0, trunc - 4) + " ...") : value;
                }
            }
            String funresolved = unresolved == null ? "" : unresolved;
            String errors = errorLines.stream().map(el -> String.format(this.format("errorline", bits), fname, ftype, fvalue, funresolved, "*cannot-use-errors-here*", el)).collect(Collectors.joining());
            return String.format(this.format("display", bits), fname, ftype, fvalue, funresolved, errors, "*cannot-use-err-here*");
        }

        void setPrompts(String prompt, String continuationPrompt) {
            this.prompt = prompt;
            this.continuationPrompt = continuationPrompt;
        }

        String getPrompt(String nextId) {
            return String.format(this.prompt, nextId);
        }

        String getContinuationPrompt(String nextId) {
            return String.format(this.continuationPrompt, nextId);
        }

        static class Setting {
            final long enumBits;
            final String format;

            Setting(long enumBits, String format) {
                this.enumBits = enumBits;
                this.format = format;
            }

            public boolean equals(Object o) {
                if (o instanceof Setting) {
                    Setting ing = (Setting)o;
                    return this.enumBits == ing.enumBits && this.format.equals(ing.format);
                }
                return false;
            }

            public int hashCode() {
                int hash = 7;
                hash = 67 * hash + (int)(this.enumBits ^ this.enumBits >>> 32);
                hash = 67 * hash + Objects.hashCode(this.format);
                return hash;
            }
        }
    }

    private static class SelectorSets {
        Set<FormatCase> cc;
        Set<FormatAction> ca;
        Set<FormatWhen> cw;
        Set<FormatResolve> cr;
        Set<FormatUnresolved> cu;
        Set<FormatErrors> ce;

        private SelectorSets() {
        }
    }
}

