/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCISessionInitiator;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class OCIChildFactory
extends ChildFactory<OCIItem> {
    private static final Logger LOG = Logger.getLogger(OCIChildFactory.class.getName());
    private final OCIItem parent;
    private final OCISessionInitiator session;

    public OCIChildFactory(OCIItem parent) {
        this.parent = parent;
        this.session = OCIManager.getDefault().getActiveSession();
    }

    public OCIChildFactory(OCIItem parent, OCISessionInitiator session) {
        this.parent = parent;
        this.session = session;
    }

    protected boolean createKeys(List<OCIItem> toPopulate) {
        Lookup.Result lkpResult = Lookups.forPath((String)String.format("Cloud/Oracle/%s/Nodes", this.parent.getKey().getPath())).lookupResult(ChildrenProvider.class);
        lkpResult.allItems().parallelStream().forEach(it -> {
            try {
                ChildrenProvider kp = (ChildrenProvider)it.getInstance();
                if (kp instanceof ChildrenProvider.SessionAware) {
                    toPopulate.addAll(((ChildrenProvider.SessionAware)kp).apply(this.parent, this.session));
                } else {
                    toPopulate.addAll(kp.apply(this.parent));
                }
            }
            catch (RuntimeException ex) {
                LOG.log(Level.WARNING, "Error fetching children for {0}/{1}", new Object[]{this.parent.getKey(), it.getId()});
            }
        });
        return true;
    }

    protected Node[] createNodesForKey(OCIItem key) {
        NodeProvider nodeProvider = (NodeProvider)Lookups.forPath((String)String.format("Cloud/%s/Nodes", key.getKey().getPath())).lookup(NodeProvider.class);
        return new Node[]{nodeProvider.apply(key)};
    }

    public void refreshKeys() {
        this.refresh(false);
    }
}

