/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.externalfinder.item;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.omegat.externalfinder.item.ExternalFinderConfiguration;
import org.omegat.externalfinder.item.ExternalFinderItem;
import org.omegat.externalfinder.item.ExternalFinderItemCommand;
import org.omegat.externalfinder.item.ExternalFinderItemURL;
import org.omegat.externalfinder.item.ExternalFinderValidationException;
import org.omegat.externalfinder.item.IExternalFinderItemLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExternalFinderXMLLoader
implements IExternalFinderItemLoader {
    private static final Logger LOGGER = Logger.getLogger(ExternalFinderXMLLoader.class.getName());
    private final File file;
    private final ExternalFinderItem.SCOPE scope;

    public ExternalFinderXMLLoader(File file, ExternalFinderItem.SCOPE scope) {
        this.file = Objects.requireNonNull(file);
        this.scope = scope;
    }

    @Override
    public ExternalFinderConfiguration load() throws Exception {
        ArrayList<ExternalFinderItem> finderItems = new ArrayList<ExternalFinderItem>();
        int priority = -1;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(this.file);
        NodeList nodeList = document.getElementsByTagName("item");
        if (nodeList == null) {
            return ExternalFinderConfiguration.empty();
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            try {
                finderItems.add(this.generateFinderItem(nodeList.item(i)));
                continue;
            }
            catch (ExternalFinderValidationException ex) {
                LOGGER.warning("ExternalFinder: " + ex.getMessage());
            }
        }
        priority = ExternalFinderXMLLoader.retrivePriority(document, priority);
        return new ExternalFinderConfiguration(priority, finderItems);
    }

    private static int retrivePriority(Document document, int defaultPriority) {
        int priority = defaultPriority;
        NodeList items = document.getElementsByTagName("items");
        if (items == null || items.getLength() != 1) {
            return priority;
        }
        Node item = items.item(0);
        if (!item.hasAttributes()) {
            return priority;
        }
        Node namedItem = item.getAttributes().getNamedItem("priority");
        if (namedItem == null) {
            return priority;
        }
        String value = namedItem.getTextContent();
        try {
            priority = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return priority;
    }

    private ExternalFinderItem generateFinderItem(Node item) {
        String value;
        Node nopopup;
        if (!item.hasChildNodes()) {
            return null;
        }
        NodeList childNodes = item.getChildNodes();
        ExternalFinderItem.Builder builder = new ExternalFinderItem.Builder();
        builder.setScope(this.scope);
        if (item.hasAttributes() && (nopopup = item.getAttributes().getNamedItem("nopopup")) != null && (value = nopopup.getTextContent()).equals("true")) {
            builder.setNopopup(true);
        }
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("name")) {
                builder.setName(childNode.getTextContent());
                continue;
            }
            if (nodeName.equals("url")) {
                try {
                    builder.addURL(ExternalFinderXMLLoader.generateFinderURL(childNode));
                }
                catch (ExternalFinderValidationException ex) {
                    LOGGER.warning("ExternalFinder: " + ex.getMessage());
                }
                continue;
            }
            if (nodeName.equals("command")) {
                try {
                    builder.addCommand(ExternalFinderXMLLoader.generateFinderCommand(childNode));
                }
                catch (ExternalFinderValidationException ex) {
                    LOGGER.warning("ExternalFinder: " + ex.getMessage());
                }
                continue;
            }
            if (!nodeName.equals("keystroke")) continue;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(childNode.getTextContent());
            builder.setKeyStroke(keyStroke);
        }
        return builder.build();
    }

    private static ExternalFinderItemURL generateFinderURL(Node urlNode) {
        ExternalFinderItemURL.Builder builder = new ExternalFinderItemURL.Builder();
        builder.setURL(urlNode.getTextContent());
        if (urlNode.hasAttributes()) {
            Node eAttribute;
            Node tAttribute = urlNode.getAttributes().getNamedItem("target");
            if (tAttribute != null) {
                String targetAttribute = tAttribute.getTextContent().toLowerCase(Locale.ENGLISH);
                if (targetAttribute.equals("ascii_only")) {
                    builder.setTarget(ExternalFinderItem.TARGET.ASCII_ONLY);
                } else if (targetAttribute.equals("non_ascii_only")) {
                    builder.setTarget(ExternalFinderItem.TARGET.NON_ASCII_ONLY);
                }
            }
            if ((eAttribute = urlNode.getAttributes().getNamedItem("encoding")) != null) {
                String encodingAttribute = eAttribute.getTextContent().toLowerCase(Locale.ENGLISH);
                if (encodingAttribute.equals("escape")) {
                    builder.setEncoding(ExternalFinderItem.ENCODING.ESCAPE);
                } else if (encodingAttribute.equals("none")) {
                    builder.setEncoding(ExternalFinderItem.ENCODING.NONE);
                }
            }
        }
        return builder.build();
    }

    private static ExternalFinderItemCommand generateFinderCommand(Node commandNode) {
        ExternalFinderItemCommand.Builder builder = new ExternalFinderItemCommand.Builder();
        builder.setCommand(commandNode.getTextContent());
        if (commandNode.hasAttributes()) {
            Node dAttribute;
            Node eAttribute;
            Node tAttribute = commandNode.getAttributes().getNamedItem("target");
            if (tAttribute != null) {
                String targetAttribute = tAttribute.getTextContent().toLowerCase(Locale.ENGLISH);
                if (targetAttribute.equals("ascii_only")) {
                    builder.setTarget(ExternalFinderItem.TARGET.ASCII_ONLY);
                } else if (targetAttribute.equals("non_ascii_only")) {
                    builder.setTarget(ExternalFinderItem.TARGET.NON_ASCII_ONLY);
                }
            }
            if ((eAttribute = commandNode.getAttributes().getNamedItem("encoding")) != null) {
                String encodingAttribute = eAttribute.getTextContent().toLowerCase(Locale.ENGLISH);
                if (encodingAttribute.equals("default")) {
                    builder.setEncoding(ExternalFinderItem.ENCODING.DEFAULT);
                } else if (encodingAttribute.equals("escape")) {
                    builder.setEncoding(ExternalFinderItem.ENCODING.ESCAPE);
                }
            }
            if ((dAttribute = commandNode.getAttributes().getNamedItem("delimiter")) != null) {
                builder.setDelimiter(dAttribute.getTextContent());
            }
        }
        return builder.build();
    }
}

