/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.chartable;

import java.awt.Font;
import java.awt.Point;
import javax.swing.table.AbstractTableModel;

public class CharTableModel
extends AbstractTableModel {
    Font font;
    int columnCount = 16;
    int glyphCount = 65503;
    StringBuilder data = null;

    public CharTableModel(String data) {
        this.setData(data);
    }

    public boolean setData(String data) {
        if (this.data == null && data == null) {
            return false;
        }
        if (data != null && this.data != null && this.data.toString().equals(data)) {
            return false;
        }
        if (data == null) {
            this.glyphCount = 4063;
            this.data = null;
        } else {
            this.glyphCount = data.length();
            this.data = new StringBuilder(data);
        }
        this.fireTableDataChanged();
        return true;
    }

    public String getData() {
        return this.data.toString();
    }

    public void allowOnlyUnique() {
        if (this.data == null) {
            return;
        }
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < this.data.length(); ++i) {
            if (temp.indexOf(this.data.substring(i, i + 1)) != -1) continue;
            temp.append(this.data.substring(i, i + 1));
        }
        this.data = new StringBuilder(temp);
        this.glyphCount = this.data.length();
        this.fireTableDataChanged();
    }

    public void appendChar(Character c, boolean checkUnique) {
        char cv = c.charValue();
        if (checkUnique) {
            for (int i = 0; i < this.data.length(); ++i) {
                if (this.data.charAt(i) != cv) continue;
                return;
            }
        }
        this.data.append(cv);
        ++this.glyphCount;
        this.fireTableDataChanged();
    }

    public void removeSelection(int row1, int col1, int row2, int col2) {
        if (this.data.length() == 0) {
            return;
        }
        int pos1 = row1 * this.getColumnCount() + col1;
        pos1 = pos1 >= this.data.length() ? this.data.length() - 1 : pos1;
        int pos2 = row2 * this.getColumnCount() + col2;
        pos2 = pos2 >= this.data.length() ? this.data.length() - 1 : pos2;
        pos2 = pos2 == pos1 ? pos1 + 1 : pos2;
        this.data.delete(pos1, pos2);
        this.glyphCount = this.data.length();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.glyphCount / this.columnCount + (this.glyphCount % this.columnCount > 0 ? 1 : 0);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int value = rowIndex * this.columnCount + columnIndex;
        if (value < this.glyphCount) {
            if (this.data != null) {
                return Character.valueOf(this.data.charAt(value));
            }
            return Character.valueOf((char)(value + 32));
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return "";
    }

    public Point modifyPoint(Point p) {
        if (p.y * this.columnCount + p.x >= this.glyphCount) {
            int g = this.glyphCount == 0 ? 0 : this.glyphCount - 1;
            return new Point(g % this.columnCount, g / this.columnCount);
        }
        return p;
    }
}

