/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.LinkedList;
import org.omegat.util.PatternConsts;

public class WordIterator
extends BreakIterator {
    BreakIterator breaker;
    String text;
    LinkedList<Integer> nextItems = new LinkedList();

    public WordIterator() {
        this.breaker = BreakIterator.getWordInstance();
    }

    @Override
    public void setText(String newText) {
        this.text = newText;
        this.breaker.setText(newText);
        this.nextItems.clear();
    }

    @Override
    public int first() {
        return this.breaker.first();
    }

    @Override
    public int current() {
        return this.breaker.current();
    }

    @Override
    public int next() {
        if (!this.nextItems.isEmpty()) {
            return this.nextItems.removeFirst();
        }
        int curr = this.current();
        int next = this.breaker.next();
        if (-1 == next) {
            return -1;
        }
        String str = this.text.substring(curr, next);
        if (str.equals("<")) {
            int next2 = this.breaker.next();
            if (-1 == next2) {
                return next;
            }
            int next3 = this.breaker.next();
            if (-1 == next3) {
                this.nextItems.add(next2);
                return next;
            }
            String str2 = this.text.substring(next, next2);
            String str3 = this.text.substring(next2, next3);
            if (str2.equals("/")) {
                if (!PatternConsts.OMEGAT_TAG_ONLY.matcher(str3).matches()) {
                    this.breaker.previous();
                    this.breaker.previous();
                    return next;
                }
                int next4 = this.breaker.next();
                if (-1 == next4) {
                    this.nextItems.add(next2);
                    this.nextItems.add(next3);
                    return next;
                }
                String str4 = this.text.substring(next3, next4);
                if (str4.equals(">")) {
                    return next4;
                }
                this.breaker.previous();
                this.breaker.previous();
                this.breaker.previous();
                return next;
            }
            if (!PatternConsts.OMEGAT_TAG_ONLY.matcher(str2).matches()) {
                this.breaker.previous();
                this.breaker.previous();
                return next;
            }
            if (str3.equals("/")) {
                int next4 = this.breaker.next();
                if (-1 == next4) {
                    this.nextItems.add(next2);
                    this.nextItems.add(next3);
                    return next;
                }
                String str4 = this.text.substring(next3, next4);
                if (str4.equals(">")) {
                    return next4;
                }
                this.breaker.previous();
                this.breaker.previous();
                this.breaker.previous();
                return next;
            }
            if (str3.equals(">")) {
                return next3;
            }
            this.breaker.previous();
            this.breaker.previous();
            return next;
        }
        if (str.equals("&")) {
            int next2 = this.breaker.next();
            if (-1 == next2) {
                return next;
            }
            String str2 = this.text.substring(next, next2);
            if (Character.isLetterOrDigit(str2.codePointAt(0))) {
                return next2;
            }
            this.breaker.previous();
            return next;
        }
        if (Character.isLetterOrDigit(str.codePointAt(0))) {
            int next2 = this.breaker.next();
            if (-1 == next2) {
                return next;
            }
            String str2 = this.text.substring(next, next2);
            if (str2.equals("&")) {
                int next3 = this.breaker.next();
                if (-1 == next3) {
                    this.nextItems.add(next2);
                    return next;
                }
                String str3 = this.text.substring(next2, next3);
                if (Character.isLetterOrDigit(str3.codePointAt(0))) {
                    return next3;
                }
                this.breaker.previous();
                this.breaker.previous();
                return next;
            }
            this.breaker.previous();
            return next;
        }
        return next;
    }

    @Override
    public int next(int n) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public int following(int offset) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void setText(CharacterIterator newText) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public CharacterIterator getText() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public int previous() {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public int last() {
        throw new RuntimeException("Not Implemented");
    }
}

