/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;

final class DocumentsWriterDeleteQueue
implements Accountable {
    private volatile Node<?> tail;
    private static final AtomicReferenceFieldUpdater<DocumentsWriterDeleteQueue, Node> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(DocumentsWriterDeleteQueue.class, Node.class, "tail");
    private final DeleteSlice globalSlice;
    private final BufferedUpdates globalBufferedUpdates;
    private final ReentrantLock globalBufferLock = new ReentrantLock();
    final long generation;

    DocumentsWriterDeleteQueue() {
        this(0L);
    }

    DocumentsWriterDeleteQueue(long generation) {
        this(new BufferedUpdates(), generation);
    }

    DocumentsWriterDeleteQueue(BufferedUpdates globalBufferedUpdates, long generation) {
        this.globalBufferedUpdates = globalBufferedUpdates;
        this.generation = generation;
        this.tail = new Node<Object>(null);
        this.globalSlice = new DeleteSlice(this.tail);
    }

    void addDelete(Query ... queries) {
        this.add(new QueryArrayNode(queries));
        this.tryApplyGlobalSlice();
    }

    void addDelete(Term ... terms) {
        this.add(new TermArrayNode(terms));
        this.tryApplyGlobalSlice();
    }

    void addDocValuesUpdates(DocValuesUpdate ... updates) {
        this.add(new DocValuesUpdatesNode(updates));
        this.tryApplyGlobalSlice();
    }

    void add(Term term, DeleteSlice slice) {
        TermNode termNode = new TermNode(term);
        this.add(termNode);
        slice.sliceTail = termNode;
        assert (slice.sliceHead != slice.sliceTail) : "slice head and tail must differ after add";
        this.tryApplyGlobalSlice();
    }

    void add(Node<?> item) {
        Node<?> currentTail;
        while (true) {
            currentTail = this.tail;
            Node<?> tailNext = currentTail.next;
            if (this.tail != currentTail) continue;
            if (tailNext != null) {
                tailUpdater.compareAndSet(this, currentTail, tailNext);
                continue;
            }
            if (currentTail.casNext(null, item)) break;
        }
        tailUpdater.compareAndSet(this, currentTail, item);
    }

    boolean anyChanges() {
        this.globalBufferLock.lock();
        try {
            boolean bl = this.globalBufferedUpdates.any() || !this.globalSlice.isEmpty() || this.globalSlice.sliceTail != this.tail || this.tail.next != null;
            return bl;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    void tryApplyGlobalSlice() {
        if (this.globalBufferLock.tryLock()) {
            try {
                if (this.updateSlice(this.globalSlice)) {
                    this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
                }
            }
            finally {
                this.globalBufferLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FrozenBufferedUpdates freezeGlobalBuffer(DeleteSlice callerSlice) {
        this.globalBufferLock.lock();
        Node<?> currentTail = this.tail;
        if (callerSlice != null) {
            callerSlice.sliceTail = currentTail;
        }
        try {
            if (this.globalSlice.sliceTail != currentTail) {
                this.globalSlice.sliceTail = currentTail;
                this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
            }
            FrozenBufferedUpdates packet = new FrozenBufferedUpdates(this.globalBufferedUpdates, false);
            this.globalBufferedUpdates.clear();
            FrozenBufferedUpdates frozenBufferedUpdates = packet;
            return frozenBufferedUpdates;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    DeleteSlice newSlice() {
        return new DeleteSlice(this.tail);
    }

    boolean updateSlice(DeleteSlice slice) {
        if (slice.sliceTail != this.tail) {
            slice.sliceTail = this.tail;
            return true;
        }
        return false;
    }

    public int numGlobalTermDeletes() {
        return this.globalBufferedUpdates.numTermDeletes.get();
    }

    void clear() {
        this.globalBufferLock.lock();
        try {
            Node<?> currentTail = this.tail;
            this.globalSlice.sliceTail = currentTail;
            this.globalSlice.sliceHead = this.globalSlice.sliceTail;
            this.globalBufferedUpdates.clear();
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    private boolean forceApplyGlobalSlice() {
        this.globalBufferLock.lock();
        Node<?> currentTail = this.tail;
        try {
            if (this.globalSlice.sliceTail != currentTail) {
                this.globalSlice.sliceTail = currentTail;
                this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
            }
            boolean bl = this.globalBufferedUpdates.any();
            return bl;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    public int getBufferedUpdatesTermsSize() {
        this.globalBufferLock.lock();
        try {
            this.forceApplyGlobalSlice();
            int n = this.globalBufferedUpdates.terms.size();
            return n;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.globalBufferedUpdates.bytesUsed.get();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return "DWDQ: [ generation: " + this.generation + " ]";
    }

    private static final class DocValuesUpdatesNode
    extends Node<DocValuesUpdate[]> {
        DocValuesUpdatesNode(DocValuesUpdate ... updates) {
            super(updates);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int docIDUpto) {
            block4: for (DocValuesUpdate update : (DocValuesUpdate[])this.item) {
                switch (update.type) {
                    case NUMERIC: {
                        bufferedUpdates.addNumericUpdate(new DocValuesUpdate.NumericDocValuesUpdate(update.term, update.field, (Long)update.value), docIDUpto);
                        continue block4;
                    }
                    case BINARY: {
                        bufferedUpdates.addBinaryUpdate(new DocValuesUpdate.BinaryDocValuesUpdate(update.term, update.field, (BytesRef)update.value), docIDUpto);
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException((Object)((Object)update.type) + " DocValues updates not supported yet!");
                    }
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("docValuesUpdates: ");
            if (((DocValuesUpdate[])this.item).length > 0) {
                sb.append("term=").append(((DocValuesUpdate[])this.item)[0].term).append("; updates: [");
                for (DocValuesUpdate update : (DocValuesUpdate[])this.item) {
                    sb.append(update.field).append(':').append(update.value).append(',');
                }
                sb.setCharAt(sb.length() - 1, ']');
            }
            return sb.toString();
        }
    }

    private static final class TermArrayNode
    extends Node<Term[]> {
        TermArrayNode(Term[] term) {
            super(term);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int docIDUpto) {
            for (Term term : (Term[])this.item) {
                bufferedUpdates.addTerm(term, docIDUpto);
            }
        }

        public String toString() {
            return "dels=" + Arrays.toString((Object[])this.item);
        }
    }

    private static final class QueryArrayNode
    extends Node<Query[]> {
        QueryArrayNode(Query[] query) {
            super(query);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int docIDUpto) {
            for (Query query : (Query[])this.item) {
                bufferedUpdates.addQuery(query, docIDUpto);
            }
        }
    }

    private static final class TermNode
    extends Node<Term> {
        TermNode(Term term) {
            super(term);
        }

        @Override
        void apply(BufferedUpdates bufferedDeletes, int docIDUpto) {
            bufferedDeletes.addTerm((Term)this.item, docIDUpto);
        }

        public String toString() {
            return "del=" + this.item;
        }
    }

    private static class Node<T> {
        volatile Node<?> next;
        final T item;
        static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");

        Node(T item) {
            this.item = item;
        }

        void apply(BufferedUpdates bufferedDeletes, int docIDUpto) {
            throw new IllegalStateException("sentinel item must never be applied");
        }

        boolean casNext(Node<?> cmp, Node<?> val) {
            return nextUpdater.compareAndSet(this, cmp, val);
        }
    }

    static class DeleteSlice {
        Node<?> sliceHead;
        Node<?> sliceTail;

        DeleteSlice(Node<?> currentTail) {
            assert (currentTail != null);
            this.sliceTail = currentTail;
            this.sliceHead = this.sliceTail;
        }

        void apply(BufferedUpdates del, int docIDUpto) {
            if (this.sliceHead == this.sliceTail) {
                return;
            }
            Node<?> current = this.sliceHead;
            do {
                current = current.next;
                assert (current != null) : "slice property violated between the head on the tail must not be a null node";
                current.apply(del, docIDUpto);
            } while (current != this.sliceTail);
            this.reset();
        }

        void reset() {
            this.sliceHead = this.sliceTail;
        }

        boolean isTailItem(Object item) {
            return this.sliceTail.item == item;
        }

        boolean isEmpty() {
            return this.sliceHead == this.sliceTail;
        }
    }
}

