/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.model.translation;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import net.loomchild.maligna.model.translation.EmptySourceData;
import net.loomchild.maligna.model.translation.MutableSourceData;
import net.loomchild.maligna.model.translation.SourceData;
import net.loomchild.maligna.model.translation.TargetData;
import net.loomchild.maligna.model.translation.TranslationModel;
import net.loomchild.maligna.model.vocabulary.Vocabulary;

public class MutableTranslationModel
implements TranslationModel {
    ArrayList<MutableSourceData> translationArray = new ArrayList();

    @Override
    public SourceData get(int sourceWid) {
        assert (sourceWid >= 0);
        if (sourceWid < this.translationArray.size()) {
            return this.translationArray.get(sourceWid);
        }
        return new EmptySourceData();
    }

    public MutableSourceData getMutable(int sourceWid) {
        assert (sourceWid >= 0);
        this.ensureSize(sourceWid + 1);
        return this.translationArray.get(sourceWid);
    }

    public void normalize() {
        for (MutableSourceData data : this.translationArray) {
            data.normalize();
        }
    }

    public void sort() {
        for (MutableSourceData data : this.translationArray) {
            data.sort();
        }
    }

    private void ensureSize(int size) {
        int currentSize = this.translationArray.size();
        if (size > currentSize) {
            this.translationArray.ensureCapacity(size);
            for (int i = currentSize; i < size; ++i) {
                this.translationArray.add(new MutableSourceData());
            }
        }
    }

    @Override
    public void format(Writer writer, Vocabulary sourceVocabulary, Vocabulary targetVocabulary) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        for (int i = 0; i < this.translationArray.size(); ++i) {
            MutableSourceData sourceData = this.translationArray.get(i);
            for (TargetData targetData : sourceData.getTranslationList()) {
                printWriter.println(sourceVocabulary.getWord(i) + "\t" + targetVocabulary.getWord(targetData.getWid()) + "\t" + targetData.getProbability());
            }
        }
    }
}

