/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNRevisionProperty;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.IOExceptionWrapper;
import org.tmatesoft.svn.core.internal.wc.ISVNFileContentFetcher;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc2.ISvnAddParameters;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.hooks.ISvnPropertyValueProvider;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgPropertiesManager {
    public static Collection<String> getGlobalIgnores(ISVNOptions options) {
        HashSet<String> allPatterns = new HashSet<String>();
        String[] ignores = options.getIgnorePatterns();
        for (int i = 0; ignores != null && i < ignores.length; ++i) {
            allPatterns.add(ignores[i]);
        }
        return allPatterns;
    }

    public static Collection<String> getEffectiveIgnores(SVNWCContext context, File absPath, Collection<String> globalIgnores) {
        HashSet<String> allPatterns = new HashSet<String>();
        if (globalIgnores != null) {
            allPatterns.addAll(globalIgnores);
        } else {
            allPatterns.addAll(SvnNgPropertiesManager.getGlobalIgnores(context.getOptions()));
        }
        if (context != null && absPath != null) {
            try {
                String token;
                StringTokenizer tokens;
                String ignoreProperty = context.getProperty(absPath, "svn:ignore");
                if (ignoreProperty != null) {
                    tokens = new StringTokenizer(ignoreProperty, "\r\n");
                    while (tokens.hasMoreTokens()) {
                        token = tokens.nextToken().trim();
                        if (token.length() <= 0) continue;
                        allPatterns.add(token);
                    }
                }
                if ((ignoreProperty = context.getProperty(absPath, "svn:global-ignores")) != null) {
                    tokens = new StringTokenizer(ignoreProperty, "\r\n");
                    while (tokens.hasMoreTokens()) {
                        token = tokens.nextToken().trim();
                        if (token.length() <= 0) continue;
                        allPatterns.add(token);
                    }
                }
                SVNWCDb db = (SVNWCDb)context.getDb();
                SVNWCDb.DirParsedInfo parsed = db.parseDir(absPath, SVNSqlJetDb.Mode.ReadOnly);
                List<Structure<StructureFields.InheritedProperties>> inheritedProperties = SvnWcDbProperties.readInheritedProperties(parsed.wcDbDir.getWCRoot(), parsed.localRelPath, "svn:global-ignores");
                for (Structure<StructureFields.InheritedProperties> inheritedProperty : inheritedProperties) {
                    SVNProperties properties = (SVNProperties)inheritedProperty.get(StructureFields.InheritedProperties.properties);
                    String path = (String)inheritedProperty.get(StructureFields.InheritedProperties.pathOrURL);
                    ignoreProperty = properties.getStringValue("svn:global-ignores");
                    if (ignoreProperty == null) continue;
                    StringTokenizer tokens2 = new StringTokenizer(ignoreProperty, "\r\n");
                    while (tokens2.hasMoreTokens()) {
                        String token2 = tokens2.nextToken().trim();
                        if (token2.length() <= 0) continue;
                        allPatterns.add(token2);
                    }
                }
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
        return allPatterns;
    }

    public static boolean isIgnored(String name, Collection<String> patterns) {
        if (patterns == null) {
            return false;
        }
        for (String pattern : patterns) {
            if (!DefaultSVNOptions.matches(pattern, name)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Map<String, String>> parseAutoProperties(SVNPropertyValue autoProperties, Map<String, Map<String, String>> target) {
        String[] lines;
        String autoPropertiesString = SVNPropertyValue.getPropertyAsString(autoProperties);
        HashMap<String, Map<String, String>> hashMap = target = target == null ? new HashMap<String, Map<String, String>>() : target;
        if (autoPropertiesString == null) {
            return target;
        }
        for (String line : lines = autoPropertiesString.split("\n")) {
            String[] keyValuePairs;
            int pos;
            if ((line = line.trim()).length() == 0 || (pos = line.indexOf(61)) < 0) continue;
            String pattern = line.substring(0, pos).trim();
            String keyValuePairsString = line.substring(pos + 1).trim();
            HashMap<String, String> properties = (HashMap<String, String>)target.get(pattern);
            if (properties == null) {
                properties = new HashMap<String, String>();
                target.put(pattern, properties);
            }
            for (String keyValuePair : keyValuePairs = keyValuePairsString.split(";")) {
                String propertyValue;
                String propertyName;
                if ((keyValuePair = keyValuePair.trim()).length() == 0) continue;
                pos = keyValuePair.indexOf(61);
                if (pos < 0) {
                    propertyName = keyValuePair.trim();
                    propertyValue = "*";
                } else {
                    propertyName = keyValuePair.substring(0, pos).trim();
                    propertyValue = keyValuePair.substring(pos + 1).trim();
                }
                properties.put(propertyName, propertyValue);
            }
        }
        return target;
    }

    public static Map<String, String> getMatchedAutoProperties(String fileName, Map<String, Map<String, String>> autoProperties) {
        if (autoProperties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> matchedAutoProperties = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, String>> entry : autoProperties.entrySet()) {
            String pattern = entry.getKey();
            if (!DefaultSVNOptions.matches(pattern, fileName)) continue;
            Map<String, String> properties = entry.getValue();
            matchedAutoProperties.putAll(properties);
        }
        return matchedAutoProperties;
    }

    public static void setProperty(SVNWCContext context, File path, String propertyName, SVNPropertyValue propertyValue, SVNDepth depth, boolean skipChecks, ISVNEventHandler eventHandler, Collection<String> changelists) throws SVNException {
        SvnNgPropertiesManager.setProperty(context, path, propertyName, propertyValue, null, depth, skipChecks, eventHandler, null, changelists);
    }

    public static void setProperty(SVNWCContext context, File path, String propertyName, SVNPropertyValue propertyValue, SVNDepth depth, boolean skipChecks, ISVNEventHandler eventHandler, ISvnObjectReceiver<SVNPropertyData> receiver, Collection<String> changelists) throws SVNException {
        SvnNgPropertiesManager.setProperty(context, path, propertyName, propertyValue, null, depth, skipChecks, eventHandler, receiver, changelists);
    }

    public static void setProperty(final SVNWCContext context, File path, final String propertyName, final SVNPropertyValue propertyValue, final ISvnPropertyValueProvider pvProvider, SVNDepth depth, final boolean skipChecks, final ISVNEventHandler eventHandler, final ISvnObjectReceiver<SVNPropertyData> receiver, Collection<String> changelists) throws SVNException {
        SVNNodeKind kind;
        if (propertyName != null) {
            if (SVNProperty.isEntryProperty(propertyName)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_PROP_KIND, "Property ''{0}'' is an entry property", (Object)propertyName);
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if (SVNProperty.isWorkingCopyProperty(propertyName)) {
                SVNProperties wcProps = context.getDb().getBaseDavCache(path);
                if (wcProps == null && propertyValue != null) {
                    wcProps = new SVNProperties();
                }
                if (wcProps != null) {
                    if (propertyValue != null) {
                        wcProps.put(propertyName, propertyValue);
                    } else {
                        wcProps.remove(propertyName);
                    }
                }
                context.getDb().setBaseDavCache(path, wcProps);
                return;
            }
        }
        File dirPath = (kind = context.readKind(path, true)) == SVNNodeKind.DIR ? path : SVNFileUtil.getParentFile(path);
        context.writeCheck(dirPath);
        if (depth == SVNDepth.EMPTY) {
            if (!context.matchesChangelist(path, changelists)) {
                return;
            }
            SvnNgPropertiesManager.setProperty(context, path, kind, propertyName, propertyValue, pvProvider, skipChecks, eventHandler, receiver);
        } else {
            context.nodeWalkChildren(path, new SVNWCContext.ISVNWCNodeHandler(){

                @Override
                public void nodeFound(File localAbspath, ISVNWCDb.SVNWCDbKind kind) throws SVNException {
                    try {
                        SvnNgPropertiesManager.setProperty(context, localAbspath, kind.toNodeKind(), propertyName, propertyValue, pvProvider, skipChecks, eventHandler, receiver);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_INVALID_SCHEDULE) {
                            return;
                        }
                        throw e;
                    }
                }
            }, false, depth, changelists);
        }
    }

    public static void setProperty(final SVNWCContext context, final File path, SVNNodeKind kind, String propertyName, SVNPropertyValue value, ISvnPropertyValueProvider pvProvider, boolean skipChecks, ISVNEventHandler eventHandler, ISvnObjectReceiver<SVNPropertyData> receiver) throws SVNException {
        SVNEventAction action;
        String oldValue;
        Structure<StructureFields.NodeInfo> nodeInfo = context.getDb().readInfo(path, StructureFields.NodeInfo.status);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
        if (status != ISVNWCDb.SVNWCDbStatus.Normal && status != ISVNWCDb.SVNWCDbStatus.Added && status != ISVNWCDb.SVNWCDbStatus.Incomplete) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SCHEDULE, "Can''t set properties on ''{0}'': invalid status for updating properties.", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (pvProvider == null && value != null && SVNProperty.isSVNProperty(propertyName)) {
            SVNPropertyValue pv;
            ISVNFileContentFetcher fetcher = new ISVNFileContentFetcher(){

                @Override
                public SVNPropertyValue getProperty(String propertyName) throws SVNException {
                    return context.getPropertyValue(path, propertyName);
                }

                @Override
                public boolean fileIsBinary() throws SVNException {
                    SVNPropertyValue mimeType = context.getPropertyValue(path, "svn:mime-type");
                    return mimeType != null && SVNProperty.isBinaryMimeType(mimeType.getString());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void fetchFileContent(OutputStream os) throws SVNException {
                    InputStream is = null;
                    try {
                        is = SVNFileUtil.openFileForReading(path);
                        SVNTranslator.copy(is, os);
                    }
                    catch (IOExceptionWrapper ioew) {
                        throw ioew.getOriginalException();
                    }
                    catch (IOException e) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    finally {
                        SVNFileUtil.closeFile(is);
                    }
                }
            };
            value = pv = SVNPropertiesManager.validatePropertyValue(path, kind, propertyName, value, skipChecks, context.getOptions(), fetcher);
        }
        SVNSkel workItems = null;
        if (pvProvider == null && kind == SVNNodeKind.FILE && ("svn:executable".equals(propertyName) || "svn:needs-lock".equals(propertyName))) {
            workItems = context.wqBuildSyncFileFlags(path);
        }
        SVNProperties properties = new SVNProperties();
        try {
            properties = context.getDb().readProperties(path);
        }
        catch (SVNException e) {
            SVNErrorMessage err = e.getErrorMessage().wrap("Failed to load current properties");
            SVNErrorManager.error(err, e, SVNLogType.WC);
        }
        if (pvProvider != null) {
            SVNPropertyValue oldKeywords = properties.getSVNPropertyValue("svn:keywords");
            SVNPropertyValue oldEolStyle = properties.getSVNPropertyValue("svn:eol-style");
            boolean wasExecutable = properties.containsName("svn:executable");
            boolean wasNeedsLock = properties.containsName("svn:needs-lock");
            if ((properties = pvProvider.providePropertyValues(path, properties)) == null) {
                properties = new SVNProperties();
            }
            SVNPropertyValue newKeywords = properties.getSVNPropertyValue("svn:keywords");
            SVNPropertyValue newEolStyle = properties.getSVNPropertyValue("svn:eol-style");
            boolean isExecutable = properties.containsName("svn:executable");
            boolean isNeedsLock = properties.containsName("svn:needs-lock");
            if (isExecutable != wasExecutable || isNeedsLock != wasNeedsLock) {
                workItems = context.wqBuildSyncFileFlags(path);
            }
            boolean clearRecordedInfo = !SvnNgPropertiesManager.equals(oldKeywords, newKeywords) || !SvnNgPropertiesManager.equals(oldEolStyle, newEolStyle);
            context.getDb().opSetProps(path, properties, null, clearRecordedInfo, workItems);
            if (workItems != null) {
                context.wqRun(path);
            }
            return;
        }
        boolean clearRecordedInfo = false;
        if (kind == SVNNodeKind.FILE && "svn:keywords".equals(propertyName)) {
            HashMap newKeywords;
            oldValue = properties.getStringValue("svn:keywords");
            Map<Object, Object> keywords = oldValue != null ? context.getKeyWords(path, oldValue) : new HashMap();
            Map<Object, Object> map = newKeywords = value != null ? context.getKeyWords(path, value.getString()) : new HashMap();
            if (!((Object)keywords).equals(newKeywords)) {
                clearRecordedInfo = true;
            }
        } else if (kind == SVNNodeKind.FILE && "svn:eol-style".equals(propertyName)) {
            oldValue = properties.getStringValue("svn:eol-style");
            if (oldValue == null || value == null) {
                clearRecordedInfo = oldValue != null && value == null || oldValue == null && value != null;
            } else {
                boolean bl = clearRecordedInfo = !SVNPropertyValue.create(oldValue).equals(value);
            }
        }
        if (!properties.containsName(propertyName)) {
            action = value == null ? SVNEventAction.PROPERTY_DELETE_NONEXISTENT : SVNEventAction.PROPERTY_ADD;
        } else {
            SVNEventAction sVNEventAction = action = value == null ? SVNEventAction.PROPERTY_DELETE : SVNEventAction.PROPERTY_MODIFY;
        }
        if (value != null) {
            properties.put(propertyName, value);
        } else {
            properties.remove(propertyName);
        }
        context.getDb().opSetProps(path, properties, null, clearRecordedInfo, workItems);
        if (workItems != null) {
            context.wqRun(path);
        }
        if (receiver != null) {
            receiver.receive(SvnTarget.fromFile(path), new SVNPropertyData(propertyName, value, context.getOptions()));
        }
        if (eventHandler != null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(path, SVNNodeKind.NONE, null, -1L, action, action, null, null, 1L, 1L, null, propertyName);
            eventHandler.handleEvent(event, -1.0);
        }
    }

    public static void setAutoProperties(SVNWCContext context, final File path, final SVNProperties properties, ISvnAddParameters addParameters, Runnable onValidationError) throws SVNException {
        ISVNFileContentFetcher fetcher = new ISVNFileContentFetcher(){

            @Override
            public SVNPropertyValue getProperty(String propertyName) throws SVNException {
                return properties.getSVNPropertyValue(propertyName);
            }

            @Override
            public boolean fileIsBinary() throws SVNException {
                SVNPropertyValue mimeType = this.getProperty("svn:mime-type");
                return mimeType != null && SVNProperty.isBinaryMimeType(mimeType.getString());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fetchFileContent(OutputStream os) throws SVNException {
                InputStream is = null;
                try {
                    is = SVNFileUtil.openFileForReading(path);
                    SVNTranslator.copy(is, os);
                }
                catch (IOExceptionWrapper ioew) {
                    throw ioew.getOriginalException();
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                finally {
                    SVNFileUtil.closeFile(is);
                }
            }
        };
        SVNProperties validation = new SVNProperties(properties);
        String detectedMimeType = null;
        for (String propertyName : validation.nameSet()) {
            try {
                SVNPropertyValue pv = SVNPropertiesManager.validatePropertyValue(path, SVNNodeKind.FILE, propertyName, properties.getSVNPropertyValue(propertyName), false, context.getOptions(), fetcher);
                properties.put(propertyName, pv);
            }
            catch (SVNException e) {
                if ("svn:eol-style".equals(propertyName) && e.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET && e.getErrorMessage().getMessage().indexOf("newlines") >= 0) {
                    ISvnAddParameters.Action action = addParameters.onInconsistentEOLs(path);
                    if (action == ISvnAddParameters.Action.REPORT_ERROR) {
                        try {
                            onValidationError.run();
                        }
                        catch (Throwable th) {
                            SVNDebugLog.getDefaultLog().log(SVNLogType.WC, th, Level.INFO);
                        }
                        throw e;
                    }
                    if (action == ISvnAddParameters.Action.ADD_AS_IS) {
                        properties.remove(propertyName);
                        continue;
                    }
                    if (action != ISvnAddParameters.Action.ADD_AS_BINARY) continue;
                    properties.remove(propertyName);
                    detectedMimeType = "application/octet-stream";
                    continue;
                }
                try {
                    onValidationError.run();
                }
                catch (Throwable th) {
                    SVNDebugLog.getDefaultLog().log(SVNLogType.WC, th, Level.INFO);
                }
                throw e;
            }
        }
        if (detectedMimeType != null) {
            properties.put("svn:mime-type", detectedMimeType);
        }
        SVNSkel workItems = null;
        if (properties.containsName("svn:executable") || properties.containsName("svn:needs-lock")) {
            workItems = context.wqBuildSyncFileFlags(path);
        }
        boolean clearRecordedInfo = properties.containsName("svn:keywords") || properties.containsName("svn:eol-style");
        context.getDb().opSetProps(path, properties, null, clearRecordedInfo, workItems);
        if (workItems != null) {
            context.wqRun(path);
        }
    }

    private static boolean equals(SVNPropertyValue oldValue, SVNPropertyValue newValue) {
        if (oldValue == null || newValue == null) {
            return oldValue == newValue;
        }
        return oldValue.equals(newValue);
    }

    public static void checkPropertyName(String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        SVNErrorMessage err;
        if (SVNRevisionProperty.isRevisionProperty(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Revision property ''{0}'' not allowed in this context", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (propertyValue != null && !SVNPropertiesManager.isValidPropertyName(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "Bad property name: ''{0}''", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (SVNProperty.isWorkingCopyProperty(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is a wcprop, thus not accessible to clients", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    public static void categorizeProperties(SVNProperties props, SVNProperties regular, SVNProperties entry, SVNProperties working) {
        for (String name : props.nameSet()) {
            SVNPropertyValue pv = props.getSVNPropertyValue(name);
            if (SVNProperty.isEntryProperty(name) && entry != null) {
                entry.put(name, pv);
                continue;
            }
            if (SVNProperty.isRegularProperty(name) && regular != null) {
                regular.put(name, pv);
                continue;
            }
            if (!SVNProperty.isWorkingCopyProperty(name) || working == null) continue;
            working.put(name, pv);
        }
    }

    public static void splitAndAppend(List<String> patterns, String ignores) {
        if (ignores == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(ignores, "\r\n");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() <= 0) continue;
            patterns.add(token);
        }
    }
}

