/*
 Platypus - program for creating Mac OS X application wrappers around scripts
 Copyright (C) 2003-2010 Sveinbjorn Thordarson <sveinbjornt@simnet.is>
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
 */

// subclass of NSImageView which allows user to drag the image

#import "DraggableImageView.h"
#import "IconFamily.h"

@implementation DraggableImageView

- (void)mouseDown: (NSEvent*)event
{
    //get the Pasteboard used for drag and drop operations
    NSPasteboard* dragPasteboard = [NSPasteboard pasteboardWithName:NSDragPboard];

    //create a new image for our semi-transparent drag image
    NSImage* dragImage = [[NSImage alloc] initWithSize: [[self image] size]]; 
    
	//add the image types we can send the data as(we'll send the actual data when it's requested)
    [dragPasteboard declareTypes: [NSArray arrayWithObject: NSFilenamesPboardType] owner:self];
    
	// create the icon -- it's amazing that we have to do this here
	IconFamily *iconFam = [[IconFamily alloc] initWithThumbnailsOfImage: [self image]];
	[iconFam writeToFile: TMP_DRAGGED_ICON_PATH];
	[iconFam release];
	[dragPasteboard setPropertyList: [NSArray arrayWithObject: @"/tmp/PlatypusIcon.icns"] forType: NSFilenamesPboardType];

    //draw our original image as 50% transparent
    [dragImage lockFocus];	
    [[self image] dissolveToPoint: NSZeroPoint fraction: .5];
    [dragImage unlockFocus];//finished drawing
    [dragImage setScalesWhenResized:YES];//we want the image to resize
    [dragImage setSize: [self bounds].size];//change to the size we are displaying
	
    //execute the drag
    [self dragImage: dragImage					//image to be displayed under the mouse
				 at: [self bounds].origin		//point to start drawing drag image
			 offset: NSZeroSize					//no offset, drag starts at mousedown location
			  event: event						//mousedown event
		 pasteboard: dragPasteboard				//pasteboard to pass to receiver
			 source: self						//object where the image is coming from
		  slideBack: YES];						//if the drag fails slide the icon back
    
	[dragImage release];
}

- (NSDragOperation)draggingSourceOperationMaskForLocal: (BOOL)flag
{
	if (flag)
		return NSDragOperationNone;
	
	//send data as copy operation
    return NSDragOperationCopy;
}

- (BOOL)ignoreModifierKeysWhileDragging
{
	return YES;
}

- (BOOL)acceptsFirstMouse: (NSEvent *)event 
{
	//so source doesn't have to be the active window
    return YES;
}

@end
