/*
SRWebViewContextMenu.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <Cocoa/Cocoa.h>

// WebView context menu
enum {
    SRWebViewGoBackTag = 4100, 
    SRWebViewGoForwardTag = 4101, 
    SRWebViewReloadPageTag = 4102, 
    SRWebViewStopLoadingTag = 4103, 
    
    SROpenLinkInNewTabTag = 4110, 
    SROpenLinkInNewBackgroundTabTag = 4111, 
    SROpenLinkInNewWindowTag = 4112, 
    SROpenLinkInNewBackgroundWindowTag = 4113, 
    SROpenAllLinksInNewTabsTag = 4114, 
    SROpenAllLinksInNewBackgroundTabsTag = 4115, 
    SRDownloadLinkedFileTag = 4116, 
    SRDownloadLinkedFileToLocationTag = 4117, 
    SRAddLinkToBookmarksTag = 4118, 
    SRCopyLinkTag = 4119, 
    
    SROpenImageInNewTabTag = 4120, 
    SROpenImageInNewBackgroundTabTag = 4121, 
    SROpenImageInNewWindowTag = 4122, 
    SROpenImageInNewBackgroundWindowTag = 4123, 
    SRDownloadImageTag = 4124, 
    SRDownloadImageToLocationTag = 4125, 
    SRCopyImageTag = 4126, 
    SRCopyImageURLTag = 4127, 
    SROpenImageInFullScreenTag = 4128, 
    
    SRWebTextCopyTag = 4130, 
    SROpenTextAsURLTag = 4131, 
    
    SROpenFrameInNewTabTag = 4140, 
    SROpenFrameInNewBackgroundTabTag = 4141, 
    SROpenFrameInNewWindowTag = 4142, 
    SROpenFrameInNewBackgroundWindowTag = 4143, 
    SRViewSourceTag = 4144, 
    SRViewFrameSourceTag = 4145, 
    
    SRFindBySearchEngineTag = 4150, 
    SRFindByOtherSearchEngineTag = 4151, 
};

@interface SRWebViewContextMenu : NSObject
{
    IBOutlet id _contextMenu;
}

// Context menu
+ (NSMenu*)contextMenu;

@end
