/*
RSSView.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "RSSBar.h"
#import "RSSView.h"

@implementation RSSView

//--------------------------------------------------------------//
#pragma mark -- Initialize --
//--------------------------------------------------------------//

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    // Configure itself
    [self setAutoresizingMask:NSViewWidthSizable | NSViewHeightSizable];
    
    return self;
}

- (void)_layoutSubviews
{
    // Get frame
    NSRect  frame;
    frame = [[self superview] frame];
    if (NSIsEmptyRect(frame)) {
        return;
    }
    
    // Layout subviews
    static int  _rssBarHeight = 27;
    if (frame.size.height > _rssBarHeight) {
        NSArray*    subviews;
        subviews = [self subviews];
        if ([subviews count] != 1) {
            return;
        }
        subviews = [[subviews objectAtIndex:0] subviews];
        
        NSEnumerator*   enumerator;
        NSView*         subview;
        NSRect          rect, subFrame;
        enumerator = [subviews objectEnumerator];
        while (subview = [enumerator nextObject]) {
            subFrame = [subview frame];
            
            // For RSS bar
            if ([subview isKindOfClass:[RSSBar class]]) {
                rect.origin.x = 0;
                rect.origin.y = frame.size.height - _rssBarHeight;
                rect.size.width = frame.size.width;
                rect.size.height = _rssBarHeight;
                
                if (!NSEqualRects(rect, subFrame)) {
                    [subview setFrame:rect];
                }
            }
            
            // For lower view
            else {
                rect.origin.x = 0;
                rect.origin.y = 0;
                rect.size.width = frame.size.width;
                rect.size.height = frame.size.height - _rssBarHeight;
                
                if (!NSEqualRects(rect, subFrame)) {
                    [subview setFrame:rect];
                }
            }
        }
    }
}

- (void)setFrame:(NSRect)frame
{
    // Invoke super
    [super setFrame:frame];
    
    // Layout subviews
    [self _layoutSubviews];
}

//--------------------------------------------------------------//
#pragma mark -- WebDocumentView protocol --
//--------------------------------------------------------------//

- (void)setDataSource:(WebDataSource*)dataSource
{
}

- (void)dataSourceUpdated:(WebDataSource*)dataSource
{
}

- (void)setNeedsLayout:(BOOL)flag
{
}

- (void)layout
{
    // Get frame
    NSRect  frame;
    frame = [[self superview] frame];
    if (NSIsEmptyRect(frame)) {
        return;
    }
    
    // Set frame
    [self setFrame:frame];
}

- (void)viewWillMoveToHostWindow:(NSWindow*)hostWindow
{
}

- (void)viewDidMoveToHostWindow
{
}

@end
