//
//  AppController.h
//  X-MasTree
//
//  Created by John Schilling on 11/8/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "Tree.h"

#define	SharedAppController [AppController sharedInstance]

@interface AppController : NSObject {
    Tree                        *_tree;
    NSTimer                     *_timer;
    
    float                       _currentTimerSeconds;
    
    int                         _treeSize;
    int                         _treeColor;
    int                         _windowLevel;
    BOOL                        _hasShadow;
    
    BOOL                        _drawRedLights;
    BOOL                        _drawGreenLights;
    BOOL                        _drawBlueLights;
    BOOL                        _drawPurpleLights;
    int                         _lightsRedDensity;
    int                         _lightsGreenDensity;
    int                         _lightsBlueDensity;
    int                         _lightsPurpleDensity;
    int                         _lightsRedMode;
    int                         _lightsGreenMode;
    int                         _lightsBlueMode;
    int                         _lightsPurpleMode;
    
    BOOL                        _useOldStyleLights;
    
    BOOL                        _drawStar;
    int                         _starStyle;
    
    BOOL                        _drawRedOrnaments;
    BOOL                        _drawGreenOrnaments;
    BOOL                        _drawBlueOrnaments;
    BOOL                        _drawPurpleOrnaments;
    BOOL                        _drawTinsel;
    BOOL                        _drawPopcorn;
    BOOL                        _drawPresents;
    BOOL                        _incrementPresents;
    BOOL                        _drawCustomObjects;
    BOOL                        _drawBadge;
    int                         _dateOfXmas;
    BOOL                        _drawDockIcon;
    
    BOOL                        _fastAnimation;
    
    IBOutlet NSWindow           *_settingsPanel;
    IBOutlet NSPopUpButton      *_treeSizeList;
    IBOutlet NSPopUpButton      *_treeColorList;
    IBOutlet NSPopUpButton      *_windowLevelList;
    IBOutlet NSButton           *_hasShadowButton;
    IBOutlet NSButton           *_drawLightsRedButton;
    IBOutlet NSMatrix           *_drawLightsRedMatrix;
    IBOutlet NSMatrix           *_lightsRedModeMatrix;
    IBOutlet NSButton           *_drawLightsGreenButton;
    IBOutlet NSMatrix           *_drawLightsGreenMatrix;
    IBOutlet NSMatrix           *_lightsGreenModeMatrix;
    IBOutlet NSButton           *_drawLightsBlueButton;
    IBOutlet NSMatrix           *_drawLightsBlueMatrix;
    IBOutlet NSMatrix           *_lightsBlueModeMatrix;
    IBOutlet NSButton           *_drawLightsPurpleButton;
    IBOutlet NSMatrix           *_drawLightsPurpleMatrix;
    IBOutlet NSMatrix           *_lightsPurpleModeMatrix;
    IBOutlet NSButton           *_useOldStyleLightsButton;
    IBOutlet NSButton           *_drawStarButton;
    IBOutlet NSMatrix           *_drawStarMatrix;
    IBOutlet NSButton           *_drawRedOrnamentsButton;
    IBOutlet NSButton           *_drawGreenOrnamentsButton;
    IBOutlet NSButton           *_drawBlueOrnamentsButton;
    IBOutlet NSButton           *_drawPurpleOrnamentsButton;
    IBOutlet NSButton           *_drawTinselButton;
    IBOutlet NSButton           *_drawPopcornButton;
    IBOutlet NSButton           *_drawPresentsButton;
    IBOutlet NSButton           *_incrementPresentsButton;
    IBOutlet NSButton           *_drawBadgeButton;
    IBOutlet NSPopUpButton      *_xmasDateList;
    IBOutlet NSButton           *_drawDockIconButton;
    IBOutlet NSButton           *_fastAnimationButton;
}

+ (AppController *)sharedInstance;

- (void)loadPreferences;
- (void)savePreferences;

- (void)initTreeWithSize:(int)treeSize color:(int)treeColor;
- (void)releaseTree;

- (int)treeSize;
- (int)treeColor;
- (int)drawRedLights;
- (int)drawGreenLights;
- (int)drawBlueLights;
- (int)drawPurpleLights;
- (int)lightsRedMode;
- (int)lightsGreenMode;
- (int)lightsBlueMode;
- (int)lightsPurpleMode;
- (BOOL)useOldStyleLights;
- (BOOL)drawRedOrnaments;
- (BOOL)drawGreenOrnaments;
- (BOOL)drawBlueOrnaments;
- (BOOL)drawPurpleOrnaments;
- (BOOL)drawTinsel;
- (BOOL)drawPopcorn;
- (int)drawStar;
- (int)drawPresents;
- (BOOL)drawCustomObjects;
- (BOOL)drawBadger;
- (BOOL)drawDockIcon;


- (void)setupSettingsPanel;
- (IBAction)openSettingsPanel:(id)sender;
- (IBAction)userSetTreeSize:(id)sender;
- (IBAction)userSetTreeColor:(id)sender;
- (IBAction)userSetWindowLevel:(id)sender;
- (IBAction)userSetHasShadow:(id)sender;
- (IBAction)userSetDrawLightsRed:(id)sender;
- (IBAction)userSetDrawLightsGreen:(id)sender;
- (IBAction)userSetDrawLightsBlue:(id)sender;
- (IBAction)userSetDrawLightsPurple:(id)sender;
- (IBAction)userSetRedLightsDensity:(id)sender;
- (IBAction)userSetGreenLightsDensity:(id)sender;
- (IBAction)userSetBlueLightsDensity:(id)sender;
- (IBAction)userSetPurpleLightsDensity:(id)sender;
- (IBAction)userSetRedLightMode:(id)sender;
- (IBAction)userSetGreenLightMode:(id)sender;
- (IBAction)userSetBlueLightMode:(id)sender;
- (IBAction)userSetPurpleLightMode:(id)sender;
- (IBAction)userSetUseOldStyleLights:(id)sender;
- (IBAction)userSetDrawStar:(id)sender;
- (IBAction)userSetDrawStyle:(id)sender;
- (IBAction)userSetDrawRedOrnaments:(id)sender;
- (IBAction)userSetDrawGreenOrnaments:(id)sender;
- (IBAction)userSetDrawBlueOrnaments:(id)sender;
- (IBAction)userSetDrawPurpleOrnaments:(id)sender;
- (IBAction)userSetDrawTinsel:(id)sender;
- (IBAction)userSetDrawPopcorn:(id)sender;
- (IBAction)userSetDrawPresents:(id)sender;
- (IBAction)userSetIncrementPresents:(id)sender;
- (IBAction)userSetDrawBadge:(id)sender;
- (IBAction)userSetXmasDate:(id)sender;
- (IBAction)userSetDrawDockIcon:(id)sender;
- (IBAction)userSetUseFastAnimation:(id)sender;

- (void)checkTimerAndUpdateTree;
- (void)startTimerWithSeconds:(float)seconds;
- (void)stopTimer;
- (void)animate:(NSTimer *)timer;

- (int)daysUntilChristmas;

@end
